<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>MGA TV - Destaques Corrigidos</title>
<style>
    /* --- RESET & GERAL --- */
    * { box-sizing: border-box; }
    body, html { margin: 0; padding: 0; width: 100%; height: 100%; overflow: hidden; background-color: #ffffff; font-family: 'Segoe UI', Arial, sans-serif; }

    /* LAYOUT OFERTAS */
    #ofertas-container {
        position: absolute; top: 0; left: 0; width: 100%; height: 100%;
        background: #fff; z-index: 10;
        display: flex; flex-direction: column;
        transition: opacity 0.5s;
    }

    /* CABEÇALHO */
    header { height: 14vh; background: #d32f2f; color: white; display: flex; align-items: center; padding: 0 3vw; box-shadow: 0 1vh 2vh rgba(0,0,0,0.2); }
    header h1 { font-size: 6vh; margin: 0; flex-grow: 1; text-transform: uppercase; font-weight: 800; letter-spacing: 0.2vw; }
    header .logo-area { font-size: 2.5vh; background: white; color: #d32f2f; padding: 1vh 2vw; border-radius: 5vh; font-weight: bold; }

    /* CORPO DIVIDIDO */
    #layout-principal { display: flex; width: 100%; height: 86vh; padding: 2vh 2vw; gap: 2vw; }
    
    /* ESQUERDA (LISTA) */
    #coluna-lista { width: 65%; height: 100%; display: flex; flex-direction: column; gap: 1.5vh; }
    
    .linha-produto { background: #fff9c4; flex: 1; border-radius: 2vh; display: flex; align-items: center; padding: 0 1.5vw; box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.1); border-left: 1.5vw solid #d32f2f; overflow: hidden; }
    .linha-vazia { background: transparent !important; border: none !important; box-shadow: none !important; flex: 1; }
    .img-tabela { height: 80%; aspect-ratio: 1/1; object-fit: contain; margin-right: 1.5vw; background: #fff; border-radius: 1vh; border: 1px solid #e6e6e6; }
    .nome-tabela { flex-grow: 1; font-size: 4.5vh; color: #333; font-weight: 700; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; line-height: 1.1; }
    .preco-box-tabela { text-align: right; min-width: 18vw; display: flex; align-items: center; justify-content: flex-end; }
    .moeda-tab { font-size: 2.5vh; color: #555; font-weight: bold; margin-right: 5px; margin-top: -2vh; }
    .valor-tab { font-size: 7vh; font-weight: 800; color: #d32f2f; line-height: 1; }
    .un-tab { font-size: 2vh; color: #777; font-weight: 600; align-self: flex-end; margin-bottom: 1.5vh; margin-left: 5px; }
    
    /* DIREITA (DESTAQUE) */
    #coluna-destaque { width: 33%; height: 100%; }
    .card-destaque { width: 100%; height: 100%; background: #d32f2f; border-radius: 3vh; border: 0.5vh solid #ffc107; display: flex; flex-direction: column; overflow: hidden; position: relative; }
    .topo-destaque { height: 10%; background: #b71c1c; color: #ffc107; display: flex; align-items: center; justify-content: center; font-size: 3vh; font-weight: 900; text-transform: uppercase; }
    .area-foto-destaque { height: 50%; width: 100%; padding: 2vh; display: flex; align-items: center; justify-content: center; background: radial-gradient(circle, #e57373 0%, #d32f2f 100%); }
    .foto-destaque { max-width: 95%; max-height: 95%; object-fit: contain; filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.5)); transition: transform 0.5s; }
    
    .info-destaque { height: 40%; background: #d32f2f; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 1vh; }
    .nome-destaque { font-size: 3.5vh; color: #ffffff; font-weight: 800; text-align: center; margin-bottom: 1vh; line-height: 1.1; }
    
    .preco-container-destaque { display: flex; align-items: flex-start; justify-content: center; line-height: 1; }
    .rs-destaque { font-size: 4vh; color: #ffc107; font-weight: bold; margin-right: 0.5vw; margin-top: 1vh; }
    .valor-destaque { font-size: 11vh; color: #ffffff; font-weight: 900; letter-spacing: -0.3vh; text-shadow: 2px 2px 4px rgba(0,0,0,0.3); }
    .un-destaque { font-size: 2.5vh; color: #ffc107; font-weight: bold; align-self: flex-end; margin-bottom: 1.5vh; margin-left: 0.5vw; }

    /* CAMADA VÍDEO */
    #video-container {
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: black; 
        z-index: 99999; 
        display: none; 
        align-items: center; justify-content: center;
        transform: translateZ(0);
    }
    video { width: 100%; height: 100%; object-fit: contain; background: black; }

    #indicador-rede { position: fixed; bottom: 10px; right: 10px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 100000; }
</style>
</head>
<body>

    <div id="ofertas-container">
        <header><h1>Ofertas do Dia</h1><div class="logo-area">Confira</div></header>
        <div id="layout-principal">
            
            <div id="coluna-lista"></div>
            
            <div id="coluna-destaque">
                <div class="card-destaque" id="painel-destaque">
                    <div class="topo-destaque">Super Oferta</div>
                    <div class="area-foto-destaque"><img id="img-d" src="" class="foto-destaque"></div>
                    <div class="info-destaque">
                        <div id="nome-d" class="nome-destaque">...</div>
                        <div class="preco-container-destaque">
                            <span class="rs-destaque">R$</span>
                            <span id="preco-d" class="valor-destaque">...</span>
                            <span id="un-d" class="un-destaque">/un</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="paginacao" id="texto-paginacao" style="position:absolute; bottom:1vh; left:3vw; font-size:2vh; color:#999;"></div>
    </div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>
    
    <div id="indicador-rede"></div>

    <script>
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php'; 
        
        // --- CONFIGURAÇÕES ---
        var ITENS_POR_LISTA = 5;      
        var TEMPO_TROCA_PRODUTO = 6000; 
        var LOOPS_PARA_INTERVALO = 5; // A cada 5 voltas da lista, toca vídeo
        var TEMPO_ATUALIZACAO = 60000; 
        
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
        
        // Listas Separadas
        var listaProdutos = []; // Todos os produtos (para a lista)
        var listaDestaques = []; // Apenas marcados como destaque (para o card direito)
        var listaVideos = []; // Apenas vídeos
        
        var indiceProduto = 0; // Índice da lista esquerda
        var indiceDestaqueLateral = 0; // Índice do card direita
        var indiceVideo = 0;
        
        var contadorLoops = 0; 
        var timerOfertas = null;
        var monitorTravamento = null;

        function formatarMoeda(valor) {
            if (!valor) return "0,00";
            let v = String(valor).replace(',', '.');
            let floatV = parseFloat(v);
            if (isNaN(floatV)) return valor; 
            return floatV.toFixed(2).replace('.', ',');
        }

        function verificarDisponibilidade(item) {
            if (!item.data_inicio && !item.hora_inicio) return true;
            var agora = new Date();
            var hoje = agora.toISOString().split('T')[0];
            var hora = agora.toTimeString().split(' ')[0];
            if (item.data_inicio && item.data_inicio !== '0000-00-00' && hoje < item.data_inicio) return false;
            if (item.data_fim && item.data_fim !== '0000-00-00' && hoje > item.data_fim) return false;
            if (item.hora_inicio && item.hora_inicio !== '00:00:00' && hora < item.hora_inicio) return false;
            if (item.hora_fim && item.hora_fim !== '00:00:00' && hora > item.hora_fim) return false;
            return true;
        }

        function baixarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            var xhr = new XMLHttpRequest();
            xhr.open("GET", API_URL + '?uid=' + uid + '&t=' + new Date().getTime(), true);
            xhr.onload = function() {
                if(xhr.status == 200) {
                    try {
                        var json = JSON.parse(xhr.responseText);
                        if(!Array.isArray(json)) json = [json];
                        
                        var validos = json.filter(verificarDisponibilidade);
                        
                        // 1. VÍDEOS
                        listaVideos = validos.filter(i => i.tipo_midia === 'video' || (i.imagem && i.imagem.match(/\.(mp4|webm|ogg)$/i)));
                        
                        // 2. PRODUTOS (Para a lista da esquerda)
                        listaProdutos = validos.filter(i => i.tipo_midia !== 'video' && !(i.imagem && i.imagem.match(/\.(mp4|webm|ogg)$/i)));
                        
                        // 3. DESTAQUES (Para o card da direita - Apenas marcados com destaque)
                        listaDestaques = listaProdutos.filter(i => i.destaque == 1 || i.destaque == "1" || i.destaque == true);
                        
                        // Se não tiver nenhum destaque marcado, usa todos os produtos para não ficar vazio
                        if(listaDestaques.length === 0) listaDestaques = listaProdutos;

                        document.getElementById('indicador-rede').style.background = '#28a745';
                        
                        if (!timerOfertas && listaProdutos.length > 0) { rodarOfertas(); }
                    } catch(e) { console.log(e); }
                }
            };
            xhr.send();
        }

        // --- MODO OFERTAS ---
        function rodarOfertas() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('ofertas-container').style.opacity = '1';
            
            var player = document.getElementById('player');
            if(!player.paused) player.pause();
            clearInterval(monitorTravamento);

            if (listaProdutos.length === 0) {
                if(listaVideos.length > 0) { iniciarComercial(); return; }
                timerOfertas = setTimeout(baixarDados, 3000); 
                return;
            }

            // CONTADOR DE LOOPS DA LISTA
            if (indiceProduto >= listaProdutos.length) {
                indiceProduto = 0; 
                contadorLoops++;   
                
                // HORA DO INTERVALO?
                if (contadorLoops >= LOOPS_PARA_INTERVALO) {
                    if (listaVideos.length > 0) {
                        contadorLoops = 0; 
                        clearTimeout(timerOfertas);
                        iniciarComercial(); 
                        return;
                    }
                }
            }

            // --- 1. Atualiza LISTA LATERAL (Segue indiceProduto) ---
            atualizarListaLateral();

            // --- 2. Atualiza CARD DIREITA (Segue indiceDestaqueLateral) ---
            // O card da direita tem seu próprio ritmo independente
            if(listaDestaques.length > 0) {
                if(indiceDestaqueLateral >= listaDestaques.length) indiceDestaqueLateral = 0;
                var itemDestaque = listaDestaques[indiceDestaqueLateral];
                atualizarPainelDestaque(itemDestaque);
                indiceDestaqueLateral++;
            }

            // Avança Lista
            indiceProduto += ITENS_POR_LISTA; // Pula de 5 em 5 para paginação
            if(indiceProduto > listaProdutos.length) indiceProduto = 0; // Correção segurança

            timerOfertas = setTimeout(rodarOfertas, TEMPO_TROCA_PRODUTO);
        }

        function atualizarPainelDestaque(item) {
            var painel = document.getElementById('painel-destaque');
            painel.style.opacity = 0; 
            setTimeout(() => {
                var img = item.imagem || placeholder;
                document.getElementById('img-d').src = img;
                document.getElementById('nome-d').innerText = item.produto;
                document.getElementById('preco-d').innerText = formatarMoeda(item.preco);
                document.getElementById('un-d').innerText = '/' + (item.unidade || 'un');
                painel.style.opacity = 1; 
            }, 300);
        }

        function atualizarListaLateral() {
            var container = document.getElementById('coluna-lista');
            container.innerHTML = '';
            
            // Loop para pegar os próximos 5 itens da lista geral
            // Como indiceProduto pula de 5 em 5, aqui apenas iteramos
            for(var i=0; i < ITENS_POR_LISTA; i++) {
                var idx = (indiceProduto + i) % listaProdutos.length;
                var item = listaProdutos[idx];
                
                var html = `
                    <div class="linha-produto">
                        <img src="${item.imagem || placeholder}" class="img-tabela" onerror="this.src='${placeholder}'">
                        <div class="nome-tabela">${item.produto}</div>
                        <div class="preco-box-tabela">
                            <span class="moeda-tab">R$</span>
                            <span class="valor-tab">${formatarMoeda(item.preco)}</span>
                            <span class="un-tab">/${item.unidade || 'un'}</span>
                        </div>
                    </div>`;
                container.insertAdjacentHTML('beforeend', html);
            }
            
            var pag = Math.ceil((indiceProduto + 1) / ITENS_POR_LISTA);
            var tot = Math.ceil(listaProdutos.length / ITENS_POR_LISTA);
            document.getElementById('texto-paginacao').innerText = `Lista ${pag}/${tot}`;
        }

        // --- MODO COMERCIAL ---
        function iniciarComercial() {
            document.getElementById('ofertas-container').style.opacity = '0';
            var containerVid = document.getElementById('video-container');
            containerVid.style.display = 'flex'; 

            if (indiceVideo >= listaVideos.length) indiceVideo = 0;
            var videoItem = listaVideos[indiceVideo];
            
            var player = document.getElementById('player');
            player.src = videoItem.imagem;
            player.loop = false; 
            player.currentTime = 0;
            
            player.muted = true; // Inicia mudo (regra Android)
            var promessa = player.play();
            if (promessa !== undefined) {
                promessa.then(_ => { player.muted = false; })
                .catch(error => { player.muted = true; player.play(); }); 
            }

            // Watchdog (Travamento)
            var ultimoTempo = -1;
            var tentativas = 0;
            clearInterval(monitorTravamento);
            
            monitorTravamento = setInterval(function() {
                if(!player.paused && player.currentTime === ultimoTempo) {
                    tentativas++;
                } else {
                    tentativas = 0;
                    ultimoTempo = player.currentTime;
                }
                if(tentativas > 4) { encerrarComercial(); }
            }, 1000);

            player.onended = function() { encerrarComercial(); };
            player.onerror = function() { encerrarComercial(); };
        }

        function encerrarComercial() {
            var player = document.getElementById('player');
            clearInterval(monitorTravamento);
            
            player.pause();
            player.removeAttribute('src'); 
            player.load(); 

            indiceVideo++;
            rodarOfertas();
        }

        window.onload = function() {
            baixarDados();
            setInterval(baixarDados, TEMPO_ATUALIZACAO);
        };

    </script>
</body>
</html>