<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Ofertas Farmácia (1-4-1)</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&family=Montserrat:wght@700&display=swap" rel="stylesheet">
<style type="text/css">
    /* --- RESET & GERAL --- */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background-color: #f0f8ff; 
        font-family: 'Roboto', 'Arial', sans-serif;
        overflow: hidden;
    }

    /* --- LOGO FLUTUANTE --- */
    .logo-tv {
        position: absolute; top: 1vh; right: 2vw; height: 10vh; width: auto; z-index: 200;
        filter: drop-shadow(0 2px 5px rgba(0,0,0,0.2)); display: none;
        background: white; padding: 5px; border-radius: 10px;
    }

    /* --- TOPO --- */
    #topo {
        width: 100%; height: 15vh; 
        background: linear-gradient(135deg, #0d47a1 0%, #1976d2 100%);
        border-bottom: 0.8vh solid #00bcd4; 
        text-align: center;
        position: absolute; top: 0; left: 0; z-index: 100;
        box-shadow: 0 0.5vh 2vh rgba(0,0,0,0.2);
        display: flex; align-items: center; justify-content: center;
    }
    #topo h1 {
        font-family: 'Montserrat', sans-serif;
        font-weight: 700;
        font-size: 7vh; 
        color: #ffffff; 
        text-transform: uppercase; margin: 0;
        letter-spacing: 0.3vw;
        text-shadow: 0 0.2vh 0.5vh rgba(0,0,0,0.3);
        margin-right: 15vw; /* Espaço para Logo */
    }
    .cross-icon { color: #00bcd4; margin-right: 2vw; font-size: 6vh; font-weight: bold; }

    /* --- ÁREA PRINCIPAL --- */
    #main-container {
        position: absolute; top: 15vh; left: 0; width: 100%; height: 85vh;
        padding: 2vh 1.5vw;
        display: flex; gap: 1.5vw; transition: opacity 0.5s;
    }

    .col-lateral { width: 25%; height: 100%; }
    
    /* Grid Central 2x2 */
    .col-central { 
        width: 50%; height: 100%; 
        display: grid;
        grid-template-columns: 1fr 1fr;
        grid-template-rows: 1fr 1fr;
        gap: 2vh;
    }

    /* --- CARD LATERAL --- */
    .card-lateral {
        width: 100%; height: 100%;
        background: white; border-radius: 2vh;
        box-shadow: 0 1vh 3vh rgba(13, 71, 161, 0.15); 
        border: 0.3vh solid #bbdefb; 
        position: relative;
        display: flex; flex-direction: column; 
        justify-content: space-between; overflow: hidden;
        animation: fadeIn 0.8s ease;
    }
    .lat-tag {
        position: absolute; top: 0; right: 0; 
        background: #00bcd4; color: #fff; 
        padding: 0.8vh 2vw; font-weight: 900; font-size: 2.2vh;
        border-bottom-left-radius: 2vh; z-index: 20; letter-spacing: 1px;
    }
    .lat-img {
        width: 100%; flex-grow: 1; 
        display: flex; align-items: center; justify-content: center;
        padding: 2vh; z-index: 10; min-height: 0;
        background: radial-gradient(circle, #fff 40%, #e3f2fd 100%);
    }
    .lat-img img { max-height: 90%; max-width: 90%; object-fit: contain; }
    .lat-info {
        width: 100%; height: 35%; background: #fff; border-top: 1px solid #e3f2fd;
        display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 1vh;
    }
    .lat-nome {
        width: 100%; text-align: center; color: #0d47a1; 
        font-weight: 700; font-size: 3vh; line-height: 1.2; text-transform: uppercase;
        margin-bottom: 1vh; overflow: hidden;
    }
    .lat-preco-box { display: flex; align-items: flex-start; justify-content: center; line-height: 1; color: #0d47a1; }
    .lat-rs { font-size: 3vh; font-weight: bold; margin-top: 1vh; margin-right: 0.5vw; color: #0288d1; }
    .lat-valor { font-family: 'Roboto', sans-serif; font-size: 8vh; font-weight: 900; letter-spacing: -2px; }
    .lat-un { font-size: 2vh; font-weight: 600; color: #78909c; align-self: flex-end; margin-bottom: 1.5vh; margin-left: 0.5vw;}

    /* --- CARD CENTRAL --- */
    .card-central {
        width: 100%; height: 100%; background: white; border-radius: 2vh; 
        box-shadow: 0 0.5vh 1.5vh rgba(0,0,0,0.05); border: 1px solid #e1f5fe;
        display: flex; flex-direction: column; overflow: hidden; animation: fadeIn 0.8s ease;
    }
    .cen-img { width: 100%; height: 60%; display: flex; align-items: center; justify-content: center; padding: 1vh; }
    .cen-img img { max-height: 90%; max-width: 90%; object-fit: contain; }
    .cen-info {
        width: 100%; height: 40%; padding: 0 1vh;
        display: flex; flex-direction: column; justify-content: center; align-items: center;
        background: #fbfdff; border-top: 1px solid #f0f0f0;
    }
    .cen-nome {
        width: 100%; text-align: center; color: #455a64; font-weight: 700; font-size: 2.2vh; 
        line-height: 1.1; text-transform: uppercase; margin-bottom: 0.5vh;
        white-space: nowrap; overflow: hidden; text-overflow: ellipsis;
    }
    .cen-preco-box { display: flex; align-items: center; justify-content: center; color: #0277bd; }
    .cen-valor { font-family: 'Roboto', sans-serif; font-size: 5vh; font-weight: 900; letter-spacing: -1px; }
    .cen-rs { font-size: 2vh; font-weight: bold; margin-right: 0.3vw; vertical-align: top; }
    .cen-un { font-size: 1.5vh; color: #90a4ae; font-weight: 600; align-self: flex-end; margin-bottom: 1vh; margin-left: 0.3vw;}

    /* VÍDEO */
    #video-container { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: black; z-index: 9999; display: none; align-items: center; justify-content: center; }
    video { width: 100%; height: 100%; object-fit: contain; }

    #status-msg { position: fixed; bottom: 50%; left: 50%; transform: translate(-50%,50%); background: rgba(0,0,0,0.8); color: white; padding: 20px; border-radius: 10px; display: none; z-index: 99999; }
    .paginacao { position: fixed; bottom: 5px; right: 5px; font-size: 2vh; color: #999; font-weight: bold; }
    @keyframes fadeIn { from { opacity: 0; transform: translateY(2vh); } to { opacity: 1; transform: translateY(0); } }
</style>
</head>
<body>

    <img id="img-logo-topo" class="logo-tv" src="">

    <div id="topo">
        <span class="cross-icon">+</span>
        <h1>Ofertas da Semana</h1>
    </div>

    <div id="status-msg">Carregando...</div>

    <div id="main-container">
        <div class="col-lateral" id="col-esquerda"></div>
        <div class="col-central" id="col-centro"></div>
        <div class="col-lateral" id="col-direita"></div>
        <div class="paginacao" id="texto-paginacao"></div>
    </div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>

    <script type="text/javascript">
        var API_URL = '../destaque-mercado.php'; 
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/883/883407.png';
        
        var TEMPO_TROCA = 8000; 
        var ITENS_POR_PAGINA = 6;
        var LOOPS_PARA_COMERCIAL = 3;
        var TEMPO_ATUALIZACAO = 60000; 
        
        var listaProdutos = [];
        var listaVideos = [];
        var idxProd = 0;
        var idxVideo = 0;
        var loops = 0;
        var timer = null;

        function formatarMoeda(val) {
            let v = parseFloat(String(val).replace(',', '.'));
            return isNaN(v) ? "0,00" : v.toFixed(2).replace('.', ',');
        }

        function baixarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            fetch(API_URL + '?uid=' + uid + '&t=' + Date.now())
                .then(r => r.json())
                .then(json => {
                    var dadosItens = [];
                    // Lógica Logo
                    if (json.itens) {
                        dadosItens = json.itens;
                        var logoEl = document.getElementById('img-logo-topo');
                        if (json.meta && json.meta.logo) {
                            logoEl.src = json.meta.logo; logoEl.style.display = 'block';
                        } else { logoEl.style.display = 'none'; }
                    } else { dadosItens = Array.isArray(json) ? json : []; }

                    listaVideos = dadosItens.filter(i => i.is_video == 1 || (i.imagem && i.imagem.match(/\.(mp4|webm)$/i)));
                    listaProdutos = dadosItens.filter(i => i.is_video != 1 && !(i.imagem && i.imagem.match(/\.(mp4|webm)$/i)));
                    
                    if(listaProdutos.length === 0 && listaVideos.length === 0) {
                        document.getElementById('status-msg').style.display = 'block';
                        document.getElementById('status-msg').innerText = "Sem conteúdo.";
                    } else {
                        document.getElementById('status-msg').style.display = 'none';
                        if (!timer) rodarOfertas();
                    }
                })
                .catch(e => console.log(e));
        }

        function getHtmlLateral(item) {
            if(!item) return '<div class="card-lateral" style="opacity:0"></div>';
            var img = item.imagem || placeholder;
            if(img && !img.includes('http') && !img.startsWith('../')) img = '../' + img;

            return `
            <div class="card-lateral">
                <div class="lat-tag">OFERTA</div>
                <div class="lat-img"><img src="${img}" onerror="this.src='${placeholder}'"></div>
                <div class="lat-info">
                    <div class="lat-nome">${item.produto}</div>
                    <div class="lat-preco-box">
                        <span class="lat-rs">R$</span>
                        <span class="lat-valor">${formatarMoeda(item.preco)}</span>
                        <span class="lat-un">/${item.unidade || 'un'}</span>
                    </div>
                </div>
            </div>`;
        }

        function getHtmlCentral(item) {
            if(!item) return '<div class="card-central" style="opacity:0"></div>';
            var img = item.imagem || placeholder;
            if(img && !img.includes('http') && !img.startsWith('../')) img = '../' + img;

            return `
            <div class="card-central">
                <div class="cen-img"><img src="${img}" onerror="this.src='${placeholder}'"></div>
                <div class="cen-info">
                    <div class="cen-nome">${item.produto}</div>
                    <div class="cen-preco-box">
                        <span class="cen-rs">R$</span>
                        <span class="cen-valor">${formatarMoeda(item.preco)}</span>
                        <span class="cen-un">/${item.unidade || 'un'}</span>
                    </div>
                </div>
            </div>`;
        }

        function rodarOfertas() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('main-container').style.opacity = '1';
            document.getElementById('topo').style.opacity = '1';
            document.getElementById('player').pause();

            if (listaProdutos.length === 0) {
                if(listaVideos.length > 0) { rodarVideo(); return; }
                timer = setTimeout(baixarDados, 3000); return;
            }

            if (idxProd >= listaProdutos.length) {
                idxProd = 0;
                loops++;
                if (loops >= LOOPS_PARA_COMERCIAL && listaVideos.length > 0) {
                    loops = 0; clearTimeout(timer); rodarVideo(); return;
                }
            }

            var colEsq = document.getElementById('col-esquerda');
            var colCen = document.getElementById('col-centro');
            var colDir = document.getElementById('col-direita');
            colEsq.innerHTML = ''; colCen.innerHTML = ''; colDir.innerHTML = '';

            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var item = listaProdutos[(idxProd + i) % listaProdutos.length];
                if(listaProdutos.length <= 1 && i > 0) item = null;

                if (i === 0) colEsq.innerHTML = getHtmlLateral(item);
                else if (i >= 1 && i <= 4) colCen.innerHTML += getHtmlCentral(item);
                else if (i === 5) colDir.innerHTML = getHtmlLateral(item);
            }

            var pag = Math.ceil((idxProd + 1) / ITENS_POR_PAGINA);
            var tot = Math.ceil(listaProdutos.length / ITENS_POR_PAGINA);
            document.getElementById('texto-paginacao').innerText = `Pág ${pag}/${tot}`;

            idxProd += ITENS_POR_PAGINA;
            timer = setTimeout(rodarOfertas, TEMPO_TROCA);
        }

        function rodarVideo() {
            var itemVideo = listaVideos[idxVideo % listaVideos.length];
            var player = document.getElementById('player');
            
            document.getElementById('main-container').style.opacity = '0';
            document.getElementById('topo').style.opacity = '0';
            document.getElementById('video-container').style.display = 'flex';
            
            var src = itemVideo.imagem;
            if(src && !src.includes('http') && !src.startsWith('../')) src = '../' + src;
            
            player.src = src;
            player.loop = false; player.muted = false;
            player.play().catch(() => { player.muted = true; player.play(); });

            var check = setTimeout(() => { if(player.readyState < 2) encerrarComercial(); }, 8000);
            player.onended = function() { clearTimeout(check); encerrarComercial(); };
            player.onerror = function() { clearTimeout(check); encerrarComercial(); };
        }

        function encerrarComercial() {
            var player = document.getElementById('player');
            player.pause(); player.removeAttribute('src'); player.load();
            idxVideo++;
            rodarOfertas();
        }

        window.onload = function() { baixarDados(); setInterval(baixarDados, TEMPO_ATUALIZACAO); };
    </script>
</body>
</html>