<?php
session_start();
require 'config.php';

$erro = "";
$sucesso = "";

// LOGIN
if (isset($_POST['acao']) && $_POST['acao'] == 'logar') {
    $user = trim($_POST['usuario']);
    $pass = trim($_POST['senha']);
    
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE usuario = ?");
    $stmt->execute([$user]);
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($dados && password_verify($pass, $dados['senha'])) {
        // VERIFICA SE ESTÁ ATIVO
        if ($dados['ativo'] == 1) {
            $_SESSION['usuario_id'] = $dados['id'];
            $_SESSION['nome_empresa'] = $dados['nome_empresa'];
            $_SESSION['is_admin'] = $dados['is_admin']; // Grava se é chefe na sessão
            
            // Se for Admin, vai pro painel mestre, se não, painel comum
            if($dados['is_admin'] == 1) {
                header("Location: admin_master.php");
            } else {
                header("Location: painel.php");
            }
            exit;
        } else {
            $erro = "Sua conta aguarda aprovação ou foi bloqueada.";
        }
    } else {
        $erro = "Usuário ou senha incorretos.";
    }
}

// CADASTRO
if (isset($_POST['acao']) && $_POST['acao'] == 'cadastrar') {
    $user = trim($_POST['usuario']);
    $pass = trim($_POST['senha']);
    $empresa = trim($_POST['empresa']);

    $stmt = $pdo->prepare("SELECT count(*) FROM usuarios WHERE usuario = ?");
    $stmt->execute([$user]);
    if ($stmt->fetchColumn() > 0) {
        $erro = "Usuário já existe.";
    } else {
        $hash = password_hash($pass, PASSWORD_DEFAULT);
        // CRIA COMO 'ativo = 0' (PENDENTE DE APROVAÇÃO)
        $stmt = $pdo->prepare("INSERT INTO usuarios (usuario, senha, nome_empresa, ativo, is_admin) VALUES (?, ?, ?, 0, 0)");
        
        if($stmt->execute([$user, $hash, $empresa])) {
            $sucesso = "Conta criada! Aguarde o administrador liberar seu acesso.";
        } else {
            $erro = "Erro ao cadastrar.";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Acesso ao Sistema</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark d-flex align-items-center justify-content-center" style="height: 100vh;">

<div class="card shadow p-4" style="width: 400px;">
    <h3 class="text-center mb-4">MGA Ofertas</h3>
    
    <?php if($erro): ?><div class="alert alert-danger"><?= $erro ?></div><?php endif; ?>
    <?php if($sucesso): ?><div class="alert alert-success"><?= $sucesso ?></div><?php endif; ?>

    <ul class="nav nav-pills mb-3 justify-content-center" id="pills-tab" role="tablist">
        <li class="nav-item"><button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-login">Login</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-cadastro">Criar Conta</button></li>
    </ul>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="pills-login">
            <form method="POST">
                <input type="hidden" name="acao" value="logar">
                <div class="mb-3"><label>Usuário</label><input type="text" name="usuario" class="form-control" required></div>
                <div class="mb-3"><label>Senha</label><input type="password" name="senha" class="form-control" required></div>
                <button class="btn btn-primary w-100">Entrar</button>
            </form>
        </div>
        <div class="tab-pane fade" id="pills-cadastro">
            <form method="POST">
                <input type="hidden" name="acao" value="cadastrar">
                <div class="mb-3"><label>Nome da Empresa</label><input type="text" name="empresa" class="form-control" required></div>
                <div class="mb-3"><label>Usuário</label><input type="text" name="usuario" class="form-control" required></div>
                <div class="mb-3"><label>Senha</label><input type="password" name="senha" class="form-control" required></div>
                <div class="alert alert-info small">Seu cadastro passará por aprovação.</div>
                <button class="btn btn-success w-100">Criar Conta</button>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>