<?php
// formulario.php - VERSÃO PREMIUM (COM AGENDAMENTO, VÍDEO E BUSCA GOOGLE)
require 'lock.php';
require 'config.php';

$meu_id = $_SESSION['usuario_id'];

// --- HELPERS MANTIDOS ---
function gerarNomeAmigavel($string) {
    $string = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
    $string = preg_replace('/[^a-zA-Z0-9 -]/', '', $string);
    $string = str_replace(' ', '-', $string);
    return strtolower(trim(preg_replace('/-+/', '-', $string), '-'));
}

function baixarImagemWeb($url, $pastaDestino, $nomeBase) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $dadosImagem = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($httpCode == 200 && $dadosImagem) {
        $sufixo = substr(md5(time()), 0, 4); 
        $nomeArquivo = $nomeBase . "-" . $sufixo . ".png";
        $caminhoFisico = $pastaDestino . $nomeArquivo;
        if(file_put_contents($caminhoFisico, $dadosImagem)) return $nomeArquivo;
    }
    return false;
}

function converterPrecoParaBanco($valor) {
    if(!$valor) return 0.00;
    $valor = str_replace('R$', '', $valor);
    $valor = str_replace('.', '', $valor); 
    $valor = str_replace(',', '.', $valor); 
    return $valor;
}

// INICIALIZA VARIÁVEIS
$id = ""; $produto = ""; $preco = ""; $unidade = "un"; $destaque = 0;
$categoria = "Geral"; $filial_id = ""; $ativo = 1; $codigo_balanca = ""; $imagemAtual = "";
// Novas variáveis Premium
$tipo_midia = "imagem"; 
$is_video = 0; // Controle do checkbox
$data_inicio = ""; $data_fim = ""; $hora_inicio = ""; $hora_fim = "";

// Verifica se veio do botão "Novo Vídeo"
if(isset($_GET['tipo']) && $_GET['tipo'] == 'video') {
    $is_video = 1;
    $tipo_midia = 'video';
    $preco = "0,00";
}

// LISTAS
$stmt = $pdo->prepare("SELECT * FROM categorias WHERE usuario_id = ? ORDER BY nome ASC");
$stmt->execute([$meu_id]);
$listaCategorias = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $pdo->prepare("SELECT * FROM filiais WHERE usuario_id = ? ORDER BY nome ASC");
$stmt->execute([$meu_id]);
$listaFiliais = $stmt->fetchAll(PDO::FETCH_ASSOC);

// CARREGAR DADOS (EDIÇÃO)
if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $stmt = $pdo->prepare("SELECT * FROM ofertas WHERE id = ? AND usuario_id = ?");
    $stmt->execute([$id, $meu_id]);
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($dados) {
        $produto = $dados['produto'];
        $preco = number_format($dados['preco'], 2, ',', '.'); 
        $unidade = $dados['unidade'];
        $destaque = $dados['destaque'];
        $categoria = $dados['categoria']; 
        $filial_id = $dados['filial_id'];
        $ativo = isset($dados['ativo']) ? $dados['ativo'] : 1;
        $codigo_balanca = $dados['codigo_balanca'];
        $imagemAtual = $dados['imagem'];
        
        // Novos campos
        $data_inicio = $dados['data_inicio'];
        $data_fim = $dados['data_fim'];
        $hora_inicio = $dados['hora_inicio'];
        $hora_fim = $dados['hora_fim'];
        
        // Detecção de Vídeo (Pelo banco ou extensão)
        $is_video = (isset($dados['is_video']) && $dados['is_video'] == 1) ? 1 : 0;
        if(preg_match('/\.(mp4|webm)$/i', $imagemAtual)) {
            $is_video = 1;
            $tipo_midia = 'video';
        }
    } else { header("Location: painel.php"); exit; }
}

// SALVAR
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $produtoPost = $_POST['produto'];
    $precoPost = converterPrecoParaBanco($_POST['preco']); 
    $unidadePost = $_POST['unidade'];
    $categoriaPost = $_POST['categoria']; 
    $filialPost = !empty($_POST['filial_id']) ? $_POST['filial_id'] : null;
    $destaquePost = isset($_POST['destaque']) ? 1 : 0;
    $ativoPost = $_POST['ativo'];
    $balancaPost = $_POST['codigo_balanca'];
    $idPost = $_POST['id'];
    
    // Captura o switch de vídeo
    $isVideoPost = isset($_POST['is_video']) ? 1 : 0;
    
    // Agendamento
    $dtIni = !empty($_POST['data_inicio']) ? $_POST['data_inicio'] : null;
    $dtFim = !empty($_POST['data_fim']) ? $_POST['data_fim'] : null;
    $hrIni = !empty($_POST['hora_inicio']) ? $_POST['hora_inicio'] : null;
    $hrFim = !empty($_POST['hora_fim']) ? $_POST['hora_fim'] : null;
    
    $nomeLimpo = gerarNomeAmigavel($produtoPost);
    $urlFinalImagem = $_POST['imagem_atual_hidden'];
    $tipoMidiaFinal = $isVideoPost ? 'video' : 'imagem';

    // LÓGICA DE UPLOAD
    if (isset($_FILES['nova_imagem']) && $_FILES['nova_imagem']['error'] == 0) {
        $extensao = strtolower(pathinfo($_FILES['nova_imagem']['name'], PATHINFO_EXTENSION));
        $sufixo = substr(md5(time()), 0, 4);
        $novoNome = $nomeLimpo . "-" . $sufixo . "." . $extensao;
        $destino = "uploads/" . $novoNome;
        
        if (!is_dir('uploads')) mkdir('uploads', 0777, true);
        
        if (move_uploaded_file($_FILES['nova_imagem']['tmp_name'], $destino)) {
            $urlFinalImagem = "uploads/" . $novoNome;
            // Se subiu MP4, força video
            if(in_array($extensao, ['mp4', 'webm', 'ogg', 'mov'])) {
                $tipoMidiaFinal = 'video';
                $isVideoPost = 1;
            }
        }
    } 
    elseif (!empty($_POST['imagem_galeria_url'])) { 
        $urlFinalImagem = $_POST['imagem_galeria_url']; 
    }
    elseif (!empty($_POST['imagem_web_url'])) {
        $urlWeb = $_POST['imagem_web_url'];
        // Se for vídeo marcado manualmente, não tenta baixar com curl (pode ser link youtube/mp4 externo)
        if(!$isVideoPost) {
            $nomeSalvo = baixarImagemWeb($urlWeb, "uploads/", $nomeLimpo);
            $urlFinalImagem = $nomeSalvo ? "uploads/" . $nomeSalvo : $urlWeb;
        } else {
            $urlFinalImagem = $urlWeb;
        }
    }

    if ($idPost) {
        $sql = "UPDATE ofertas SET produto=?, preco=?, unidade=?, destaque=?, categoria=?, filial_id=?, ativo=?, codigo_balanca=?, imagem=?, tipo_midia=?, is_video=?, data_inicio=?, data_fim=?, hora_inicio=?, hora_fim=? WHERE id=? AND usuario_id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$produtoPost, $precoPost, $unidadePost, $destaquePost, $categoriaPost, $filialPost, $ativoPost, $balancaPost, $urlFinalImagem, $tipoMidiaFinal, $isVideoPost, $dtIni, $dtFim, $hrIni, $hrFim, $idPost, $meu_id]);
    } else {
        $sql = "INSERT INTO ofertas (produto, preco, unidade, destaque, categoria, filial_id, ativo, codigo_balanca, imagem, tipo_midia, is_video, data_inicio, data_fim, hora_inicio, hora_fim, usuario_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$produtoPost, $precoPost, $unidadePost, $destaquePost, $categoriaPost, $filialPost, $ativoPost, $balancaPost, $urlFinalImagem, $tipoMidiaFinal, $isVideoPost, $dtIni, $dtFim, $hrIni, $hrFim, $meu_id]);
    }
    header("Location: painel.php?msg=salvo"); exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Oferta Premium</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .img-resultado, .img-galeria { cursor: pointer; border: 2px solid transparent; height: 140px; display: flex; align-items: center; justify-content: center; overflow: hidden; border-radius: 8px; background: #eee; }
        .img-resultado:hover, .img-galeria:hover { border-color: #0d6efd; }
        .img-resultado img, .img-galeria img { max-height: 120px; max-width: 100%; object-fit: contain; }
        .preview-box { border: 1px solid #ccc; padding: 10px; text-align: center; background: white; position: relative; }
    </style>
</head>
<body class="bg-light">

<div class="container mt-5 mb-5">
    <div class="card shadow">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><?= $id ? 'Editar Item' : 'Novo Item' ?></h4>
            <a href="painel.php" class="btn btn-sm btn-light fw-bold text-primary">Voltar</a>
        </div>
        <div class="card-body">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?= $id ?>">
                <input type="hidden" name="imagem_atual_hidden" value="<?= $imagemAtual ?>">
                <input type="hidden" name="tipo_midia_hidden" value="<?= $tipo_midia ?>">
                <input type="hidden" name="imagem_web_url" id="imagem_web_url">
                <input type="hidden" name="imagem_galeria_url" id="imagem_galeria_url">

                <div class="alert alert-warning d-flex align-items-center mb-4">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_video" id="is_video" value="1" <?= $is_video ? 'checked' : '' ?> style="transform: scale(1.3); margin-right: 10px;" onchange="toggleTipo()">
                        <label class="form-check-label fw-bold text-dark" for="is_video">
                            É UM VÍDEO / COMERCIAL? 
                            <small class="d-block text-muted fw-normal">Marque para exibir em tela cheia nos intervalos.</small>
                        </label>
                    </div>
                </div>

                <div class="row mb-3 align-items-end">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Status</label>
                        <select name="ativo" class="form-select border-success">
                            <option value="1" <?= $ativo == 1 ? 'selected' : '' ?>>🟢 Ativo</option>
                            <option value="0" <?= $ativo == 0 ? 'selected' : '' ?>>🔴 Suspenso</option>
                        </select>
                    </div>
                    <div class="col-md-4 area-produto">
                        <div class="form-check form-switch p-2 border rounded bg-light mb-1">
                            <input type="checkbox" class="form-check-input ms-0 me-2" name="destaque" id="destaque" <?= $destaque ? 'checked' : '' ?> style="transform: scale(1.2);">
                            <label class="form-check-label fw-bold text-warning" for="destaque">⭐ Super Destaque</label>
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Nome do Produto / Título do Vídeo</label>
                    <input type="text" name="produto" id="campoProduto" class="form-control form-control-lg fw-bold" required value="<?= $produto ?>" placeholder="Ex: Picanha Maturada">
                </div>

                <div class="row area-produto">
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Preço</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light fw-bold">R$</span>
                            <input type="text" name="preco" id="campoPreco" class="form-control form-control-lg text-success fw-bold" 
                                   value="<?= $preco ?>" placeholder="0,00">
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Unidade</label>
                        <input type="text" name="unidade" class="form-control form-control-lg" list="listaUnidades" value="<?= $unidade ?>">
                        <datalist id="listaUnidades"><option value="un"><option value="kg"><option value="100g"><option value="cx"></datalist>
                    </div>
                </div>

                <div class="row mb-3 area-produto">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Categoria</label>
                        <select name="categoria" class="form-select">
                            <option value="Geral">Geral</option>
                            <?php foreach($listaCategorias as $cat): ?>
                                <option value="<?= $cat['nome'] ?>" <?= $categoria == $cat['nome'] ? 'selected' : '' ?>><?= $cat['nome'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Filial</label>
                        <select name="filial_id" class="form-select">
                            <option value="">Todas</option>
                            <?php foreach($listaFiliais as $fil): ?>
                                <option value="<?= $fil['id'] ?>" <?= $filial_id == $fil['id'] ? 'selected' : '' ?>><?= $fil['nome'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Cód. Balança</label>
                        <input type="number" name="codigo_balanca" class="form-control" value="<?= $codigo_balanca ?>">
                    </div>
                </div>

                <div class="card mb-4 border-info">
                    <div class="card-header bg-info text-white fw-bold"><i class="bi bi-calendar-check"></i> Agendamento (Deixe vazio para exibir sempre)</div>
                    <div class="card-body bg-light">
                        <div class="row">
                            <div class="col-md-3">
                                <label class="form-label small">Data Início</label>
                                <input type="date" name="data_inicio" class="form-control" value="<?= $data_inicio ?>">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label small">Data Fim</label>
                                <input type="date" name="data_fim" class="form-control" value="<?= $data_fim ?>">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label small">Hora Início</label>
                                <input type="time" name="hora_inicio" class="form-control" value="<?= $hora_inicio ?>">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label small">Hora Fim</label>
                                <input type="time" name="hora_fim" class="form-control" value="<?= $hora_fim ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-4 p-3 border rounded bg-white shadow-sm">
                    <label class="form-label fw-bold">Mídia (Imagem ou Vídeo MP4)</label>
                    <div class="d-flex flex-column flex-md-row gap-3">
                        <div class="preview-box rounded d-flex align-items-center justify-content-center" style="width: 140px; height: 140px; background: #f8f9fa;">
                            <?php if($is_video == 1 || preg_match('/\.(mp4|webm)$/i', $imagemAtual)): ?>
                                <video src="<?= $imagemAtual ?>" style="max-height: 100%; max-width: 100%;" muted autoplay loop></video>
                            <?php else: ?>
                                <img src="<?= $imagemAtual ?: 'https://cdn-icons-png.flaticon.com/512/1170/1170576.png' ?>" id="previewImg" style="max-height:100%; max-width:100%;">
                            <?php endif; ?>
                        </div>
                        <div class="flex-grow-1">
                            <div class="row g-2 area-produto"> <div class="col-md-6"><button type="button" class="btn btn-outline-primary w-100 py-3 fw-bold" data-bs-toggle="modal" data-bs-target="#modalBusca">🔍 Buscar Imagem Web</button></div>
                                <div class="col-md-6"><button type="button" class="btn btn-outline-warning w-100 py-3 fw-bold text-dark" onclick="abrirGaleria()">📂 Galeria Local</button></div>
                            </div>
                            <div class="text-center text-muted small my-2">- ou upload de Vídeo/Imagem do PC -</div>
                            <input type="file" name="nova_imagem" class="form-control" accept="image/*,video/mp4,video/webm" onchange="previewFile()">
                            <div id="msgOrigem" class="form-text text-primary fw-bold mt-1"></div>
                        </div>
                    </div>
                </div>

                <div class="d-grid gap-2 mt-4">
                    <button type="submit" class="btn btn-success btn-lg fw-bold p-3">SALVAR</button>
                    <a href="painel.php" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalBusca" tabindex="-1"><div class="modal-dialog modal-xl"><div class="modal-content"><div class="modal-header bg-primary text-white"><h5 class="modal-title">Busca Web</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div><div class="modal-body bg-light"><div class="input-group mb-3"><input type="text" id="termoBusca" class="form-control form-control-lg" placeholder="Digite o produto..."><button class="btn btn-primary btn-lg px-4" onclick="buscarImagens()">PESQUISAR</button></div><div id="loading" class="text-center d-none py-5"><div class="spinner-border text-primary"></div></div><div id="resultados" class="row g-3" style="min-height: 200px;"></div></div></div></div></div>
<div class="modal fade" id="modalGaleria" tabindex="-1"><div class="modal-dialog modal-xl"><div class="modal-content"><div class="modal-header bg-warning"><h5 class="modal-title fw-bold">Galeria</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body bg-light"><div class="mb-3 sticky-top bg-light pt-2 pb-2" style="top:0;z-index:10;"><label class="form-label fw-bold">Filtrar:</label><input type="text" id="filtroGaleria" class="form-control form-control-lg border-warning" onkeyup="filtrarGaleriaLoop()"><div id="contadorGaleria" class="form-text text-end">...</div></div><div id="loadingGaleria" class="text-center d-none py-5"><div class="spinner-border text-warning"></div></div><div id="gridGaleria" class="row g-3" style="max-height: 60vh; overflow-y: auto;"></div><div id="semResultadosGaleria" class="text-center py-5 d-none"><h5>Nada encontrado.</h5></div></div></div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // FUNÇÃO NOVA: CONTROLAR CAMPOS DE VÍDEO
    function toggleTipo() {
        var isVideo = document.getElementById('is_video').checked;
        var campos = document.querySelectorAll('.area-produto');
        
        campos.forEach(function(el) {
            el.style.display = isVideo ? 'none' : 'flex'; // ou block dependendo do layout original
        });

        // Se for vídeo, zera o preço para não confundir
        if(isVideo) {
            var preco = document.getElementById('campoPreco');
            if(preco) preco.value = '0,00';
        }
    }

    // --- SEUS SCRIPTS ORIGINAIS DE BUSCA E GALERIA ---
    function atualizarPreview(url, origem) { 
        var preview = document.getElementById('previewImg');
        if(preview) preview.src = url; 
        document.getElementById('msgOrigem').innerText = "De: " + origem; 
        if(origem === 'Google') { 
            document.getElementById('imagem_web_url').value = url; 
            document.getElementById('imagem_galeria_url').value = ''; 
        } else if(origem === 'Galeria') { 
            document.getElementById('imagem_galeria_url').value = url; 
            document.getElementById('imagem_web_url').value = ''; 
        } 
    }
    const modalBusca = document.getElementById('modalBusca'); 
    modalBusca.addEventListener('shown.bs.modal', event => { 
        const prod = document.getElementById('campoProduto').value; 
        if(prod) { document.getElementById('termoBusca').value = prod; buscarImagens(); } 
    });
    function buscarImagens() { 
        const termo = document.getElementById('termoBusca').value; 
        const resDiv = document.getElementById('resultados'); 
        const load = document.getElementById('loading'); 
        if(!termo) return; 
        resDiv.innerHTML = ''; load.classList.remove('d-none'); 
        fetch(`buscador.php?termo=${encodeURIComponent(termo)}`).then(r => r.json()).then(urls => { 
            load.classList.add('d-none'); 
            if(urls && urls.length) { 
                urls.forEach(url => { 
                    const div = document.createElement('div'); 
                    div.className = 'col-6 col-md-2'; 
                    div.innerHTML = `<div class="img-resultado rounded" onclick="selecionarWeb('${url}')"><img src="${url}" loading="lazy"></div>`; 
                    resDiv.appendChild(div); 
                }); 
            } else { resDiv.innerHTML = '<p class="text-center">Nada encontrado.</p>'; } 
        }); 
    }
    function selecionarWeb(url) { atualizarPreview(url, 'Google'); bootstrap.Modal.getInstance(modalBusca).hide(); }
    function abrirGaleria() { const modal = new bootstrap.Modal(document.getElementById('modalGaleria')); modal.show(); carregarGaleria(); }
    function carregarGaleria() { 
        const grid = document.getElementById('gridGaleria'); 
        const load = document.getElementById('loadingGaleria'); 
        const contador = document.getElementById('contadorGaleria'); 
        grid.innerHTML = ''; load.classList.remove('d-none'); 
        fetch('listar-galeria.php').then(r => r.json()).then(imgs => { 
            load.classList.add('d-none'); 
            if(imgs && imgs.length) { 
                contador.innerText = `Total: ${imgs.length}`; 
                imgs.forEach(img => { 
                    const div = document.createElement('div'); 
                    div.className = 'col-6 col-md-2 item-galeria'; 
                    div.setAttribute('data-nome', img.nome.toLowerCase()); 
                    div.innerHTML = `<div class="img-galeria rounded shadow-sm" onclick="selecionarGaleria('${img.url}')"><img src="${img.url}" loading="lazy"></div><div class="small text-center text-muted text-truncate mt-1">${img.nome}</div>`; 
                    grid.appendChild(div); 
                }); 
            } else { grid.innerHTML = '<p class="text-center w-100">Vazio.</p>'; } 
        }); 
    }
    function selecionarGaleria(url) { atualizarPreview(url, 'Galeria'); bootstrap.Modal.getInstance(document.getElementById('modalGaleria')).hide(); }
    function filtrarGaleriaLoop() { const input = document.getElementById('filtroGaleria'); const filtro = input.value.toLowerCase(); const grid = document.getElementById('gridGaleria'); const itens = grid.getElementsByClassName('item-galeria'); let visiveis = 0; for (let i = 0; i < itens.length; i++) { if (itens[i].getAttribute('data-nome').indexOf(filtro) > -1) { itens[i].style.display = ""; visiveis++; } else { itens[i].style.display = "none"; } } document.getElementById('contadorGaleria').innerText = `Exibindo ${visiveis}`; }
    function previewFile() { const file = document.querySelector('input[type=file]').files[0]; const reader = new FileReader(); reader.onloadend = function () { atualizarPreview(reader.result, 'Upload Manual'); }; if (file) reader.readAsDataURL(file); }

    // Roda ao iniciar para esconder campos se for vídeo
    toggleTipo();
</script>
</body>
</html>