//
//  Emojione.m
//
//  Created by Alessandro Calzavara on 16/12/14.
//  Copyright (c) 2014 Spreaker, Inc.
//

#import "Emojione.h"

@implementation Emojione

+ (NSString *)shortnameToUnicode:(NSString *)string
{
    static NSDictionary * emojiMapping;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        emojiMapping = [self _loadShortNameToUnicode];
    });

    NSString * SHORTNAME_PATTERN = @":([-+\\w]+):";

    NSMutableString * unicodeString = [string mutableCopy];
    NSError * error = nil;
    NSRegularExpression * regex = [NSRegularExpression regularExpressionWithPattern:SHORTNAME_PATTERN
                                                                            options:0
                                                                              error:&error];

    NSAssert(!error, @"Unable to create regex: ", error);

    NSArray * matches = [regex matchesInString:unicodeString
                                       options:0
                                         range:NSMakeRange(0, [unicodeString length])];
    
    for (NSTextCheckingResult * result in [matches reverseObjectEnumerator]) {

        if ([result numberOfRanges] < 2) {
            continue;
        }
        
        // Range 0: full shortname
        // Range 1: shortname without :
        
        NSString * shortname = [string substringWithRange:[result rangeAtIndex:1]];
        NSString * emoji = [emojiMapping objectForKey:shortname];
        if (emoji) {
            [unicodeString replaceCharactersInRange:[result rangeAtIndex:0]
                                         withString:emoji];
        }
    }

    return unicodeString;
}

+ (NSDictionary *)_loadShortNameToUnicode
{
    // Mapping generated by script.

    return @{
        @"100" : @"\U0001F4AF",
        @"1234" : @"\U0001F522",
        @"grinning" : @"\U0001F600",
        @"grin" : @"\U0001F601",
        @"joy" : @"\U0001F602",
        @"smiley" : @"\U0001F603",
        @"smile" : @"\U0001F604",
        @"sweat_smile" : @"\U0001F605",
        @"laughing" : @"\U0001F606",
        @"innocent" : @"\U0001F607",
        @"smiling_imp" : @"\U0001F608",
        @"imp" : @"\U0001F47F",
        @"wink" : @"\U0001F609",
        @"blush" : @"\U0001F60A",
        @"relaxed" : @"\U0000263A",
        @"yum" : @"\U0001F60B",
        @"relieved" : @"\U0001F60C",
        @"heart_eyes" : @"\U0001F60D",
        @"sunglasses" : @"\U0001F60E",
        @"smirk" : @"\U0001F60F",
        @"neutral_face" : @"\U0001F610",
        @"expressionless" : @"\U0001F611",
        @"unamused" : @"\U0001F612",
        @"sweat" : @"\U0001F613",
        @"pensive" : @"\U0001F614",
        @"confused" : @"\U0001F615",
        @"confounded" : @"\U0001F616",
        @"kissing" : @"\U0001F617",
        @"kissing_heart" : @"\U0001F618",
        @"kissing_smiling_eyes" : @"\U0001F619",
        @"kissing_closed_eyes" : @"\U0001F61A",
        @"stuck_out_tongue" : @"\U0001F61B",
        @"stuck_out_tongue_winking_eye" : @"\U0001F61C",
        @"stuck_out_tongue_closed_eyes" : @"\U0001F61D",
        @"disappointed" : @"\U0001F61E",
        @"worried" : @"\U0001F61F",
        @"angry" : @"\U0001F620",
        @"rage" : @"\U0001F621",
        @"cry" : @"\U0001F622",
        @"persevere" : @"\U0001F623",
        @"triumph" : @"\U0001F624",
        @"disappointed_relieved" : @"\U0001F625",
        @"frowning" : @"\U0001F626",
        @"anguished" : @"\U0001F627",
        @"fearful" : @"\U0001F628",
        @"weary" : @"\U0001F629",
        @"sleepy" : @"\U0001F62A",
        @"tired_face" : @"\U0001F62B",
        @"grimacing" : @"\U0001F62C",
        @"sob" : @"\U0001F62D",
        @"open_mouth" : @"\U0001F62E",
        @"hushed" : @"\U0001F62F",
        @"cold_sweat" : @"\U0001F630",
        @"scream" : @"\U0001F631",
        @"astonished" : @"\U0001F632",
        @"flushed" : @"\U0001F633",
        @"sleeping" : @"\U0001F634",
        @"dizzy_face" : @"\U0001F635",
        @"no_mouth" : @"\U0001F636",
        @"mask" : @"\U0001F637",
        @"slight_frown" : @"\U0001F641",
        @"slight_smile" : @"\U0001F642",
        @"smile_cat" : @"\U0001F638",
        @"joy_cat" : @"\U0001F639",
        @"smiley_cat" : @"\U0001F63A",
        @"heart_eyes_cat" : @"\U0001F63B",
        @"smirk_cat" : @"\U0001F63C",
        @"kissing_cat" : @"\U0001F63D",
        @"pouting_cat" : @"\U0001F63E",
        @"crying_cat_face" : @"\U0001F63F",
        @"scream_cat" : @"\U0001F640",
        @"footprints" : @"\U0001F463",
        @"bust_in_silhouette" : @"\U0001F464",
        @"busts_in_silhouette" : @"\U0001F465",
        @"levitate" : @"\U0001F574",
        @"spy" : @"\U0001F575",
        @"baby" : @"\U0001F476",
        @"boy" : @"\U0001F466",
        @"girl" : @"\U0001F467",
        @"man" : @"\U0001F468",
        @"woman" : @"\U0001F469",
        @"family" : @"\U0001F46A",
        @"family_mwg" : @"\U0001F468\U0001F469\U0001F467",
        @"family_mwgb" : @"\U0001F468\U0001F469\U0001F467\U0001F466",
        @"family_mwbb" : @"\U0001F468\U0001F469\U0001F466\U0001F466",
        @"family_mwgg" : @"\U0001F468\U0001F469\U0001F467\U0001F467",
        @"family_wwb" : @"\U0001F469\U0001F469\U0001F466",
        @"family_wwg" : @"\U0001F469\U0001F469\U0001F467",
        @"family_wwgb" : @"\U0001F469\U0001F469\U0001F467\U0001F466",
        @"family_wwbb" : @"\U0001F469\U0001F469\U0001F466\U0001F466",
        @"family_wwgg" : @"\U0001F469\U0001F469\U0001F467\U0001F467",
        @"family_mmb" : @"\U0001F468\U0001F468\U0001F466",
        @"family_mmg" : @"\U0001F468\U0001F468\U0001F467",
        @"family_mmgb" : @"\U0001F468\U0001F468\U0001F467\U0001F466",
        @"family_mmbb" : @"\U0001F468\U0001F468\U0001F466\U0001F466",
        @"family_mmgg" : @"\U0001F468\U0001F468\U0001F467\U0001F467",
        @"couple" : @"\U0001F46B",
        @"two_men_holding_hands" : @"\U0001F46C",
        @"two_women_holding_hands" : @"\U0001F46D",
        @"dancers" : @"\U0001F46F",
        @"bride_with_veil" : @"\U0001F470",
        @"person_with_blond_hair" : @"\U0001F471",
        @"man_with_gua_pi_mao" : @"\U0001F472",
        @"man_with_turban" : @"\U0001F473",
        @"older_man" : @"\U0001F474",
        @"older_woman" : @"\U0001F475",
        @"cop" : @"\U0001F46E",
        @"construction_worker" : @"\U0001F477",
        @"princess" : @"\U0001F478",
        @"guardsman" : @"\U0001F482",
        @"angel" : @"\U0001F47C",
        @"santa" : @"\U0001F385",
        @"ghost" : @"\U0001F47B",
        @"japanese_ogre" : @"\U0001F479",
        @"japanese_goblin" : @"\U0001F47A",
        @"poop" : @"\U0001F4A9",
        @"skull" : @"\U0001F480",
        @"alien" : @"\U0001F47D",
        @"space_invader" : @"\U0001F47E",
        @"bow" : @"\U0001F647",
        @"information_desk_person" : @"\U0001F481",
        @"no_good" : @"\U0001F645",
        @"ok_woman" : @"\U0001F646",
        @"raising_hand" : @"\U0001F64B",
        @"person_with_pouting_face" : @"\U0001F64E",
        @"person_frowning" : @"\U0001F64D",
        @"massage" : @"\U0001F486",
        @"haircut" : @"\U0001F487",
        @"couple_with_heart" : @"\U0001F491",
        @"couple_ww" : @"\U0001F469\U00002764\U0001F469",
        @"couple_mm" : @"\U0001F468\U00002764\U0001F468",
        @"couplekiss" : @"\U0001F48F",
        @"kiss_ww" : @"\U0001F469\U00002764\U0001F48B\U0001F469",
        @"kiss_mm" : @"\U0001F468\U00002764\U0001F48B\U0001F468",
        @"raised_hands" : @"\U0001F64C",
        @"clap" : @"\U0001F44F",
        @"ear" : @"\U0001F442",
        @"eye" : @"\U0001F441",
        @"eyes" : @"\U0001F440",
        @"nose" : @"\U0001F443",
        @"lips" : @"\U0001F444",
        @"lips2" : @"\U0001F5E2",
        @"kiss" : @"\U0001F48B",
        @"tongue" : @"\U0001F445",
        @"nail_care" : @"\U0001F485",
        @"wave" : @"\U0001F44B",
        @"thumbsup" : @"\U0001F44D",
        @"thumbsdown" : @"\U0001F44E",
        @"point_up" : @"\U0000261D",
        @"point_up_2" : @"\U0001F446",
        @"point_down" : @"\U0001F447",
        @"point_left" : @"\U0001F448",
        @"point_right" : @"\U0001F449",
        @"ok_hand" : @"\U0001F44C",
        @"v" : @"\U0000270C",
        @"punch" : @"\U0001F44A",
        @"fist" : @"\U0000270A",
        @"raised_hand" : @"\U0000270B",
        @"muscle" : @"\U0001F4AA",
        @"open_hands" : @"\U0001F450",
        @"writing_hand" : @"\U0001F58E",
        @"turned_ok_hand" : @"\U0001F58F",
        @"hand_splayed" : @"\U0001F590",
        @"hand_splayed_reverse" : @"\U0001F591",
        @"thumbs_up_reverse" : @"\U0001F592",
        @"thumbs_down_reverse" : @"\U0001F593",
        @"hand_victory" : @"\U0001F594",
        @"middle_finger" : @"\U0001F595",
        @"vulcan" : @"\U0001F596",
        @"finger_pointing_down" : @"\U0001F597",
        @"finger_pointing_left" : @"\U0001F598",
        @"finger_pointing_right" : @"\U0001F599",
        @"finger_pointing_up" : @"\U0001F59E",
        @"finger_pointing_down2" : @"\U0001F59F",
        @"pray" : @"\U0001F64F",
        @"seedling" : @"\U0001F331",
        @"evergreen_tree" : @"\U0001F332",
        @"deciduous_tree" : @"\U0001F333",
        @"palm_tree" : @"\U0001F334",
        @"cactus" : @"\U0001F335",
        @"tulip" : @"\U0001F337",
        @"cherry_blossom" : @"\U0001F338",
        @"rose" : @"\U0001F339",
        @"hibiscus" : @"\U0001F33A",
        @"sunflower" : @"\U0001F33B",
        @"blossom" : @"\U0001F33C",
        @"bouquet" : @"\U0001F490",
        @"ear_of_rice" : @"\U0001F33E",
        @"herb" : @"\U0001F33F",
        @"four_leaf_clover" : @"\U0001F340",
        @"maple_leaf" : @"\U0001F341",
        @"fallen_leaf" : @"\U0001F342",
        @"leaves" : @"\U0001F343",
        @"mushroom" : @"\U0001F344",
        @"chestnut" : @"\U0001F330",
        @"rat" : @"\U0001F400",
        @"mouse2" : @"\U0001F401",
        @"mouse" : @"\U0001F42D",
        @"hamster" : @"\U0001F439",
        @"ox" : @"\U0001F402",
        @"water_buffalo" : @"\U0001F403",
        @"cow2" : @"\U0001F404",
        @"cow" : @"\U0001F42E",
        @"tiger2" : @"\U0001F405",
        @"leopard" : @"\U0001F406",
        @"tiger" : @"\U0001F42F",
        @"chipmunk" : @"\U0001F43F",
        @"rabbit2" : @"\U0001F407",
        @"rabbit" : @"\U0001F430",
        @"cat2" : @"\U0001F408",
        @"cat" : @"\U0001F431",
        @"racehorse" : @"\U0001F40E",
        @"horse" : @"\U0001F434",
        @"ram" : @"\U0001F40F",
        @"sheep" : @"\U0001F411",
        @"goat" : @"\U0001F410",
        @"rooster" : @"\U0001F413",
        @"chicken" : @"\U0001F414",
        @"baby_chick" : @"\U0001F424",
        @"hatching_chick" : @"\U0001F423",
        @"hatched_chick" : @"\U0001F425",
        @"bird" : @"\U0001F426",
        @"penguin" : @"\U0001F427",
        @"elephant" : @"\U0001F418",
        @"dromedary_camel" : @"\U0001F42A",
        @"camel" : @"\U0001F42B",
        @"boar" : @"\U0001F417",
        @"pig2" : @"\U0001F416",
        @"pig" : @"\U0001F437",
        @"pig_nose" : @"\U0001F43D",
        @"dog2" : @"\U0001F415",
        @"poodle" : @"\U0001F429",
        @"dog" : @"\U0001F436",
        @"wolf" : @"\U0001F43A",
        @"bear" : @"\U0001F43B",
        @"koala" : @"\U0001F428",
        @"panda_face" : @"\U0001F43C",
        @"monkey_face" : @"\U0001F435",
        @"see_no_evil" : @"\U0001F648",
        @"hear_no_evil" : @"\U0001F649",
        @"speak_no_evil" : @"\U0001F64A",
        @"monkey" : @"\U0001F412",
        @"dragon" : @"\U0001F409",
        @"dragon_face" : @"\U0001F432",
        @"crocodile" : @"\U0001F40A",
        @"snake" : @"\U0001F40D",
        @"turtle" : @"\U0001F422",
        @"frog" : @"\U0001F438",
        @"whale2" : @"\U0001F40B",
        @"whale" : @"\U0001F433",
        @"dolphin" : @"\U0001F42C",
        @"octopus" : @"\U0001F419",
        @"fish" : @"\U0001F41F",
        @"tropical_fish" : @"\U0001F420",
        @"blowfish" : @"\U0001F421",
        @"shell" : @"\U0001F41A",
        @"snail" : @"\U0001F40C",
        @"bug" : @"\U0001F41B",
        @"ant" : @"\U0001F41C",
        @"bee" : @"\U0001F41D",
        @"beetle" : @"\U0001F41E",
        @"spider" : @"\U0001F577",
        @"spider_web" : @"\U0001F578",
        @"feet" : @"\U0001F43E",
        @"zap" : @"\U000026A1",
        @"fire" : @"\U0001F525",
        @"crescent_moon" : @"\U0001F319",
        @"sunny" : @"\U00002600",
        @"partly_sunny" : @"\U000026C5",
        @"cloud" : @"\U00002601",
        @"cloud_rain" : @"\U0001F327",
        @"cloud_snow" : @"\U0001F328",
        @"cloud_lightning" : @"\U0001F329",
        @"cloud_tornado" : @"\U0001F32A",
        @"droplet" : @"\U0001F4A7",
        @"sweat_drops" : @"\U0001F4A6",
        @"umbrella" : @"\U00002614",
        @"fog" : @"\U0001F32B",
        @"dash" : @"\U0001F4A8",
        @"snowflake" : @"\U00002744",
        @"star2" : @"\U0001F31F",
        @"star" : @"\U00002B50",
        @"stars" : @"\U0001F320",
        @"sunrise_over_mountains" : @"\U0001F304",
        @"sunrise" : @"\U0001F305",
        @"rainbow" : @"\U0001F308",
        @"ocean" : @"\U0001F30A",
        @"volcano" : @"\U0001F30B",
        @"milky_way" : @"\U0001F30C",
        @"mount_fuji" : @"\U0001F5FB",
        @"japan" : @"\U0001F5FE",
        @"globe_with_meridians" : @"\U0001F310",
        @"earth_africa" : @"\U0001F30D",
        @"earth_americas" : @"\U0001F30E",
        @"earth_asia" : @"\U0001F30F",
        @"new_moon" : @"\U0001F311",
        @"waxing_crescent_moon" : @"\U0001F312",
        @"first_quarter_moon" : @"\U0001F313",
        @"waxing_gibbous_moon" : @"\U0001F314",
        @"full_moon" : @"\U0001F315",
        @"waning_gibbous_moon" : @"\U0001F316",
        @"last_quarter_moon" : @"\U0001F317",
        @"waning_crescent_moon" : @"\U0001F318",
        @"new_moon_with_face" : @"\U0001F31A",
        @"full_moon_with_face" : @"\U0001F31D",
        @"first_quarter_moon_with_face" : @"\U0001F31B",
        @"last_quarter_moon_with_face" : @"\U0001F31C",
        @"sun_with_face" : @"\U0001F31E",
        @"wind_blowing_face" : @"\U0001F32C",
        @"ribbon" : @"\U0001F380",
        @"gift" : @"\U0001F381",
        @"birthday" : @"\U0001F382",
        @"jack_o_lantern" : @"\U0001F383",
        @"christmas_tree" : @"\U0001F384",
        @"tanabata_tree" : @"\U0001F38B",
        @"bamboo" : @"\U0001F38D",
        @"rice_scene" : @"\U0001F391",
        @"fireworks" : @"\U0001F386",
        @"sparkler" : @"\U0001F387",
        @"tada" : @"\U0001F389",
        @"confetti_ball" : @"\U0001F38A",
        @"balloon" : @"\U0001F388",
        @"dizzy" : @"\U0001F4AB",
        @"sparkles" : @"\U00002728",
        @"boom" : @"\U0001F4A5",
        @"mortar_board" : @"\U0001F393",
        @"crown" : @"\U0001F451",
        @"reminder_ribbon" : @"\U0001F397",
        @"military_medal" : @"\U0001F396",
        @"dolls" : @"\U0001F38E",
        @"flags" : @"\U0001F38F",
        @"wind_chime" : @"\U0001F390",
        @"crossed_flags" : @"\U0001F38C",
        @"izakaya_lantern" : @"\U0001F3EE",
        @"ring" : @"\U0001F48D",
        @"bouquet2" : @"\U0001F395",
        @"heart" : @"\U00002764",
        @"broken_heart" : @"\U0001F494",
        @"love_letter" : @"\U0001F48C",
        @"two_hearts" : @"\U0001F495",
        @"revolving_hearts" : @"\U0001F49E",
        @"heartbeat" : @"\U0001F493",
        @"heartpulse" : @"\U0001F497",
        @"sparkling_heart" : @"\U0001F496",
        @"cupid" : @"\U0001F498",
        @"gift_heart" : @"\U0001F49D",
        @"heart_tip" : @"\U0001F394",
        @"heart_decoration" : @"\U0001F49F",
        @"purple_heart" : @"\U0001F49C",
        @"yellow_heart" : @"\U0001F49B",
        @"green_heart" : @"\U0001F49A",
        @"blue_heart" : @"\U0001F499",
        @"runner" : @"\U0001F3C3",
        @"walking" : @"\U0001F6B6",
        @"dancer" : @"\U0001F483",
        @"lifter" : @"\U0001F3CB",
        @"golfer" : @"\U0001F3CC",
        @"rowboat" : @"\U0001F6A3",
        @"swimmer" : @"\U0001F3CA",
        @"surfer" : @"\U0001F3C4",
        @"bath" : @"\U0001F6C0",
        @"snowboarder" : @"\U0001F3C2",
        @"ski" : @"\U0001F3BF",
        @"snowman" : @"\U000026C4",
        @"bicyclist" : @"\U0001F6B4",
        @"mountain_bicyclist" : @"\U0001F6B5",
        @"motorcycle" : @"\U0001F3CD",
        @"race_car" : @"\U0001F3CE",
        @"horse_racing" : @"\U0001F3C7",
        @"tent" : @"\U000026FA",
        @"fishing_pole_and_fish" : @"\U0001F3A3",
        @"soccer" : @"\U000026BD",
        @"basketball" : @"\U0001F3C0",
        @"football" : @"\U0001F3C8",
        @"baseball" : @"\U000026BE",
        @"tennis" : @"\U0001F3BE",
        @"rugby_football" : @"\U0001F3C9",
        @"golf" : @"\U000026F3",
        @"trophy" : @"\U0001F3C6",
        @"medal" : @"\U0001F3C5",
        @"running_shirt_with_sash" : @"\U0001F3BD",
        @"checkered_flag" : @"\U0001F3C1",
        @"musical_keyboard" : @"\U0001F3B9",
        @"guitar" : @"\U0001F3B8",
        @"violin" : @"\U0001F3BB",
        @"saxophone" : @"\U0001F3B7",
        @"trumpet" : @"\U0001F3BA",
        @"musical_note" : @"\U0001F3B5",
        @"notes" : @"\U0001F3B6",
        @"musical_score" : @"\U0001F3BC",
        @"headphones" : @"\U0001F3A7",
        @"microphone" : @"\U0001F3A4",
        @"performing_arts" : @"\U0001F3AD",
        @"ticket" : @"\U0001F3AB",
        @"tophat" : @"\U0001F3A9",
        @"circus_tent" : @"\U0001F3AA",
        @"clapper" : @"\U0001F3AC",
        @"film_frames" : @"\U0001F39E",
        @"tickets" : @"\U0001F39F",
        @"art" : @"\U0001F3A8",
        @"dart" : @"\U0001F3AF",
        @"8ball" : @"\U0001F3B1",
        @"bowling" : @"\U0001F3B3",
        @"slot_machine" : @"\U0001F3B0",
        @"game_die" : @"\U0001F3B2",
        @"video_game" : @"\U0001F3AE",
        @"flower_playing_cards" : @"\U0001F3B4",
        @"black_joker" : @"\U0001F0CF",
        @"mahjong" : @"\U0001F004",
        @"carousel_horse" : @"\U0001F3A0",
        @"ferris_wheel" : @"\U0001F3A1",
        @"roller_coaster" : @"\U0001F3A2",
        @"tomato" : @"\U0001F345",
        @"eggplant" : @"\U0001F346",
        @"corn" : @"\U0001F33D",
        @"sweet_potato" : @"\U0001F360",
        @"hot_pepper" : @"\U0001F336",
        @"grapes" : @"\U0001F347",
        @"melon" : @"\U0001F348",
        @"watermelon" : @"\U0001F349",
        @"tangerine" : @"\U0001F34A",
        @"lemon" : @"\U0001F34B",
        @"banana" : @"\U0001F34C",
        @"pineapple" : @"\U0001F34D",
        @"apple" : @"\U0001F34E",
        @"green_apple" : @"\U0001F34F",
        @"pear" : @"\U0001F350",
        @"peach" : @"\U0001F351",
        @"cherries" : @"\U0001F352",
        @"strawberry" : @"\U0001F353",
        @"hamburger" : @"\U0001F354",
        @"pizza" : @"\U0001F355",
        @"meat_on_bone" : @"\U0001F356",
        @"poultry_leg" : @"\U0001F357",
        @"rice_cracker" : @"\U0001F358",
        @"rice_ball" : @"\U0001F359",
        @"rice" : @"\U0001F35A",
        @"curry" : @"\U0001F35B",
        @"ramen" : @"\U0001F35C",
        @"spaghetti" : @"\U0001F35D",
        @"bread" : @"\U0001F35E",
        @"fries" : @"\U0001F35F",
        @"dango" : @"\U0001F361",
        @"oden" : @"\U0001F362",
        @"sushi" : @"\U0001F363",
        @"fried_shrimp" : @"\U0001F364",
        @"fish_cake" : @"\U0001F365",
        @"icecream" : @"\U0001F366",
        @"shaved_ice" : @"\U0001F367",
        @"ice_cream" : @"\U0001F368",
        @"doughnut" : @"\U0001F369",
        @"cookie" : @"\U0001F36A",
        @"chocolate_bar" : @"\U0001F36B",
        @"candy" : @"\U0001F36C",
        @"lollipop" : @"\U0001F36D",
        @"custard" : @"\U0001F36E",
        @"honey_pot" : @"\U0001F36F",
        @"cake" : @"\U0001F370",
        @"bento" : @"\U0001F371",
        @"stew" : @"\U0001F372",
        @"egg" : @"\U0001F373",
        @"fork_and_knife" : @"\U0001F374",
        @"tea" : @"\U0001F375",
        @"coffee" : @"\U00002615",
        @"sake" : @"\U0001F376",
        @"wine_glass" : @"\U0001F377",
        @"cocktail" : @"\U0001F378",
        @"tropical_drink" : @"\U0001F379",
        @"beer" : @"\U0001F37A",
        @"beers" : @"\U0001F37B",
        @"baby_bottle" : @"\U0001F37C",
        @"watch" : @"\U0000231A",
        @"iphone" : @"\U0001F4F1",
        @"calling" : @"\U0001F4F2",
        @"computer" : @"\U0001F4BB",
        @"desktop" : @"\U0001F5A5",
        @"computer_old" : @"\U0001F5B3",
        @"keyboard" : @"\U0001F5AE",
        @"mouse_one" : @"\U0001F5AF",
        @"trackball" : @"\U0001F5B2",
        @"keyboard_mouse" : @"\U0001F5A6",
        @"network" : @"\U0001F5A7",
        @"printer" : @"\U0001F5A8",
        @"desktop_window" : @"\U0001F5D4",
        @"calculator" : @"\U0001F5A9",
        @"alarm_clock" : @"\U000023F0",
        @"clock" : @"\U0001F570",
        @"hourglass_flowing_sand" : @"\U000023F3",
        @"hourglass" : @"\U0000231B",
        @"camera" : @"\U0001F4F7",
        @"camera_with_flash" : @"\U0001F4F8",
        @"video_camera" : @"\U0001F4F9",
        @"movie_camera" : @"\U0001F3A5",
        @"projector" : @"\U0001F4FD",
        @"tv" : @"\U0001F4FA",
        @"keyboard_with_jacks" : @"\U0001F398",
        @"microphone2" : @"\U0001F399",
        @"level_slider" : @"\U0001F39A",
        @"control_knobs" : @"\U0001F39B",
        @"radio" : @"\U0001F4FB",
        @"stereo" : @"\U0001F4FE",
        @"pager" : @"\U0001F4DF",
        @"joystick" : @"\U0001F579",
        @"telephone_receiver" : @"\U0001F4DE",
        @"left_receiver" : @"\U0001F57B",
        @"telephone" : @"\U0000260E",
        @"telephone_white" : @"\U0001F57E",
        @"telephone_black" : @"\U0001F57F",
        @"flip_phone" : @"\U0001F581",
        @"fax" : @"\U0001F4E0",
        @"minidisc" : @"\U0001F4BD",
        @"floppy_disk" : @"\U0001F4BE",
        @"floppy_black" : @"\U0001F5AA",
        @"floppy_white" : @"\U0001F5AB",
        @"cartridge" : @"\U0001F5AD",
        @"hard_disk" : @"\U0001F5B4",
        @"cd" : @"\U0001F4BF",
        @"dvd" : @"\U0001F4C0",
        @"optical_disk" : @"\U0001F5B8",
        @"vhs" : @"\U0001F4FC",
        @"battery" : @"\U0001F50B",
        @"electric_plug" : @"\U0001F50C",
        @"bulb" : @"\U0001F4A1",
        @"flashlight" : @"\U0001F526",
        @"candle" : @"\U0001F56F",
        @"satellite" : @"\U0001F4E1",
        @"satellite_orbital" : @"\U0001F6F0",
        @"credit_card" : @"\U0001F4B3",
        @"money_with_wings" : @"\U0001F4B8",
        @"moneybag" : @"\U0001F4B0",
        @"gem" : @"\U0001F48E",
        @"closed_umbrella" : @"\U0001F302",
        @"pouch" : @"\U0001F45D",
        @"purse" : @"\U0001F45B",
        @"handbag" : @"\U0001F45C",
        @"briefcase" : @"\U0001F4BC",
        @"school_satchel" : @"\U0001F392",
        @"lipstick" : @"\U0001F484",
        @"eyeglasses" : @"\U0001F453",
        @"dark_sunglasses" : @"\U0001F576",
        @"womans_hat" : @"\U0001F452",
        @"sandal" : @"\U0001F461",
        @"high_heel" : @"\U0001F460",
        @"boot" : @"\U0001F462",
        @"mans_shoe" : @"\U0001F45E",
        @"athletic_shoe" : @"\U0001F45F",
        @"bikini" : @"\U0001F459",
        @"dress" : @"\U0001F457",
        @"kimono" : @"\U0001F458",
        @"womans_clothes" : @"\U0001F45A",
        @"shirt" : @"\U0001F455",
        @"necktie" : @"\U0001F454",
        @"jeans" : @"\U0001F456",
        @"door" : @"\U0001F6AA",
        @"shower" : @"\U0001F6BF",
        @"bathtub" : @"\U0001F6C1",
        @"toilet" : @"\U0001F6BD",
        @"barber" : @"\U0001F488",
        @"syringe" : @"\U0001F489",
        @"pill" : @"\U0001F48A",
        @"microscope" : @"\U0001F52C",
        @"telescope" : @"\U0001F52D",
        @"crystal_ball" : @"\U0001F52E",
        @"wrench" : @"\U0001F527",
        @"knife" : @"\U0001F52A",
        @"dagger" : @"\U0001F5E1",
        @"nut_and_bolt" : @"\U0001F529",
        @"hammer" : @"\U0001F528",
        @"tools" : @"\U0001F6E0",
        @"oil" : @"\U0001F6E2",
        @"bomb" : @"\U0001F4A3",
        @"smoking" : @"\U0001F6AC",
        @"crossbones" : @"\U0001F571",
        @"gun" : @"\U0001F52B",
        @"bookmark" : @"\U0001F516",
        @"newspaper" : @"\U0001F4F0",
        @"newspaper2" : @"\U0001F5DE",
        @"thermometer" : @"\U0001F321",
        @"label" : @"\U0001F3F7",
        @"key" : @"\U0001F511",
        @"key2" : @"\U0001F5DD",
        @"envelope" : @"\U00002709",
        @"envelope_back" : @"\U0001F582",
        @"envelope_stamped" : @"\U0001F583",
        @"envelope_flying" : @"\U0001F585",
        @"envelope_stamped_pen" : @"\U0001F586",
        @"envelope_with_arrow" : @"\U0001F4E9",
        @"incoming_envelope" : @"\U0001F4E8",
        @"e-mail" : @"\U0001F4E7",
        @"inbox_tray" : @"\U0001F4E5",
        @"outbox_tray" : @"\U0001F4E4",
        @"package" : @"\U0001F4E6",
        @"postal_horn" : @"\U0001F4EF",
        @"postbox" : @"\U0001F4EE",
        @"mailbox_closed" : @"\U0001F4EA",
        @"mailbox" : @"\U0001F4EB",
        @"mailbox_with_no_mail" : @"\U0001F4ED",
        @"mailbox_with_mail" : @"\U0001F4EC",
        @"document" : @"\U0001F5CE",
        @"document_text" : @"\U0001F5B9",
        @"page" : @"\U0001F5CF",
        @"page_facing_up" : @"\U0001F4C4",
        @"page_with_curl" : @"\U0001F4C3",
        @"pages" : @"\U0001F5D0",
        @"bookmark_tabs" : @"\U0001F4D1",
        @"wastebasket" : @"\U0001F5D1",
        @"note_empty" : @"\U0001F5C6",
        @"notepad_empty" : @"\U0001F5C7",
        @"note" : @"\U0001F5C9",
        @"notepad" : @"\U0001F5CA",
        @"notepad_spiral" : @"\U0001F5D2",
        @"chart_with_upwards_trend" : @"\U0001F4C8",
        @"chart_with_downwards_trend" : @"\U0001F4C9",
        @"bar_chart" : @"\U0001F4CA",
        @"stock_chart" : @"\U0001F5E0",
        @"date" : @"\U0001F4C5",
        @"calendar" : @"\U0001F4C6",
        @"calendar_spiral" : @"\U0001F5D3",
        @"ballot_box" : @"\U0001F5F3",
        @"low_brightness" : @"\U0001F505",
        @"high_brightness" : @"\U0001F506",
        @"compression" : @"\U0001F5DC",
        @"frame_x" : @"\U0001F5BE",
        @"frame_photo" : @"\U0001F5BC",
        @"frame_tiles" : @"\U0001F5BD",
        @"scroll" : @"\U0001F4DC",
        @"clipboard" : @"\U0001F4CB",
        @"book2" : @"\U0001F56E",
        @"book" : @"\U0001F4D6",
        @"notebook" : @"\U0001F4D3",
        @"notebook_with_decorative_cover" : @"\U0001F4D4",
        @"ledger" : @"\U0001F4D2",
        @"closed_book" : @"\U0001F4D5",
        @"green_book" : @"\U0001F4D7",
        @"blue_book" : @"\U0001F4D8",
        @"orange_book" : @"\U0001F4D9",
        @"books" : @"\U0001F4DA",
        @"card_index" : @"\U0001F4C7",
        @"dividers" : @"\U0001F5C2",
        @"card_box" : @"\U0001F5C3",
        @"link" : @"\U0001F517",
        @"paperclip" : @"\U0001F4CE",
        @"paperclips" : @"\U0001F587",
        @"pushpin" : @"\U0001F4CC",
        @"pushpin_black" : @"\U0001F588",
        @"scissors" : @"\U00002702",
        @"triangular_ruler" : @"\U0001F4D0",
        @"round_pushpin" : @"\U0001F4CD",
        @"straight_ruler" : @"\U0001F4CF",
        @"triangular_flag_on_post" : @"\U0001F6A9",
        @"pennant_white" : @"\U0001F3F1",
        @"pennant_black" : @"\U0001F3F2",
        @"flag_white" : @"\U0001F3F3",
        @"flag_black" : @"\U0001F3F4",
        @"hole" : @"\U0001F573",
        @"folder" : @"\U0001F5C0",
        @"folder_open" : @"\U0001F5C1",
        @"file_folder" : @"\U0001F4C1",
        @"open_file_folder" : @"\U0001F4C2",
        @"file_cabinet" : @"\U0001F5C4",
        @"black_nib" : @"\U00002712",
        @"pencil2" : @"\U0000270F",
        @"pencil3" : @"\U0001F589",
        @"pen_ballpoint" : @"\U0001F58A",
        @"pen_fountain" : @"\U0001F58B",
        @"paintbrush" : @"\U0001F58C",
        @"crayon" : @"\U0001F58D",
        @"pencil" : @"\U0001F4DD",
        @"lock_with_ink_pen" : @"\U0001F50F",
        @"closed_lock_with_key" : @"\U0001F510",
        @"lock" : @"\U0001F512",
        @"unlock" : @"\U0001F513",
        @"mega" : @"\U0001F4E3",
        @"loudspeaker" : @"\U0001F4E2",
        @"speaker" : @"\U0001F508",
        @"sound" : @"\U0001F509",
        @"loud_sound" : @"\U0001F50A",
        @"mute" : @"\U0001F507",
        @"right_speaker" : @"\U0001F568",
        @"right_speaker_one" : @"\U0001F569",
        @"right_speaker_three" : @"\U0001F56A",
        @"bullhorn" : @"\U0001F56B",
        @"bullhorn_waves" : @"\U0001F56C",
        @"zzz" : @"\U0001F4A4",
        @"bell" : @"\U0001F514",
        @"no_bell" : @"\U0001F515",
        @"ringing_bell" : @"\U0001F56D",
        @"ascending_notes" : @"\U0001F39C",
        @"descending_notes" : @"\U0001F39D",
        @"cross_white" : @"\U0001F546",
        @"cross_heavy" : @"\U0001F547",
        @"celtic_cross" : @"\U0001F548",
        @"om_symbol" : @"\U0001F549",
        @"dove" : @"\U0001F54A",
        @"thought_balloon" : @"\U0001F4AD",
        @"speech_balloon" : @"\U0001F4AC",
        @"speech_left" : @"\U0001F5E8",
        @"speech_right" : @"\U0001F5E9",
        @"speech_two" : @"\U0001F5EA",
        @"speech_three" : @"\U0001F5EB",
        @"thought_left" : @"\U0001F5EC",
        @"thought_right" : @"\U0001F5ED",
        @"anger_left" : @"\U0001F5EE",
        @"anger_right" : @"\U0001F5EF",
        @"mood_bubble" : @"\U0001F5F0",
        @"mood_bubble_lightning" : @"\U0001F5F1",
        @"children_crossing" : @"\U0001F6B8",
        @"shield" : @"\U0001F6E1",
        @"mag" : @"\U0001F50D",
        @"mag_right" : @"\U0001F50E",
        @"speaking_head" : @"\U0001F5E3",
        @"sleeping_accommodation" : @"\U0001F6CC",
        @"prohibited" : @"\U0001F6C7",
        @"no_entry_sign" : @"\U0001F6AB",
        @"no_entry" : @"\U000026D4",
        @"name_badge" : @"\U0001F4DB",
        @"no_pedestrians" : @"\U0001F6B7",
        @"do_not_litter" : @"\U0001F6AF",
        @"no_bicycles" : @"\U0001F6B3",
        @"non-potable_water" : @"\U0001F6B1",
        @"no_mobile_phones" : @"\U0001F4F5",
        @"underage" : @"\U0001F51E",
        @"piracy" : @"\U0001F572",
        @"accept" : @"\U0001F251",
        @"ideograph_advantage" : @"\U0001F250",
        @"white_flower" : @"\U0001F4AE",
        @"secret" : @"\U00003299",
        @"congratulations" : @"\U00003297",
        @"u5408" : @"\U0001F234",
        @"u6e80" : @"\U0001F235",
        @"u7981" : @"\U0001F232",
        @"u6709" : @"\U0001F236",
        @"u7121" : @"\U0001F21A",
        @"u7533" : @"\U0001F238",
        @"u55b6" : @"\U0001F23A",
        @"u6708" : @"\U0001F237",
        @"u5272" : @"\U0001F239",
        @"u7a7a" : @"\U0001F233",
        @"sa" : @"\U0001F202",
        @"koko" : @"\U0001F201",
        @"u6307" : @"\U0001F22F",
        @"chart" : @"\U0001F4B9",
        @"sparkle" : @"\U00002747",
        @"eight_spoked_asterisk" : @"\U00002733",
        @"negative_squared_cross_mark" : @"\U0000274E",
        @"white_check_mark" : @"\U00002705",
        @"eight_pointed_black_star" : @"\U00002734",
        @"vibration_mode" : @"\U0001F4F3",
        @"mobile_phone_off" : @"\U0001F4F4",
        @"vs" : @"\U0001F19A",
        @"a" : @"\U0001F170",
        @"b" : @"\U0001F171",
        @"ab" : @"\U0001F18E",
        @"cl" : @"\U0001F191",
        @"o2" : @"\U0001F17E",
        @"sos" : @"\U0001F198",
        @"id" : @"\U0001F194",
        @"parking" : @"\U0001F17F",
        @"wc" : @"\U0001F6BE",
        @"cool" : @"\U0001F192",
        @"free" : @"\U0001F193",
        @"new" : @"\U0001F195",
        @"ng" : @"\U0001F196",
        @"ok" : @"\U0001F197",
        @"up" : @"\U0001F199",
        @"atm" : @"\U0001F3E7",
        @"aries" : @"\U00002648",
        @"taurus" : @"\U00002649",
        @"gemini" : @"\U0000264A",
        @"cancer" : @"\U0000264B",
        @"leo" : @"\U0000264C",
        @"virgo" : @"\U0000264D",
        @"libra" : @"\U0000264E",
        @"scorpius" : @"\U0000264F",
        @"sagittarius" : @"\U00002650",
        @"capricorn" : @"\U00002651",
        @"aquarius" : @"\U00002652",
        @"pisces" : @"\U00002653",
        @"restroom" : @"\U0001F6BB",
        @"mens" : @"\U0001F6B9",
        @"womens" : @"\U0001F6BA",
        @"boys_symbol" : @"\U0001F6C9",
        @"girls_symbol" : @"\U0001F6CA",
        @"baby_symbol" : @"\U0001F6BC",
        @"wheelchair" : @"\U0000267F",
        @"potable_water" : @"\U0001F6B0",
        @"no_smoking" : @"\U0001F6AD",
        @"put_litter_in_its_place" : @"\U0001F6AE",
        @"arrow_forward" : @"\U000025B6",
        @"arrow_backward" : @"\U000025C0",
        @"arrow_up_small" : @"\U0001F53C",
        @"arrow_down_small" : @"\U0001F53D",
        @"fast_forward" : @"\U000023E9",
        @"rewind" : @"\U000023EA",
        @"arrow_double_up" : @"\U000023EB",
        @"arrow_double_down" : @"\U000023EC",
        @"arrow_right" : @"\U000027A1",
        @"arrow_left" : @"\U00002B05",
        @"arrow_up" : @"\U00002B06",
        @"arrow_down" : @"\U00002B07",
        @"arrow_upper_right" : @"\U00002197",
        @"arrow_lower_right" : @"\U00002198",
        @"arrow_lower_left" : @"\U00002199",
        @"arrow_upper_left" : @"\U00002196",
        @"arrow_up_down" : @"\U00002195",
        @"left_right_arrow" : @"\U00002194",
        @"arrows_counterclockwise" : @"\U0001F504",
        @"arrow_right_hook" : @"\U000021AA",
        @"leftwards_arrow_with_hook" : @"\U000021A9",
        @"arrow_heading_up" : @"\U00002934",
        @"arrow_heading_down" : @"\U00002935",
        @"twisted_rightwards_arrows" : @"\U0001F500",
        @"repeat" : @"\U0001F501",
        @"repeat_one" : @"\U0001F502",
        @"hash" : @"#\U000020E3",
        @"zero" : @"0\U000020E3",
        @"one" : @"1\U000020E3",
        @"two" : @"2\U000020E3",
        @"three" : @"3\U000020E3",
        @"four" : @"4\U000020E3",
        @"five" : @"5\U000020E3",
        @"six" : @"6\U000020E3",
        @"seven" : @"7\U000020E3",
        @"eight" : @"8\U000020E3",
        @"nine" : @"9\U000020E3",
        @"keycap_ten" : @"\U0001F51F",
        @"abc" : @"\U0001F524",
        @"abcd" : @"\U0001F521",
        @"capital_abcd" : @"\U0001F520",
        @"information_source" : @"\U00002139",
        @"signal_strength" : @"\U0001F4F6",
        @"cinema" : @"\U0001F3A6",
        @"symbols" : @"\U0001F523",
        @"heavy_plus_sign" : @"\U00002795",
        @"heavy_minus_sign" : @"\U00002796",
        @"wavy_dash" : @"\U00003030",
        @"heavy_division_sign" : @"\U00002797",
        @"heavy_multiplication_x" : @"\U00002716",
        @"heavy_check_mark" : @"\U00002714",
        @"cancellation_x" : @"\U0001F5D9",
        @"arrows_clockwise" : @"\U0001F503",
        @"clockwise_arrows" : @"\U0001F5D8",
        @"tm" : @"\U00002122",
        @"copyright" : @"\U000000A9",
        @"registered" : @"\U000000AE",
        @"currency_exchange" : @"\U0001F4B1",
        @"heavy_dollar_sign" : @"\U0001F4B2",
        @"curly_loop" : @"\U000027B0",
        @"loop" : @"\U000027BF",
        @"part_alternation_mark" : @"\U0000303D",
        @"exclamation" : @"\U00002757",
        @"question" : @"\U00002753",
        @"grey_exclamation" : @"\U00002755",
        @"grey_question" : @"\U00002754",
        @"bangbang" : @"\U0000203C",
        @"interrobang" : @"\U00002049",
        @"triangle_round" : @"\U0001F6C6",
        @"x" : @"\U0000274C",
        @"o" : @"\U00002B55",
        @"end" : @"\U0001F51A",
        @"back" : @"\U0001F519",
        @"on" : @"\U0001F51B",
        @"top" : @"\U0001F51D",
        @"soon" : @"\U0001F51C",
        @"cyclone" : @"\U0001F300",
        @"m" : @"\U000024C2",
        @"info" : @"\U0001F6C8",
        @"ophiuchus" : @"\U000026CE",
        @"six_pointed_star" : @"\U0001F52F",
        @"beginner" : @"\U0001F530",
        @"mood_lightning" : @"\U0001F5F2",
        @"trident" : @"\U0001F531",
        @"warning" : @"\U000026A0",
        @"hotsprings" : @"\U00002668",
        @"rosette" : @"\U0001F3F5",
        @"rosette_black" : @"\U0001F3F6",
        @"recycle" : @"\U0000267B",
        @"anger" : @"\U0001F4A2",
        @"diamond_shape_with_a_dot_inside" : @"\U0001F4A0",
        @"spades" : @"\U00002660",
        @"clubs" : @"\U00002663",
        @"hearts" : @"\U00002665",
        @"diamonds" : @"\U00002666",
        @"ballot_box_with_check" : @"\U00002611",
        @"light_check_mark" : @"\U0001F5F8",
        @"ballot_box_check" : @"\U0001F5F9",
        @"ballot_x" : @"\U0001F5F4",
        @"ballot_box_x" : @"\U0001F5F5",
        @"white_circle" : @"\U000026AA",
        @"black_circle" : @"\U000026AB",
        @"radio_button" : @"\U0001F518",
        @"red_circle" : @"\U0001F534",
        @"large_blue_circle" : @"\U0001F535",
        @"small_red_triangle" : @"\U0001F53A",
        @"small_red_triangle_down" : @"\U0001F53B",
        @"small_orange_diamond" : @"\U0001F538",
        @"small_blue_diamond" : @"\U0001F539",
        @"large_orange_diamond" : @"\U0001F536",
        @"large_blue_diamond" : @"\U0001F537",
        @"black_small_square" : @"\U000025AA",
        @"white_small_square" : @"\U000025AB",
        @"black_large_square" : @"\U00002B1B",
        @"white_large_square" : @"\U00002B1C",
        @"black_medium_square" : @"\U000025FC",
        @"white_medium_square" : @"\U000025FB",
        @"black_medium_small_square" : @"\U000025FE",
        @"white_medium_small_square" : @"\U000025FD",
        @"black_square_button" : @"\U0001F532",
        @"white_square_button" : @"\U0001F533",
        @"clock1" : @"\U0001F550",
        @"clock2" : @"\U0001F551",
        @"clock3" : @"\U0001F552",
        @"clock4" : @"\U0001F553",
        @"clock5" : @"\U0001F554",
        @"clock6" : @"\U0001F555",
        @"clock7" : @"\U0001F556",
        @"clock8" : @"\U0001F557",
        @"clock9" : @"\U0001F558",
        @"clock10" : @"\U0001F559",
        @"clock11" : @"\U0001F55A",
        @"clock12" : @"\U0001F55B",
        @"clock130" : @"\U0001F55C",
        @"clock230" : @"\U0001F55D",
        @"clock330" : @"\U0001F55E",
        @"clock430" : @"\U0001F55F",
        @"clock530" : @"\U0001F560",
        @"clock630" : @"\U0001F561",
        @"clock730" : @"\U0001F562",
        @"clock830" : @"\U0001F563",
        @"clock930" : @"\U0001F564",
        @"clock1030" : @"\U0001F565",
        @"clock1130" : @"\U0001F566",
        @"clock1230" : @"\U0001F567",
        @"railway_car" : @"\U0001F683",
        @"mountain_railway" : @"\U0001F69E",
        @"steam_locomotive" : @"\U0001F682",
        @"train_diesel" : @"\U0001F6F2",
        @"train" : @"\U0001F68B",
        @"monorail" : @"\U0001F69D",
        @"bullettrain_side" : @"\U0001F684",
        @"bullettrain_front" : @"\U0001F685",
        @"train2" : @"\U0001F686",
        @"metro" : @"\U0001F687",
        @"light_rail" : @"\U0001F688",
        @"station" : @"\U0001F689",
        @"tram" : @"\U0001F68A",
        @"railway_track" : @"\U0001F6E4",
        @"bus" : @"\U0001F68C",
        @"oncoming_bus" : @"\U0001F68D",
        @"trolleybus" : @"\U0001F68E",
        @"minibus" : @"\U0001F690",
        @"ambulance" : @"\U0001F691",
        @"fire_engine" : @"\U0001F692",
        @"fire_engine_oncoming" : @"\U0001F6F1",
        @"police_car" : @"\U0001F693",
        @"oncoming_police_car" : @"\U0001F694",
        @"rotating_light" : @"\U0001F6A8",
        @"taxi" : @"\U0001F695",
        @"oncoming_taxi" : @"\U0001F696",
        @"red_car" : @"\U0001F697",
        @"oncoming_automobile" : @"\U0001F698",
        @"blue_car" : @"\U0001F699",
        @"truck" : @"\U0001F69A",
        @"articulated_lorry" : @"\U0001F69B",
        @"tractor" : @"\U0001F69C",
        @"bike" : @"\U0001F6B2",
        @"motorway" : @"\U0001F6E3",
        @"busstop" : @"\U0001F68F",
        @"fuelpump" : @"\U000026FD",
        @"construction" : @"\U0001F6A7",
        @"vertical_traffic_light" : @"\U0001F6A6",
        @"traffic_light" : @"\U0001F6A5",
        @"rocket" : @"\U0001F680",
        @"helicopter" : @"\U0001F681",
        @"airplane" : @"\U00002708",
        @"airplane_up" : @"\U0001F6E7",
        @"airplane_small_up" : @"\U0001F6E8",
        @"jet_up" : @"\U0001F6E6",
        @"airplane_northeast" : @"\U0001F6EA",
        @"airplane_small" : @"\U0001F6E9",
        @"airplane_departure" : @"\U0001F6EB",
        @"airplane_arriving" : @"\U0001F6EC",
        @"seat" : @"\U0001F4BA",
        @"anchor" : @"\U00002693",
        @"ship" : @"\U0001F6A2",
        @"cruise_ship" : @"\U0001F6F3",
        @"motorboat" : @"\U0001F6E5",
        @"speedboat" : @"\U0001F6A4",
        @"sailboat" : @"\U000026F5",
        @"aerial_tramway" : @"\U0001F6A1",
        @"mountain_cableway" : @"\U0001F6A0",
        @"suspension_railway" : @"\U0001F69F",
        @"passport_control" : @"\U0001F6C2",
        @"customs" : @"\U0001F6C3",
        @"baggage_claim" : @"\U0001F6C4",
        @"left_luggage" : @"\U0001F6C5",
        @"yen" : @"\U0001F4B4",
        @"euro" : @"\U0001F4B6",
        @"pound" : @"\U0001F4B7",
        @"dollar" : @"\U0001F4B5",
        @"bellhop" : @"\U0001F6CE",
        @"bed" : @"\U0001F6CF",
        @"couch" : @"\U0001F6CB",
        @"fork_knife_plate" : @"\U0001F37D",
        @"shopping_bags" : @"\U0001F6CD",
        @"statue_of_liberty" : @"\U0001F5FD",
        @"moyai" : @"\U0001F5FF",
        @"foggy" : @"\U0001F301",
        @"tokyo_tower" : @"\U0001F5FC",
        @"fountain" : @"\U000026F2",
        @"european_castle" : @"\U0001F3F0",
        @"japanese_castle" : @"\U0001F3EF",
        @"classical_building" : @"\U0001F3DB",
        @"stadium" : @"\U0001F3DF",
        @"mountain_snow" : @"\U0001F3D4",
        @"camping" : @"\U0001F3D5",
        @"beach" : @"\U0001F3D6",
        @"desert" : @"\U0001F3DC",
        @"island" : @"\U0001F3DD",
        @"park" : @"\U0001F3DE",
        @"cityscape" : @"\U0001F3D9",
        @"city_sunset" : @"\U0001F307",
        @"city_dusk" : @"\U0001F306",
        @"night_with_stars" : @"\U0001F303",
        @"bridge_at_night" : @"\U0001F309",
        @"house" : @"\U0001F3E0",
        @"homes" : @"\U0001F3D8",
        @"house_with_garden" : @"\U0001F3E1",
        @"house_abandoned" : @"\U0001F3DA",
        @"contruction_site" : @"\U0001F3D7",
        @"office" : @"\U0001F3E2",
        @"department_store" : @"\U0001F3EC",
        @"factory" : @"\U0001F3ED",
        @"post_office" : @"\U0001F3E3",
        @"european_post_office" : @"\U0001F3E4",
        @"hospital" : @"\U0001F3E5",
        @"bank" : @"\U0001F3E6",
        @"hotel" : @"\U0001F3E8",
        @"love_hotel" : @"\U0001F3E9",
        @"wedding" : @"\U0001F492",
        @"church" : @"\U000026EA",
        @"convenience_store" : @"\U0001F3EA",
        @"school" : @"\U0001F3EB",
        @"map" : @"\U0001F5FA",
        @"flag_au" : @"\U0001F1E6\U0001F1FA",
        @"flag_at" : @"\U0001F1E6\U0001F1F9",
        @"flag_be" : @"\U0001F1E7\U0001F1EA",
        @"flag_br" : @"\U0001F1E7\U0001F1F7",
        @"flag_ca" : @"\U0001F1E8\U0001F1E6",
        @"flag_cl" : @"\U0001F1E8\U0001F1F1",
        @"flag_cn" : @"\U0001F1E8\U0001F1F3",
        @"flag_co" : @"\U0001F1E8\U0001F1F4",
        @"flag_dk" : @"\U0001F1E9\U0001F1F0",
        @"flag_fi" : @"\U0001F1EB\U0001F1EE",
        @"flag_fr" : @"\U0001F1EB\U0001F1F7",
        @"flag_de" : @"\U0001F1E9\U0001F1EA",
        @"flag_hk" : @"\U0001F1ED\U0001F1F0",
        @"flag_in" : @"\U0001F1EE\U0001F1F3",
        @"flag_id" : @"\U0001F1EE\U0001F1E9",
        @"flag_ie" : @"\U0001F1EE\U0001F1EA",
        @"flag_il" : @"\U0001F1EE\U0001F1F1",
        @"flag_it" : @"\U0001F1EE\U0001F1F9",
        @"flag_jp" : @"\U0001F1EF\U0001F1F5",
        @"flag_kr" : @"\U0001F1F0\U0001F1F7",
        @"flag_mo" : @"\U0001F1F2\U0001F1F4",
        @"flag_my" : @"\U0001F1F2\U0001F1FE",
        @"flag_mx" : @"\U0001F1F2\U0001F1FD",
        @"flag_nl" : @"\U0001F1F3\U0001F1F1",
        @"flag_nz" : @"\U0001F1F3\U0001F1FF",
        @"flag_no" : @"\U0001F1F3\U0001F1F4",
        @"flag_ph" : @"\U0001F1F5\U0001F1ED",
        @"flag_pl" : @"\U0001F1F5\U0001F1F1",
        @"flag_pt" : @"\U0001F1F5\U0001F1F9",
        @"flag_pr" : @"\U0001F1F5\U0001F1F7",
        @"flag_ru" : @"\U0001F1F7\U0001F1FA",
        @"flag_sa" : @"\U0001F1F8\U0001F1E6",
        @"flag_sg" : @"\U0001F1F8\U0001F1EC",
        @"flag_za" : @"\U0001F1FF\U0001F1E6",
        @"flag_es" : @"\U0001F1EA\U0001F1F8",
        @"flag_se" : @"\U0001F1F8\U0001F1EA",
        @"flag_ch" : @"\U0001F1E8\U0001F1ED",
        @"flag_tr" : @"\U0001F1F9\U0001F1F7",
        @"flag_gb" : @"\U0001F1EC\U0001F1E7",
        @"flag_us" : @"\U0001F1FA\U0001F1F8",
        @"flag_ae" : @"\U0001F1E6\U0001F1EA",
        @"flag_vn" : @"\U0001F1FB\U0001F1F3",
        @"flag_af" : @"\U0001F1E6\U0001F1EB",
        @"flag_al" : @"\U0001F1E6\U0001F1F1",
        @"flag_dz" : @"\U0001F1E9\U0001F1FF",
        @"flag_ad" : @"\U0001F1E6\U0001F1E9",
        @"flag_ao" : @"\U0001F1E6\U0001F1F4",
        @"flag_ai" : @"\U0001F1E6\U0001F1EE",
        @"flag_ag" : @"\U0001F1E6\U0001F1EC",
        @"flag_ar" : @"\U0001F1E6\U0001F1F7",
        @"flag_am" : @"\U0001F1E6\U0001F1F2",
        @"flag_aw" : @"\U0001F1E6\U0001F1FC",
        @"flag_ac" : @"\U0001F1E6\U0001F1E8",
        @"flag_az" : @"\U0001F1E6\U0001F1FF",
        @"flag_bs" : @"\U0001F1E7\U0001F1F8",
        @"flag_bh" : @"\U0001F1E7\U0001F1ED",
        @"flag_bd" : @"\U0001F1E7\U0001F1E9",
        @"flag_bb" : @"\U0001F1E7\U0001F1E7",
        @"flag_by" : @"\U0001F1E7\U0001F1FE",
        @"flag_bz" : @"\U0001F1E7\U0001F1FF",
        @"flag_bj" : @"\U0001F1E7\U0001F1EF",
        @"flag_bm" : @"\U0001F1E7\U0001F1F2",
        @"flag_bt" : @"\U0001F1E7\U0001F1F9",
        @"flag_bo" : @"\U0001F1E7\U0001F1F4",
        @"flag_ba" : @"\U0001F1E7\U0001F1E6",
        @"flag_bw" : @"\U0001F1E7\U0001F1FC",
        @"flag_bn" : @"\U0001F1E7\U0001F1F3",
        @"flag_bg" : @"\U0001F1E7\U0001F1EC",
        @"flag_bf" : @"\U0001F1E7\U0001F1EB",
        @"flag_bi" : @"\U0001F1E7\U0001F1EE",
        @"flag_kh" : @"\U0001F1F0\U0001F1ED",
        @"flag_cm" : @"\U0001F1E8\U0001F1F2",
        @"flag_cv" : @"\U0001F1E8\U0001F1FB",
        @"flag_ky" : @"\U0001F1F0\U0001F1FE",
        @"flag_cf" : @"\U0001F1E8\U0001F1EB",
        @"flag_km" : @"\U0001F1F0\U0001F1F2",
        @"flag_cd" : @"\U0001F1E8\U0001F1E9",
        @"flag_cg" : @"\U0001F1E8\U0001F1EC",
        @"flag_td" : @"\U0001F1F9\U0001F1E9",
        @"flag_cr" : @"\U0001F1E8\U0001F1F7",
        @"flag_ci" : @"\U0001F1E8\U0001F1EE",
        @"flag_hr" : @"\U0001F1ED\U0001F1F7",
        @"flag_cu" : @"\U0001F1E8\U0001F1FA",
        @"flag_cy" : @"\U0001F1E8\U0001F1FE",
        @"flag_cz" : @"\U0001F1E8\U0001F1FF",
        @"flag_dj" : @"\U0001F1E9\U0001F1EF",
        @"flag_dm" : @"\U0001F1E9\U0001F1F2",
        @"flag_do" : @"\U0001F1E9\U0001F1F4",
        @"flag_tl" : @"\U0001F1F9\U0001F1F1",
        @"flag_ec" : @"\U0001F1EA\U0001F1E8",
        @"flag_eg" : @"\U0001F1EA\U0001F1EC",
        @"flag_sv" : @"\U0001F1F8\U0001F1FB",
        @"flag_gq" : @"\U0001F1EC\U0001F1F6",
        @"flag_er" : @"\U0001F1EA\U0001F1F7",
        @"flag_ee" : @"\U0001F1EA\U0001F1EA",
        @"flag_et" : @"\U0001F1EA\U0001F1F9",
        @"flag_fk" : @"\U0001F1EB\U0001F1F0",
        @"flag_fo" : @"\U0001F1EB\U0001F1F4",
        @"flag_fj" : @"\U0001F1EB\U0001F1EF",
        @"flag_pf" : @"\U0001F1F5\U0001F1EB",
        @"flag_ga" : @"\U0001F1EC\U0001F1E6",
        @"flag_gm" : @"\U0001F1EC\U0001F1F2",
        @"flag_ge" : @"\U0001F1EC\U0001F1EA",
        @"flag_gh" : @"\U0001F1EC\U0001F1ED",
        @"flag_gi" : @"\U0001F1EC\U0001F1EE",
        @"flag_gr" : @"\U0001F1EC\U0001F1F7",
        @"flag_gl" : @"\U0001F1EC\U0001F1F1",
        @"flag_gd" : @"\U0001F1EC\U0001F1E9",
        @"flag_gu" : @"\U0001F1EC\U0001F1FA",
        @"flag_gt" : @"\U0001F1EC\U0001F1F9",
        @"flag_gn" : @"\U0001F1EC\U0001F1F3",
        @"flag_gw" : @"\U0001F1EC\U0001F1FC",
        @"flag_gy" : @"\U0001F1EC\U0001F1FE",
        @"flag_ht" : @"\U0001F1ED\U0001F1F9",
        @"flag_hn" : @"\U0001F1ED\U0001F1F3",
        @"flag_hu" : @"\U0001F1ED\U0001F1FA",
        @"flag_is" : @"\U0001F1EE\U0001F1F8",
        @"flag_ir" : @"\U0001F1EE\U0001F1F7",
        @"flag_iq" : @"\U0001F1EE\U0001F1F6",
        @"flag_jm" : @"\U0001F1EF\U0001F1F2",
        @"flag_je" : @"\U0001F1EF\U0001F1EA",
        @"flag_jo" : @"\U0001F1EF\U0001F1F4",
        @"flag_kz" : @"\U0001F1F0\U0001F1FF",
        @"flag_ke" : @"\U0001F1F0\U0001F1EA",
        @"flag_ki" : @"\U0001F1F0\U0001F1EE",
        @"flag_xk" : @"\U0001F1FD\U0001F1F0",
        @"flag_kw" : @"\U0001F1F0\U0001F1FC",
        @"flag_kg" : @"\U0001F1F0\U0001F1EC",
        @"flag_la" : @"\U0001F1F1\U0001F1E6",
        @"flag_lv" : @"\U0001F1F1\U0001F1FB",
        @"flag_lb" : @"\U0001F1F1\U0001F1E7",
        @"flag_ls" : @"\U0001F1F1\U0001F1F8",
        @"flag_lr" : @"\U0001F1F1\U0001F1F7",
        @"flag_ly" : @"\U0001F1F1\U0001F1FE",
        @"flag_li" : @"\U0001F1F1\U0001F1EE",
        @"flag_lt" : @"\U0001F1F1\U0001F1F9",
        @"flag_lu" : @"\U0001F1F1\U0001F1FA",
        @"flag_mk" : @"\U0001F1F2\U0001F1F0",
        @"flag_mg" : @"\U0001F1F2\U0001F1EC",
        @"flag_mw" : @"\U0001F1F2\U0001F1FC",
        @"flag_mv" : @"\U0001F1F2\U0001F1FB",
        @"flag_ml" : @"\U0001F1F2\U0001F1F1",
        @"flag_mt" : @"\U0001F1F2\U0001F1F9",
        @"flag_mh" : @"\U0001F1F2\U0001F1ED",
        @"flag_mr" : @"\U0001F1F2\U0001F1F7",
        @"flag_mu" : @"\U0001F1F2\U0001F1FA",
        @"flag_fm" : @"\U0001F1EB\U0001F1F2",
        @"flag_md" : @"\U0001F1F2\U0001F1E9",
        @"flag_mc" : @"\U0001F1F2\U0001F1E8",
        @"flag_mn" : @"\U0001F1F2\U0001F1F3",
        @"flag_me" : @"\U0001F1F2\U0001F1EA",
        @"flag_ms" : @"\U0001F1F2\U0001F1F8",
        @"flag_ma" : @"\U0001F1F2\U0001F1E6",
        @"flag_mz" : @"\U0001F1F2\U0001F1FF",
        @"flag_mm" : @"\U0001F1F2\U0001F1F2",
        @"flag_na" : @"\U0001F1F3\U0001F1E6",
        @"flag_nr" : @"\U0001F1F3\U0001F1F7",
        @"flag_np" : @"\U0001F1F3\U0001F1F5",
        @"flag_nc" : @"\U0001F1F3\U0001F1E8",
        @"flag_ni" : @"\U0001F1F3\U0001F1EE",
        @"flag_ne" : @"\U0001F1F3\U0001F1EA",
        @"flag_ng" : @"\U0001F1F3\U0001F1EC",
        @"flag_nu" : @"\U0001F1F3\U0001F1FA",
        @"flag_kp" : @"\U0001F1F0\U0001F1F5",
        @"flag_om" : @"\U0001F1F4\U0001F1F2",
        @"flag_pk" : @"\U0001F1F5\U0001F1F0",
        @"flag_pw" : @"\U0001F1F5\U0001F1FC",
        @"flag_ps" : @"\U0001F1F5\U0001F1F8",
        @"flag_pa" : @"\U0001F1F5\U0001F1E6",
        @"flag_pg" : @"\U0001F1F5\U0001F1EC",
        @"flag_py" : @"\U0001F1F5\U0001F1FE",
        @"flag_pe" : @"\U0001F1F5\U0001F1EA",
        @"flag_qa" : @"\U0001F1F6\U0001F1E6",
        @"flag_ro" : @"\U0001F1F7\U0001F1F4",
        @"flag_rw" : @"\U0001F1F7\U0001F1FC",
        @"flag_sh" : @"\U0001F1F8\U0001F1ED",
        @"flag_kn" : @"\U0001F1F0\U0001F1F3",
        @"flag_lc" : @"\U0001F1F1\U0001F1E8",
        @"flag_vc" : @"\U0001F1FB\U0001F1E8",
        @"flag_ws" : @"\U0001F1FC\U0001F1F8",
        @"flag_sm" : @"\U0001F1F8\U0001F1F2",
        @"flag_st" : @"\U0001F1F8\U0001F1F9",
        @"flag_sn" : @"\U0001F1F8\U0001F1F3",
        @"flag_rs" : @"\U0001F1F7\U0001F1F8",
        @"flag_sc" : @"\U0001F1F8\U0001F1E8",
        @"flag_sl" : @"\U0001F1F8\U0001F1F1",
        @"flag_sk" : @"\U0001F1F8\U0001F1F0",
        @"flag_si" : @"\U0001F1F8\U0001F1EE",
        @"flag_sb" : @"\U0001F1F8\U0001F1E7",
        @"flag_so" : @"\U0001F1F8\U0001F1F4",
        @"flag_lk" : @"\U0001F1F1\U0001F1F0",
        @"flag_sd" : @"\U0001F1F8\U0001F1E9",
        @"flag_sr" : @"\U0001F1F8\U0001F1F7",
        @"flag_sz" : @"\U0001F1F8\U0001F1FF",
        @"flag_sy" : @"\U0001F1F8\U0001F1FE",
        @"flag_tw" : @"\U0001F1F9\U0001F1FC",
        @"flag_tj" : @"\U0001F1F9\U0001F1EF",
        @"flag_tz" : @"\U0001F1F9\U0001F1FF",
        @"flag_th" : @"\U0001F1F9\U0001F1ED",
        @"flag_tg" : @"\U0001F1F9\U0001F1EC",
        @"flag_to" : @"\U0001F1F9\U0001F1F4",
        @"flag_tt" : @"\U0001F1F9\U0001F1F9",
        @"flag_tn" : @"\U0001F1F9\U0001F1F3",
        @"flag_tm" : @"\U0001F1F9\U0001F1F2",
        @"flag_tv" : @"\U0001F1F9\U0001F1FB",
        @"flag_vi" : @"\U0001F1FB\U0001F1EE",
        @"flag_ug" : @"\U0001F1FA\U0001F1EC",
        @"flag_ua" : @"\U0001F1FA\U0001F1E6",
        @"flag_uy" : @"\U0001F1FA\U0001F1FE",
        @"flag_uz" : @"\U0001F1FA\U0001F1FF",
        @"flag_vu" : @"\U0001F1FB\U0001F1FA",
        @"flag_va" : @"\U0001F1FB\U0001F1E6",
        @"flag_ve" : @"\U0001F1FB\U0001F1EA",
        @"flag_wf" : @"\U0001F1FC\U0001F1EB",
        @"flag_eh" : @"\U0001F1EA\U0001F1ED",
        @"flag_ye" : @"\U0001F1FE\U0001F1EA",
        @"flag_zm" : @"\U0001F1FF\U0001F1F2",
        @"flag_zw" : @"\U0001F1FF\U0001F1FC",
            };
}

@end
