<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Encarte 1-4-1 (Preços Profissionais)</title>
<link href="https://fonts.googleapis.com/css2?family=Oswald:wght@700&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    /* --- RESET & GERAL --- */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background-color: #e0e0e0; 
        font-family: 'Montserrat', 'Arial Black', sans-serif;
        overflow: hidden;
    }

    /* --- LOGO FLUTUANTE --- */
    .logo-tv {
        position: absolute; top: 1vh; right: 2vw; height: 12vh; width: auto; z-index: 200;
        filter: drop-shadow(0 2px 5px rgba(0,0,0,0.5)); display: none;
        background: white; padding: 5px; border-radius: 10px;
    }

    /* --- TOPO --- */
    #topo {
        width: 100%; height: 15vh; 
        background: linear-gradient(to right, #b71c1c, #d32f2f, #b71c1c);
        border-bottom: 0.8vh solid #ffc107;
        text-align: center;
        position: absolute; top: 0; left: 0; z-index: 100;
        box-shadow: 0 1vh 3vh rgba(0,0,0,0.4);
        display: flex; align-items: center; justify-content: center;
    }
    #topo h1 {
        font-family: 'Montserrat', 'Arial Black', sans-serif;
        font-weight: 900;
        font-size: 8vh; 
        color: #ffc107; 
        text-transform: uppercase; margin: 0;
        letter-spacing: 0.5vw;
        text-shadow: 0.3vh 0.3vh 1vh rgba(0,0,0,0.5);
        margin-right: 15vw;
    }

    /* --- ÁREA PRINCIPAL --- */
    #main-container {
        position: absolute; top: 15vh; left: 0; width: 100%; height: 85vh;
        padding: 1vh 1vw;
        display: flex; transition: opacity 0.5s;
    }

    .col-lateral { width: 25%; height: 100%; padding: 1vh; }
    
    .col-central { 
        width: 50%; height: 100%; 
        padding: 0.5vh;
        display: grid;
        grid-template-columns: 1fr 1fr;
        grid-template-rows: 1fr 1fr;
        gap: 1vh;
    }

    /* =======================================
       CARD LATERAL (Vermelho) 
       ======================================= */
    .card-lateral {
        width: 100%; height: 98%;
        background: linear-gradient(135deg, #c62828 0%, #b71c1c 100%);
        border-radius: 3vh;
        box-shadow: 0 2vh 4vh rgba(0,0,0,0.4);
        border: 0.3vh solid rgba(255,255,255,0.2);
        position: relative;
        display: flex; flex-direction: column; 
        justify-content: space-between; overflow: hidden;
        animation: fadeIn 0.5s ease;
    }
    
    .lat-tag {
        position: absolute; top: 2vh; right: -1vw; 
        background: #ffc107; color: #b71c1c;
        padding: 0.5vh 2vw; font-weight: 900; font-size: 2.5vh;
        box-shadow: 0.3vh 0.3vh 1vh rgba(0,0,0,0.3);
        transform: rotate(5deg); z-index: 20;
    }

    .lat-img {
        width: 100%; flex-grow: 1; 
        display: flex; align-items: center; justify-content: center;
        padding: 1vh; z-index: 10; min-height: 0;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,0,0,0) 70%);
    }
    .lat-img img { 
        max-height: 90%; max-width: 90%; 
        object-fit: contain; filter: drop-shadow(0 3vh 3vh rgba(0,0,0,0.5));
    }
    
    .lat-nome {
        width: 100%; flex-shrink: 0;
        text-align: center; color: white; font-weight: 900; 
        font-size: 4.5vh; padding: 0 1vw 1vh 1vw; 
        line-height: 1.1; text-transform: uppercase;
        text-shadow: 0.2vh 0.2vh 0.5vh rgba(0,0,0,0.3); z-index: 20;
    }
    
    .lat-footer {
        width: 100%; height: 25%; display: flex; align-items: center; justify-content: center;
        padding-bottom: 2vh; flex-shrink: 0;
    }
    
    .lat-preco-box {
        width: 90%; height: 100%;
        background: rgba(255,255,255,0.1);
        border: 0.3vh solid rgba(255,255,255,0.5);
        border-radius: 2vh;
        display: flex; align-items: center; justify-content: center; color: #fff;
        padding: 0 1vw;
    }
    
    /* MODIFICAÇÃO: PREÇO LATERAL COM CENTAVOS PEQUENOS */
    .lat-rs { font-size: 4vh; font-weight: bold; color: #ffc107; margin-right: 0.5vw; align-self: center; margin-bottom: 3vh;}
    
    .lat-valor { 
        font-family: 'Oswald', 'Arial Black', sans-serif; 
        font-size: 11vh; 
        font-weight: 700; 
        letter-spacing: -0.3vh; 
        line-height: 1;
        text-shadow: 0.4vh 0.4vh 0 rgba(0,0,0,0.2);
        display: flex; align-items: baseline;
    }
    .lat-valor .centavos { font-size: 0.55em; margin-left: 0.2vw;}
    
    .lat-un { font-size: 2.5vh; font-weight: 700; color: #ffc107; align-self: flex-end; margin-bottom: 2vh; margin-left: 0.5vw;}


    /* =======================================
       CARD CENTRAL (Amarelo) 
       ======================================= */
    .card-central {
        width: 100%; height: 100%;
        background: linear-gradient(to bottom, #fff59d, #ffeb3b);
        border-radius: 2vh; box-shadow: 0 1vh 2vh rgba(0,0,0,0.15);
        border: 0.3vh solid #fdd835;
        display: flex; flex-direction: column; overflow: hidden;
        animation: fadeIn 0.5s ease;
    }
    .cen-img {
        width: 100%; flex-grow: 1; 
        display: flex; align-items: center; justify-content: center;
        padding: 0.5vh; min-height: 0;
    }
    .cen-img img { 
        max-height: 90%; max-width: 90%; 
        object-fit: contain; filter: drop-shadow(0 1vh 2vh rgba(0,0,0,0.2));
    }
    .cen-nome {
        width: 100%; flex-shrink: 0;
        text-align: center; color: #b71c1c; font-weight: 800; 
        font-size: 3.2vh; padding: 0 0.5vw 0.5vh 0.5vw; 
        line-height: 1.1; text-transform: uppercase;
        display: flex; align-items: center; justify-content: center;
    }
    
    .cen-preco {
        width: 100%; height: 32%; flex-shrink: 0;
        background: rgba(255,255,255,0.5);
        border-top: 0.2vh solid rgba(0,0,0,0.1);
        display: flex; align-items: center; justify-content: center;
        padding: 0 1vw;
    }
    
    /* MODIFICAÇÃO: PREÇO CENTRAL COM CENTAVOS PEQUENOS */
    .cen-rs { font-size: 2.5vh; color: #333; font-weight: bold; margin-right: 0.5vw; align-self: center; margin-bottom: 1.5vh;}
    
    .cen-valor {
        font-family: 'Oswald', 'Arial Black', sans-serif; 
        font-size: 8vh; 
        color: #d50000; 
        font-weight: 700; 
        letter-spacing: -0.2vh; 
        line-height: 1;
        display: flex; align-items: baseline;
    }
    .cen-valor .centavos { font-size: 0.55em; margin-left: 0.1vw;}
    
    .cen-un { font-size: 1.8vh; color: #555; font-weight: 700; align-self: flex-end; margin-bottom: 1vh; margin-left: 0.5vw;}


    /* --- CAMADA VÍDEO --- */
    #video-container {
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: black; z-index: 9999; display: none; align-items: center; justify-content: center;
    }
    video { width: 100%; height: 100%; object-fit: contain; }

    /* STATUS & PAGINAÇÃO */
    #status-msg { position: fixed; bottom: 50%; left: 50%; transform: translate(-50%,50%); background: rgba(0,0,0,0.8); color: white; padding: 20px; border-radius: 10px; display: none; z-index: 99999; }
    .paginacao { position: fixed; bottom: 5px; right: 5px; font-size: 2vh; color: #999; font-weight: bold; display: none; }

    @keyframes fadeIn { from { opacity: 0; transform: scale(0.95); } to { opacity: 1; transform: scale(1); } }
</style>
</head>
<body>

    <img id="img-logo-topo" class="logo-tv" src="">

    <div id="topo">
        <h1 id="titulo-texto">OFERTAS ESPECIAIS</h1>
    </div>

    <div id="status-msg">Carregando...</div>

    <div id="main-container">
        <div class="col-lateral" id="col-esquerda"></div>
        <div class="col-central" id="col-centro"></div>
        <div class="col-lateral" id="col-direita"></div>
        <div class="paginacao" id="texto-paginacao"></div>
    </div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>

    <script type="text/javascript">
        // CONFIGURAÇÕES SEGURAS XIBO
        var API_URL = '../destaque-mercado.php'; 
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
        
        var TEMPO_TROCA = 8000; 
        var ITENS_POR_PAGINA = 6; 
        var LOOPS_PARA_COMERCIAL = 3;
        var TEMPO_ATUALIZACAO = 60000; 
        
        var listaProdutos = [];
        var listaVideos = [];
        
        var idxProd = 0;
        var idxVideo = 0;
        var loops = 0;
        var timer = null;

        // NOVA FUNÇÃO: Formata o valor e isola os centavos num <span>
        function formatarMoedaHTML(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            let formatado = isNaN(v) ? "0,00" : v.toFixed(2).replace('.', ',');
            let partes = formatado.split(',');
            return partes[0] + '<span class="centavos">,' + partes[1] + '</span>';
        }

        function baixarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            fetch(API_URL + '?uid=' + uid + '&t=' + Date.now())
                .then(function(r) { return r.json(); })
                .then(function(json) {
                    var dadosItens = [];
                    if (json.itens) {
                        dadosItens = json.itens;
                        var logoEl = document.getElementById('img-logo-topo');
                        if (json.meta && json.meta.logo) {
                            logoEl.src = json.meta.logo; 
                            logoEl.style.display = 'block';
                        } else { 
                            logoEl.style.display = 'none'; 
                        }
                    } else { 
                        dadosItens = Array.isArray(json) ? json : []; 
                    }

                    listaVideos = dadosItens.filter(function(i) { return i.is_video == 1 || (i.imagem && i.imagem.match(/\.(mp4|webm)$/i)); });
                    listaProdutos = dadosItens.filter(function(i) { return i.is_video != 1 && !(i.imagem && i.imagem.match(/\.(mp4|webm)$/i)); });
                    
                    if(listaProdutos.length === 0 && listaVideos.length === 0) {
                        document.getElementById('status-msg').style.display = 'block';
                        document.getElementById('status-msg').innerText = "Sem conteúdo.";
                    } else {
                        document.getElementById('status-msg').style.display = 'none';
                        if (!timer) rodarOfertas();
                    }
                })
                .catch(function(e) {
                    console.log(e);
                    document.getElementById('status-msg').style.display = 'block';
                    document.getElementById('status-msg').innerText = "Erro API";
                });
        }

        // --- HTML BUILDERS (Agora usando a função formatarMoedaHTML) ---
        function getHtmlLateral(item) {
            if(!item) return '<div class="card-lateral" style="opacity:0"></div>';
            var img = item.imagem || placeholder;
            if(img && !img.includes('http') && !img.startsWith('../')) img = '../' + img;
            
            var unidade = item.unidade || 'un';

            return '<div class="card-lateral">' +
                   '<div class="lat-tag">OFERTA</div>' +
                   '<div class="lat-img"><img src="' + img + '" onerror="this.src=\'' + placeholder + '\'"></div>' +
                   '<div class="lat-nome"><span>' + item.produto + '</span></div>' +
                   '<div class="lat-footer">' +
                   '<div class="lat-preco-box">' +
                   '<span class="lat-rs">R$</span>' +
                   '<span class="lat-valor">' + formatarMoedaHTML(item.preco) + '</span>' +
                   '<span class="lat-un">/' + unidade + '</span>' +
                   '</div></div></div>';
        }

        function getHtmlCentral(item) {
            if(!item) return '<div class="card-central" style="opacity:0"></div>';
            var img = item.imagem || placeholder;
            if(img && !img.includes('http') && !img.startsWith('../')) img = '../' + img;
            
            var unidade = item.unidade || 'un';

            return '<div class="card-central">' +
                   '<div class="cen-img"><img src="' + img + '" onerror="this.src=\'' + placeholder + '\'"></div>' +
                   '<div class="cen-nome"><span>' + item.produto + '</span></div>' +
                   '<div class="cen-preco">' +
                   '<span class="cen-rs">R$</span>' +
                   '<span class="cen-valor">' + formatarMoedaHTML(item.preco) + '</span>' +
                   '<span class="cen-un">/' + unidade + '</span>' +
                   '</div></div>';
        }

        function rodarOfertas() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('main-container').style.opacity = '1';
            document.getElementById('topo').style.opacity = '1';
            document.getElementById('player').pause();

            if (listaProdutos.length === 0) {
                if(listaVideos.length > 0) { rodarVideo(); return; }
                timer = setTimeout(baixarDados, 3000); return;
            }

            if (idxProd >= listaProdutos.length) {
                idxProd = 0;
                loops++;
                if (loops >= LOOPS_PARA_COMERCIAL && listaVideos.length > 0) {
                    loops = 0; clearTimeout(timer); rodarVideo(); return;
                }
            }

            var colEsq = document.getElementById('col-esquerda');
            var colCen = document.getElementById('col-centro');
            var colDir = document.getElementById('col-direita');
            
            colEsq.innerHTML = ''; colCen.innerHTML = ''; colDir.innerHTML = '';

            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var item = listaProdutos[(idxProd + i) % listaProdutos.length];
                
                if(listaProdutos.length <= 1 && i > 0) item = null;

                if (i === 0) colEsq.innerHTML = getHtmlLateral(item);
                else if (i >= 1 && i <= 4) colCen.innerHTML += getHtmlCentral(item);
                else if (i === 5) colDir.innerHTML = getHtmlLateral(item);
            }

            var pag = Math.ceil((idxProd + 1) / ITENS_POR_PAGINA);
            var tot = Math.ceil(listaProdutos.length / ITENS_POR_PAGINA);
            document.getElementById('texto-paginacao').innerText = 'Pág ' + pag + '/' + tot;

            idxProd += ITENS_POR_PAGINA;
            timer = setTimeout(rodarOfertas, TEMPO_TROCA);
        }

        function rodarVideo() {
            var itemVideo = listaVideos[idxVideo % listaVideos.length];
            var player = document.getElementById('player');
            
            document.getElementById('main-container').style.opacity = '0';
            document.getElementById('topo').style.opacity = '0';
            var containerVid = document.getElementById('video-container');
            containerVid.style.display = 'flex'; 

            var src = itemVideo.imagem;
            if(src && !src.includes('http') && !src.startsWith('../')) src = '../' + src;

            player.src = src;
            player.loop = false; player.currentTime = 0;
            player.muted = false; 
            
            var promessa = player.play();
            if(promessa !== undefined){
                promessa.catch(function() { player.muted = true; player.play(); });
            }

            var check = setTimeout(function() { if(player.readyState < 2) encerrarComercial(); }, 8000);
            player.onended = function() { clearTimeout(check); encerrarComercial(); };
            player.onerror = function() { clearTimeout(check); encerrarComercial(); };
        }

        function encerrarComercial() {
            var player = document.getElementById('player');
            player.pause(); player.removeAttribute('src'); player.load(); 
            idxVideo++;
            rodarOfertas();
        }

        window.onload = function() { baixarDados(); setInterval(baixarDados, TEMPO_ATUALIZACAO); };
    </script>
</body>
</html>