<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>MGA TV - Final com Logo (Box Vermelho)</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap" rel="stylesheet">
<style>
    /* --- ESTILOS GERAIS --- */
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body, html { width: 100%; height: 100%; overflow: hidden; background-color: #000; font-family: 'Roboto', Arial, sans-serif; }

    /* LAYOUT OFERTAS (Fundo Branco) */
    #ofertas-container {
        position: absolute; top: 0; left: 0; width: 100%; height: 100%;
        background: #fff; z-index: 10;
        display: flex; flex-direction: column;
        transition: opacity 0.5s;
    }

    /* LOGOMARCA FLUTUANTE */
    .logo-tv {
        position: absolute;
        top: 1vh;
        right: 2vw;
        height: 12vh; 
        width: auto;
        z-index: 50; 
        filter: drop-shadow(0 2px 5px rgba(0,0,0,0.5));
        display: none; 
        background: white; 
        padding: 5px;
        border-radius: 10px;
    }

    /* CABEÇALHO */
    header { height: 14vh; background: #d32f2f; color: white; display: flex; align-items: center; padding: 0 3vw; box-shadow: 0 5px 15px rgba(0,0,0,0.3); }
    header h1 { font-size: 6vh; margin: 0; flex-grow: 1; text-transform: uppercase; font-weight: 900; letter-spacing: 2px; margin-right: 15vw; }
    header .logo-area { font-size: 2.5vh; background: white; color: #d32f2f; padding: 1vh 2vw; border-radius: 50px; font-weight: bold; text-transform: uppercase; }

    /* CORPO PRINCIPAL */
    #layout-principal { display: flex; width: 100%; height: 86vh; padding: 2vh 2vw; gap: 2vw; }
    
    /* ESQUERDA (LISTA DE PRODUTOS) */
    #coluna-lista { width: 65%; height: 100%; display: flex; flex-direction: column; gap: 1.5vh; }
    
    .linha-produto { background: #fff9c4; flex: 1; border-radius: 15px; display: flex; align-items: center; padding: 0 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-left: 15px solid #d32f2f; overflow: hidden; }
    .linha-vazia { background: transparent !important; border: none !important; box-shadow: none !important; flex: 1; }
    
    .img-tabela { height: 85%; aspect-ratio: 1/1; object-fit: contain; margin-right: 20px; background: #fff; border-radius: 10px; border: 1px solid #eee; }
    .nome-tabela { flex-grow: 1; font-size: 5vh; color: #333; font-weight: 700; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    
    /* ============================================================
       MODIFICAÇÃO: BOX VERMELHO - MAIOR E TOTALMENTE CENTRALIZADO 
       ============================================================ */
    .preco-box-tabela { 
        background-color: #d32f2f; /* Fundo Vermelho */
        width: 18vw; /* Largura fixa e ampla para não amassar o preço */
        height: 10vh; /* Altura do box */
        flex-shrink: 0; /* Impede que o nome empurre e comprima este box */
        border-radius: 1vh;
        display: flex; 
        align-items: center; /* Centraliza no eixo vertical */
        justify-content: center; /* Centraliza no eixo horizontal */
        padding: 0 1vw; 
        box-shadow: 0 3px 6px rgba(0,0,0,0.2);
        margin-left: 1vw; 
    }
    
    .moeda-tab { font-size: 3.2vh; color: #ffc107; font-weight: bold; margin-right: 0.5vw; margin-bottom: 1.5vh; }
    
    .valor-tab { 
        font-size: 8vh; /* Fonte muito maior */
        font-weight: 900; color: #ffffff; /* Cor branca para contrastar com vermelho */
        line-height: 1; display: flex; align-items: baseline; 
    }
    .valor-tab .centavos { font-size: 0.6em; margin-left: 0.1vw;}
    
    .un-tab { font-size: 2.5vh; color: #ffc107; font-weight: 600; margin-left: 0.5vw; margin-bottom: 1.5vh; }
    
    /* ============================================================ */

    /* DIREITA (DESTAQUE) */
    #coluna-destaque { width: 33%; height: 100%; }
    .card-destaque { width: 100%; height: 100%; background: #d32f2f; border-radius: 20px; border: 6px solid #ffc107; display: flex; flex-direction: column; overflow: hidden; position: relative; box-shadow: 0 10px 20px rgba(0,0,0,0.3); }
    
    .topo-destaque { height: 12%; background: #8e0000; color: #ffc107; display: flex; align-items: center; justify-content: center; font-size: 3.5vh; font-weight: 900; text-transform: uppercase; letter-spacing: 1px; }
    .area-foto-destaque { height: 48%; width: 100%; padding: 20px; display: flex; align-items: center; justify-content: center; background: radial-gradient(circle, #ffCDD2 0%, #ffffff 100%); }
    .foto-destaque { max-width: 90%; max-height: 90%; object-fit: contain; filter: drop-shadow(0 10px 10px rgba(0,0,0,0.3)); }
    
    .info-destaque { height: 40%; background: #d32f2f; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 10px; color: white; }
    .nome-destaque { font-size: 4vh; font-weight: 900; text-align: center; margin-bottom: 10px; line-height: 1.1; text-transform: uppercase; text-shadow: 1px 1px 3px rgba(0,0,0,0.3); }
    
    .preco-container-destaque { display: flex; align-items: flex-start; justify-content: center; line-height: 1; }
    
    /* MODIFICAÇÃO: Centavos menores no Destaque */
    .rs-destaque { font-size: 5vh; color: #ffc107; font-weight: bold; margin-right: 5px; margin-top: 1vh; }
    .valor-destaque { 
        font-size: 13vh; color: #ffffff; font-weight: 900; letter-spacing: -2px; text-shadow: 3px 3px 6px rgba(0,0,0,0.4); 
        display: flex; align-items: baseline;
    }
    .valor-destaque .centavos { font-size: 0.55em; margin-left: 0.1vw;}
    .un-destaque { font-size: 3vh; color: #ffc107; font-weight: bold; align-self: flex-end; margin-bottom: 20px; margin-left: 5px; }

    /* CAMADA VÍDEO (Intervalo) */
    #video-container {
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: black; 
        z-index: 99999; 
        display: none; 
        align-items: center; justify-content: center;
    }
    video { width: 100%; height: 100%; object-fit: contain; background: black; }

    /* Status Msg */
    #status-msg { 
        position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%);
        background: rgba(0,0,0,0.8); color: white; padding: 20px 40px; 
        border-radius: 10px; font-size: 24px; z-index: 200000; text-align: center;
    }
    .paginacao { position: absolute; bottom: 1vh; left: 3vw; font-size: 2.5vh; color: #999; font-weight: bold; display: none; }
</style>
</head>
<body>

    <div id="status-msg">Carregando Sistema...</div>

    <div id="ofertas-container">
        
        <img id="img-logo-topo" class="logo-tv" src="">

        <header><h1>Ofertas do Dia</h1></header>
        <div id="layout-principal">
            
            <div id="coluna-lista"></div>
            
            <div id="coluna-destaque">
                <div class="card-destaque" id="painel-destaque">
                    <div class="topo-destaque">Super Oferta</div>
                    <div class="area-foto-destaque"><img id="img-d" src="" class="foto-destaque"></div>
                    <div class="info-destaque">
                        <div id="nome-d" class="nome-destaque">...</div>
                        <div class="preco-container-destaque">
                            <span class="rs-destaque">R$</span>
                            <span id="preco-d" class="valor-destaque">...</span>
                            <span id="un-d" class="un-destaque">/un</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="paginacao" id="texto-paginacao"></div>
    </div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>

    <script>
        // === CONFIGURAÇÕES ===
        var API_URL = '../destaque-mercado.php'; 
        
        var ITENS_POR_PAGINA = 5;      
        var TEMPO_POR_PAGINA = 8000; 
        var LOOPS_PARA_COMERCIAL = 3; 
        var TEMPO_ATUALIZACAO_API = 60000; 
        
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';

        // --- ESTADO ---
        var listaProdutos = [];
        var listaDestaques = [];
        var listaVideos = [];
        
        var idxProd = 0; 
        var idxDest = 0;
        var idxVideo = 0;
        var contadorLoops = 0; 
        var timerOfertas = null;
        var monitorTravamento = null;

        // --- NOVA FUNÇÃO: Formata o valor e isola os centavos num <span> ---
        function formatarMoedaHTML(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            let formatado = isNaN(v) ? "0,00" : v.toFixed(2).replace('.', ',');
            let partes = formatado.split(',');
            return partes[0] + '<span class="centavos">,' + partes[1] + '</span>';
        }

        // --- CARREGAMENTO ---
        function baixarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            
            fetch(API_URL + '?uid=' + uid + '&t=' + Date.now())
                .then(response => {
                    if (!response.ok) throw new Error("Erro HTTP " + response.status);
                    return response.json();
                })
                .then(json => {
                    var dadosItens = [];
                    
                    if (json.itens) {
                        dadosItens = json.itens;
                        var logoEl = document.getElementById('img-logo-topo');
                        if (json.meta && json.meta.logo) {
                            logoEl.src = json.meta.logo;
                            logoEl.style.display = 'block';
                        } else {
                            logoEl.style.display = 'none';
                        }
                    } else if (Array.isArray(json)) {
                        dadosItens = json;
                    } else {
                        dadosItens = [];
                    }

                    var validos = dadosItens; 
                    
                    listaVideos = validos.filter(i => i.is_video == 1 || (i.imagem && i.imagem.match(/\.(mp4|webm|ogg)$/i)));
                    listaProdutos = validos.filter(i => i.is_video != 1 && !(i.imagem && i.imagem.match(/\.(mp4|webm|ogg)$/i)));
                    
                    listaDestaques = listaProdutos.filter(i => i.destaque == 1);
                    if(listaDestaques.length === 0) listaDestaques = listaProdutos;

                    if(listaProdutos.length === 0 && listaVideos.length === 0) {
                        document.getElementById('status-msg').style.display = 'block';
                        document.getElementById('status-msg').innerText = "Aguardando conteúdo...";
                    } else {
                        document.getElementById('status-msg').style.display = 'none';
                        if (!timerOfertas) rodarOfertas();
                    }
                })
                .catch(erro => {
                    console.error(erro);
                    document.getElementById('status-msg').style.display = 'block';
                    document.getElementById('status-msg').innerText = "Erro na API: " + erro.message;
                });
        }

        // --- OFERTAS ---
        function rodarOfertas() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('ofertas-container').style.opacity = '1';
            
            var player = document.getElementById('player');
            if(!player.paused) player.pause();
            clearInterval(monitorTravamento);

            if (listaProdutos.length === 0) {
                if(listaVideos.length > 0) { rodarVideo(); return; }
                timerOfertas = setTimeout(baixarDados, 3000); 
                return;
            }

            // Loop / Paginação
            if (idxProd >= listaProdutos.length) {
                idxProd = 0; 
                contadorLoops++;   
                
                if (contadorLoops >= LOOPS_PARA_COMERCIAL && listaVideos.length > 0) {
                    contadorLoops = 0; 
                    clearTimeout(timerOfertas);
                    rodarVideo(); 
                    return;
                }
            }

            // Atualiza Lista
            var container = document.getElementById('coluna-lista');
            container.innerHTML = '';
            var fatia = listaProdutos.slice(idxProd, idxProd + ITENS_POR_PAGINA);
            
            fatia.forEach(item => {
                var imgUrl = item.imagem || placeholder;
                if(imgUrl && !imgUrl.includes('http') && !imgUrl.startsWith('../')) {
                    imgUrl = '../' + imgUrl;
                }

                // Uso da função formatarMoedaHTML no box vermelho
                var html = `
                    <div class="linha-produto">
                        <img src="${imgUrl}" class="img-tabela" onerror="this.src='${placeholder}'">
                        <div class="nome-tabela">${item.produto}</div>
                        <div class="preco-box-tabela">
                            <span class="moeda-tab">R$</span>
                            <span class="valor-tab">${formatarMoedaHTML(item.preco)}</span>
                            <span class="un-tab">/${item.unidade || 'un'}</span>
                        </div>
                    </div>`;
                container.insertAdjacentHTML('beforeend', html);
            });

            while(container.children.length < ITENS_POR_PAGINA) {
                container.insertAdjacentHTML('beforeend', '<div class="linha-vazia"></div>');
            }
            
            var pag = Math.ceil((idxProd + 1) / ITENS_POR_PAGINA);
            var tot = Math.ceil(listaProdutos.length / ITENS_POR_PAGINA);
            document.getElementById('texto-paginacao').innerText = `Página ${pag}/${tot}`;

            // Atualiza Destaque
            if(listaDestaques.length > 0) {
                var itemD = listaDestaques[idxDest % listaDestaques.length];
                var imgD = itemD.imagem || placeholder;
                if(imgD && !imgD.includes('http') && !imgD.startsWith('../')) {
                    imgD = '../' + imgD;
                }

                var painel = document.getElementById('painel-destaque');
                painel.style.opacity = 0.5;
                setTimeout(() => {
                    document.getElementById('img-d').src = imgD;
                    document.getElementById('nome-d').innerText = itemD.produto;
                    // Alterado para innerHTML para ler as tags dos centavos
                    document.getElementById('preco-d').innerHTML = formatarMoedaHTML(itemD.preco);
                    document.getElementById('un-d').innerText = '/' + (itemD.unidade || 'un');
                    painel.style.opacity = 1;
                }, 200);
                idxDest++;
            }

            idxProd += ITENS_POR_PAGINA; 
            timerOfertas = setTimeout(rodarOfertas, TEMPO_POR_PAGINA);
        }

        // --- VÍDEO ---
        function rodarVideo() {
            var itemVideo = listaVideos[idxVideo % listaVideos.length];
            var player = document.getElementById('player');
            
            document.getElementById('ofertas-container').style.opacity = '0';
            var containerVid = document.getElementById('video-container');
            containerVid.style.display = 'flex'; 

            var videoSrc = itemVideo.imagem;
            if (videoSrc && !videoSrc.includes('http') && !videoSrc.startsWith('../')) {
                videoSrc = '../' + videoSrc;
            }

            console.log("Play Vídeo: " + videoSrc);
            player.src = videoSrc;
            player.loop = false; 
            player.currentTime = 0;
            player.muted = false; 
            
            var promessa = player.play();
            if (promessa !== undefined) {
                promessa.catch(error => { 
                    console.log("Autoplay bloqueado. Mudo.");
                    player.muted = true; 
                    player.play(); 
                }); 
            }

            var checkTravamento = setTimeout(() => { 
                if(player.readyState < 2) { 
                    console.log("Timeout Vídeo"); 
                    encerrarComercial(); 
                } 
            }, 8000);

            player.onended = function() { clearTimeout(checkTravamento); encerrarComercial(); };
            player.onerror = function() { clearTimeout(checkTravamento); encerrarComercial(); };
        }

        function encerrarComercial() {
            var player = document.getElementById('player');
            player.pause();
            player.removeAttribute('src'); 
            player.load(); 
            idxVideo++;
            rodarOfertas();
        }

        window.onload = function() {
            baixarDados();
            setInterval(baixarDados, TEMPO_ATUALIZACAO_API);
        };

    </script>
</body>
</html>