<?php
// destaque-mercado.php - COM LOGO
error_reporting(0);
ini_set('display_errors', 0);
ob_start();

header("Access-Control-Allow-Origin: *");
header("Cache-Control: no-cache, no-store, must-revalidate"); 
header("Content-Type: application/json; charset=utf-8");

require 'config.php';
ob_clean(); 

try {
    $uid = isset($_GET['uid']) ? (int)$_GET['uid'] : 1;

    // URL Base
    $protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $caminho = dirname($_SERVER['PHP_SELF']); // Remove nome do arquivo
    $baseUrl = $protocolo . "://" . $host . str_replace(basename($_SERVER['PHP_SELF']), '', $_SERVER['PHP_SELF']);

    // 1. VERIFICA SE EXISTE LOGO PARA O USUÁRIO
    $caminhoLogo = "uploads/logo_" . $uid . ".png";
    $urlLogo = null;
    if (file_exists($caminhoLogo)) {
        // Adiciona time() para forçar atualização no player
        $urlLogo = $baseUrl . $caminhoLogo . "?v=" . time();
    }

    // 2. BUSCA NO BANCO
    $colunaExiste = false;
    try { $pdo->query("SELECT 1 FROM ofertas WHERE is_video = 0 LIMIT 1"); $colunaExiste = true; } catch(Exception $e){}

    $sql = $colunaExiste 
        ? "SELECT * FROM ofertas WHERE ativo = 1 AND usuario_id = :uid ORDER BY destaque DESC, id DESC"
        : "SELECT *, 0 as is_video FROM ofertas WHERE ativo = 1 AND usuario_id = :uid ORDER BY destaque DESC, id DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([':uid' => $uid]);
    $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 3. MONTA RESPOSTA
    $response = [
        'meta' => [
            'logo' => $urlLogo, // Aqui vai a logo
            'empresa_id' => $uid
        ],
        'itens' => []
    ];

    // 4. PROCESSA ITENS
    foreach ($dados as $item) {
        $arquivo = $item['imagem'];
        $ext = strtolower(pathinfo($arquivo, PATHINFO_EXTENSION));

        if (in_array($ext, ['mp4', 'webm', 'ogg', 'mov'])) {
            $item['is_video'] = 1;
        }

        if (empty($arquivo)) {
            $item['imagem'] = ""; 
        } elseif (strpos($arquivo, 'http') !== 0) {
            $caminhoLimpo = ltrim($arquivo, '/');
            $item['imagem'] = $baseUrl . $caminhoLimpo;
        }
        
        $response['itens'][] = $item;
    }

    echo json_encode($response);

} catch (Exception $e) {
    echo json_encode(['meta'=>[], 'itens'=>[]]);
}
?>