<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>MGA TV - Universal URL (Box Fixo)</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap" rel="stylesheet">
<style>
    /* --- ESTILOS GERAIS --- */
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body, html { width: 100%; height: 100%; overflow: hidden; background-color: #000; font-family: 'Roboto', Arial, sans-serif; }

    /* LAYOUT OFERTAS */
    #ofertas-container {
        position: absolute; top: 0; left: 0; width: 100%; height: 100%;
        background: #fff; z-index: 10; display: flex; flex-direction: column; transition: opacity 0.5s;
    }

    /* LOGO */
    .logo-tv {
        position: absolute; top: 1vh; right: 2vw; height: 12vh; width: auto;
        z-index: 50; filter: drop-shadow(0 2px 5px rgba(0,0,0,0.5)); display: none;
        background: white; padding: 5px; border-radius: 10px;
    }

    /* CABEÇALHO */
    header { height: 14vh; background: #d32f2f; color: white; display: flex; align-items: center; padding: 0 3vw; box-shadow: 0 5px 15px rgba(0,0,0,0.3); }
    header h1 { font-size: 6vh; margin: 0; flex-grow: 1; text-transform: uppercase; font-weight: 900; letter-spacing: 2px; margin-right: 15vw; }

    /* CORPO PRINCIPAL */
    #layout-principal { display: flex; width: 100%; height: 86vh; padding: 1.5vh 2vw; gap: 2vw; }
    
    /* ESQUERDA (LISTA DE PRODUTOS) */
    #coluna-lista { width: 65%; height: 100%; display: flex; flex-direction: column; gap: 0.8vh; }
    
    .linha-produto { 
        background: #fff9c4; flex: 1; border-radius: 1vh; 
        display: flex; align-items: center; justify-content: space-between;
        padding: 0 1vw 0 1.5vw; box-shadow: 0 0.2vh 0.4vh rgba(0,0,0,0.1); 
        border-left: 1vh solid #d32f2f; overflow: hidden; 
    }
    .linha-vazia { background: transparent !important; border: none !important; box-shadow: none !important; flex: 1; }
    
    .nome-tabela { 
        flex-grow: 1; font-size: 6.9vh; color: #333; font-weight: 700; 
        white-space: nowrap; overflow: hidden; text-overflow: ellipsis; 
        line-height: 1.1; min-width: 0; 
    }
    
    /* CAIXA VERMELHA - FIXA E CENTRALIZADA */
    .preco-box-tabela { 
        background-color: #d32f2f; width: 16vw; height: 8.5vh; flex-shrink: 0; 
        border-radius: 1vh; display: flex; align-items: center; justify-content: center; 
        padding: 0 1vw; box-shadow: 0 3px 6px rgba(0,0,0,0.2); margin-left: 1vw; 
    }
    .moeda-tab { font-size: 3.2vh; color: #ffc107; font-weight: bold; margin-right: 0.5vw; margin-bottom: 1.5vh; }
    .valor-tab { font-size: 8vh; font-weight: 900; color: #ffffff; line-height: 1; display: flex; align-items: baseline; }
    .centavos { font-size: 0.6em; margin-left: 0.1vw; }
    .un-tab { font-size: 2.5vh; color: #ffc107; font-weight: 600; margin-left: 0.5vw; margin-bottom: 1.5vh; }

    /* DIREITA (DESTAQUE) */
    #coluna-destaque { width: 33%; height: 100%; }
    .card-destaque { width: 100%; height: 100%; background: #d32f2f; border-radius: 20px; border: 6px solid #ffc107; display: flex; flex-direction: column; overflow: hidden; position: relative; box-shadow: 0 10px 20px rgba(0,0,0,0.3); }
    .topo-destaque { height: 12%; background: #8e0000; color: #ffc107; display: flex; align-items: center; justify-content: center; font-size: 3.5vh; font-weight: 900; text-transform: uppercase; letter-spacing: 1px; }
    .area-foto-destaque { height: 48%; width: 100%; padding: 20px; display: flex; align-items: center; justify-content: center; background: radial-gradient(circle, #ffCDD2 0%, #ffffff 100%); }
    .foto-destaque { max-width: 90%; max-height: 90%; object-fit: contain; filter: drop-shadow(0 10px 10px rgba(0,0,0,0.3)); }
    .info-destaque { height: 40%; background: #d32f2f; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 10px; color: white; }
    .nome-destaque { font-size: 4vh; font-weight: 900; text-align: center; margin-bottom: 10px; line-height: 1.1; text-transform: uppercase; text-shadow: 1px 1px 3px rgba(0,0,0,0.3); }
    .preco-container-destaque { display: flex; align-items: flex-start; justify-content: center; line-height: 1; }
    .rs-destaque { font-size: 5vh; color: #ffc107; font-weight: bold; margin-right: 5px; margin-top: 10px; }
    .valor-destaque { font-size: 13vh; color: #ffffff; font-weight: 900; letter-spacing: -2px; text-shadow: 3px 3px 6px rgba(0,0,0,0.4); display: flex; align-items: baseline; }
    .un-destaque { font-size: 3vh; color: #ffc107; font-weight: bold; align-self: flex-end; margin-bottom: 20px; margin-left: 5px; }

    /* CAMADA VÍDEO & MENSAGEM */
    #video-container { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: black; z-index: 99999; display: none; align-items: center; justify-content: center; }
    video { width: 100%; height: 100%; object-fit: contain; background: black; }
    #status-msg { position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: rgba(0,0,0,0.8); color: white; padding: 20px 40px; border-radius: 10px; font-size: 24px; z-index: 200000; text-align: center; display: none; }
    .paginacao { position: absolute; bottom: 1vh; left: 3vw; font-size: 2.5vh; color: #999; font-weight: bold; display: none; }
</style>
</head>
<body>

    <div id="status-msg">A iniciar sistema...</div>

    <div id="ofertas-container">
        <img id="img-logo-topo" class="logo-tv" src="">
        <header><h1>Ofertas do Dia</h1></header>
        <div id="layout-principal">
            <div id="coluna-lista"></div>
            <div id="coluna-destaque">
                <div class="card-destaque" id="painel-destaque">
                    <div class="topo-destaque">Super Oferta</div>
                    <div class="area-foto-destaque"><img id="img-d" src="" class="foto-destaque"></div>
                    <div class="info-destaque">
                        <div id="nome-d" class="nome-destaque">...</div>
                        <div class="preco-container-destaque">
                            <span class="rs-destaque">R$</span>
                            <span id="preco-d" class="valor-destaque">...</span>
                            <span id="un-d" class="un-destaque">/un</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="paginacao" id="texto-paginacao"></div>
    </div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>

    <script>
        /* ================= CONFIGURAÇÕES ================= */
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php'; 
        var LOJA_ID = 2; // UID Padrão caso não passe na URL
        var CATEGORIA_ALVO = ""; 

        var ITENS_POR_PAGINA = 7; 
        var TEMPO_POR_PAGINA = 8000; 
        var LOOPS_PARA_COMERCIAL = 3; 
        var TEMPO_ATUALIZACAO_API = 60000; 
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
        /* ================================================= */

        var listaProdutos = [], listaDestaques = [], listaVideos = [];
        var idxProd = 0, idxDest = 0, idxVideo = 0, contadorLoops = 0;
        var timerOfertas = null, monitorTravamento = null;

        // Função que separa os centavos
        function formatarMoedaHTML(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            let formatado = isNaN(v) ? "0,00" : v.toFixed(2).replace('.', ',');
            let partes = formatado.split(',');
            return partes[0] + ',<span class="centavos">' + partes[1] + '</span>';
        }

        function baixarDados() {
            let a = new URLSearchParams(window.location.search);
            let b = a.get('uid') || LOJA_ID;
            let c = a.get('categoria') || CATEGORIA_ALVO;
            let d = a.get('filial') || "";
            
            fetch(API_URL + '?uid=' + b + '&t=' + Date.now())
            .then(e => {
                if (!e.ok) throw new Error("Erro HTTP");
                return e.json();
            })
            .then(e => {
                let f = [];
                if (e.itens) {
                    f = e.itens;
                    let g = document.getElementById('img-logo-topo');
                    if (e.meta && e.meta.logo) {
                        let h = e.meta.logo.replace('http://', 'https://');
                        g.src = h;
                        g.style.display = 'block';
                    } else {
                        g.style.display = 'none';
                    }
                } else if (Array.isArray(e)) {
                    f = e;
                }
                
                listaVideos = f.filter(g => g.is_video == 1 || (g.imagem && g.imagem.match(/\.(mp4|webm|ogg)$/i)));
                let h = f.filter(g => g.is_video != 1 && !(g.imagem && g.imagem.match(/\.(mp4|webm|ogg)$/i)));
                
                let i = c.trim().toLowerCase();
                let j = d.trim().toLowerCase();
                
                listaProdutos = h.filter(g => {
                    let k = g.categoria ? g.categoria.trim().toLowerCase() : "";
                    let l = g.nome_filial ? g.nome_filial.trim().toLowerCase() : (g.filial ? g.filial.trim().toLowerCase() : "");
                    return (i === "" || k === i) && (j === "" || l === j);
                });
                
                listaDestaques = listaProdutos.filter(g => g.destaque == 1);
                if (listaDestaques.length === 0) listaDestaques = listaProdutos;
                
                if (listaProdutos.length === 0 && listaVideos.length === 0) {
                    document.getElementById('status-msg').style.display = 'block';
                    document.getElementById('status-msg').innerHTML = c !== "" ? "Sem produtos na categoria:<br><b style='color:#ffc107'>" + c + "</b>" : "Aguardando conteúdo...";
                } else {
                    document.getElementById('status-msg').style.display = 'none';
                    if (!timerOfertas) rodarOfertas();
                }
            })
            .catch(e => {
                console.log(e);
                if (listaProdutos.length === 0) {
                    document.getElementById('status-msg').style.display = 'block';
                    document.getElementById('status-msg').innerText = "Erro ao conectar.";
                }
            });
        }

        function rodarOfertas() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('ofertas-container').style.opacity = '1';
            document.getElementById('player').pause();
            clearInterval(monitorTravamento);
            
            if (listaProdutos.length === 0) {
                if (listaVideos.length > 0) {
                    rodarVideo();
                } else {
                    timerOfertas = setTimeout(baixarDados, 3000);
                }
                return;
            }
            
            if (idxProd >= listaProdutos.length) {
                idxProd = 0;
                contadorLoops++;
                if (contadorLoops >= LOOPS_PARA_COMERCIAL && listaVideos.length > 0) {
                    contadorLoops = 0;
                    clearTimeout(timerOfertas);
                    rodarVideo();
                    return;
                }
            }
            
            let a = document.getElementById('coluna-lista');
            a.innerHTML = '';
            let b = listaProdutos.slice(idxProd, idxProd + ITENS_POR_PAGINA);
            
            b.forEach(c => {
                let pUnidade = c.unidade || 'un';
                let precoFormatado = formatarMoedaHTML(c.preco);
                
                let htmlLinha = '<div class="linha-produto">' +
                                '<div class="nome-tabela">' + c.produto + '</div>' +
                                '<div class="preco-box-tabela">' +
                                '<span class="moeda-tab">R$</span>' +
                                '<span class="valor-tab">' + precoFormatado + '</span>' +
                                '<span class="un-tab">/' + pUnidade + '</span>' +
                                '</div></div>';
                                
                a.insertAdjacentHTML('beforeend', htmlLinha);
            });
            
            while (a.children.length < ITENS_POR_PAGINA) {
                a.insertAdjacentHTML('beforeend', '<div class="linha-vazia"></div>');
            }
            
            let c_pag = Math.ceil((idxProd + 1) / ITENS_POR_PAGINA);
            let d_tot = Math.ceil(listaProdutos.length / ITENS_POR_PAGINA);
            document.getElementById('texto-paginacao').innerText = 'Página ' + c_pag + '/' + d_tot;
            
            if (listaDestaques.length > 0) {
                let e = listaDestaques[idxDest % listaDestaques.length];
                let f = e.imagem || placeholder;
                f = f.replace('http://', 'https://');
                
                let g = document.getElementById('painel-destaque');
                g.style.opacity = 0.5;
                
                setTimeout(() => {
                    document.getElementById('img-d').src = f;
                    document.getElementById('nome-d').innerText = e.produto;
                    document.getElementById('preco-d').innerHTML = formatarMoedaHTML(e.preco);
                    document.getElementById('un-d').innerText = '/' + (e.unidade || 'un');
                    g.style.opacity = 1;
                }, 200);
                idxDest++;
            }
            
            idxProd += ITENS_POR_PAGINA;
            timerOfertas = setTimeout(rodarOfertas, TEMPO_POR_PAGINA);
        }

        function rodarVideo() {
            let a = listaVideos[idxVideo % listaVideos.length];
            let b = document.getElementById('player');
            
            document.getElementById('ofertas-container').style.opacity = '0';
            document.getElementById('video-container').style.display = 'flex';
            
            let c = a.imagem.replace('http://', 'https://');
            b.src = c;
            b.loop = false;
            b.currentTime = 0;
            b.muted = false;
            
            let d = b.play();
            if (d !== undefined) {
                d.catch(e => {
                    b.muted = true; 
                    b.play();
                });
            }
            
            monitorTravamento = setTimeout(() => {
                if (b.readyState < 2) {
                    encerrarComercial();
                }
            }, 8000);
            
            b.onended = function() { clearTimeout(monitorTravamento); encerrarComercial(); };
            b.onerror = function() { clearTimeout(monitorTravamento); encerrarComercial(); };
        }

        function encerrarComercial() {
            let a = document.getElementById('player');
            a.pause();
            a.removeAttribute('src');
            a.load();
            idxVideo++;
            rodarOfertas();
        }

        window.onload = function() {
            baixarDados();
            setInterval(baixarDados, TEMPO_ATUALIZACAO_API);
        };
    </script>
</body>
</html>