<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>OFERTAS DO DIA</title>

<style>
body{
    margin:0;
    font-family: Arial Black, Arial, sans-serif;
    background:#ffe600;
    overflow:hidden;
}

.topo{
    background:#d90000;
    color:#fff;
    text-align:center;
    padding:25px;
    font-size:55px;
    font-weight:900;
    letter-spacing:4px;
}

.categoria-titulo{
    text-align:center;
    font-size:40px;
    background:#000;
    color:#ffe600;
    padding:15px;
}

.carrossel-container{
    overflow:hidden;
    width:100%;
}

.carrossel{
    display:flex;
    gap:30px;
    padding:40px;
    transition: transform 1s linear;
}

.card{
    min-width:300px;
    background:#fff;
    border-radius:15px;
    border:5px solid #d90000;
    box-shadow:0 8px 20px rgba(0,0,0,0.4);
    text-align:center;
}

.card img{
    width:100%;
    height:220px;
    object-fit:contain;
}

.nome{
    font-size:22px;
    padding:10px;
    font-weight:bold;
    min-height:60px;
}

.preco-box{
    background:#d90000;
    color:#fff;
    padding:20px;
}

.preco{
    font-size:45px;
    font-weight:900;
}

.unidade{
    font-size:20px;
}
</style>
</head>
<body>

<div class="topo">🔥 OFERTAS IMPERDÍVEIS 🔥</div>
<div class="categoria-titulo" id="categoriaNome">Carregando...</div>

<div class="carrossel-container">
    <div class="carrossel" id="carrossel"></div>
</div>

<script>

const categoriaNome = document.getElementById("categoriaNome");
const carrossel = document.getElementById("carrossel");

let categorias = {};
let listaCategorias = [];
let categoriaIndex = 0;
let scrollPos = 0;

fetch("https://mgaplay.com.br/tab/destaque-mercado.php")
.then(res => res.json())
.then(dados => {

    dados.itens.forEach(item => {

        if(!item.produto || item.preco == "0") return;

        if(!categorias[item.categoria]){
            categorias[item.categoria] = [];
        }

        categorias[item.categoria].push(item);
    });

    listaCategorias = Object.keys(categorias);

    mostrarCategoria();
    setInterval(trocarCategoria, 15000); // troca a cada 15s
});

function mostrarCategoria(){

    const categoriaAtual = listaCategorias[categoriaIndex];
    categoriaNome.innerText = categoriaAtual.toUpperCase();

    carrossel.innerHTML = "";
    scrollPos = 0;

    categorias[categoriaAtual].forEach(item => {

        const precoFormatado = parseFloat(item.preco)
            .toFixed(2)
            .replace(".", ",");

        const card = document.createElement("div");
        card.className = "card";

        card.innerHTML = `
            <img src="${item.imagem || 'https://via.placeholder.com/300x200?text=Sem+Imagem'}">
            <div class="nome">${item.produto}</div>
            <div class="preco-box">
                <div class="preco">R$ ${precoFormatado}</div>
                <div class="unidade">por ${item.unidade}</div>
            </div>
        `;

        carrossel.appendChild(card);
    });

    iniciarScroll();
}

function iniciarScroll(){
    setInterval(() => {
        scrollPos += 2;
        carrossel.style.transform = `translateX(-${scrollPos}px)`;

        if(scrollPos > carrossel.scrollWidth - window.innerWidth){
            scrollPos = 0;
        }

    }, 20);
}

function trocarCategoria(){
    categoriaIndex++;
    if(categoriaIndex >= listaCategorias.length){
        categoriaIndex = 0;
    }
    mostrarCategoria();
}

</script>

</body>
</html>