<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>OFERTAS DO DIA</title>

<style>
body{
    margin:0;
    font-family: Arial Black, Arial, sans-serif;
    background:#ffe600;
}

.topo{
    background:#d90000;
    color:#fff;
    text-align:center;
    padding:25px;
    font-size:55px;
    font-weight:900;
    text-transform:uppercase;
    letter-spacing:4px;
}

.grid{
    display:grid;
    grid-template-columns: repeat(auto-fill,minmax(280px,1fr));
    gap:30px;
    padding:40px;
}

.card{
    background:#fff;
    border-radius:15px;
    box-shadow:0 8px 20px rgba(0,0,0,0.4);
    overflow:hidden;
    transition:0.3s;
    text-align:center;
    border:5px solid #d90000;
}

.card:hover{
    transform:scale(1.06);
}

.card img{
    width:100%;
    height:220px;
    object-fit:contain;
    background:#fff;
}

.nome{
    font-size:22px;
    padding:12px;
    font-weight:bold;
    min-height:70px;
}

.preco-box{
    background:#d90000;
    color:#fff;
    padding:20px;
}

.preco{
    font-size:45px;
    font-weight:900;
}

.unidade{
    font-size:20px;
}
.loading{
    text-align:center;
    font-size:30px;
    padding:50px;
    font-weight:bold;
}
</style>
</head>
<body>

<div class="topo">🔥 OFERTAS IMPERDÍVEIS 🔥</div>

<div id="produtos" class="grid">
    <div class="loading">Carregando ofertas...</div>
</div>

<script>

const container = document.getElementById("produtos");

fetch("https://mgaplay.com.br/tab/destaque-mercado.php?uid=22")
.then(response => response.json())
.then(dados => {

    container.innerHTML = "";

    dados.itens.forEach(item => {

        if(!item.produto || item.preco == "0") return;

        const precoFormatado = parseFloat(item.preco)
            .toFixed(2)
            .replace(".", ",");

        const card = document.createElement("div");
        card.className = "card";

        card.innerHTML = `
            <img src="${item.imagem || 'https://via.placeholder.com/300x200?text=Sem+Imagem'}">
            <div class="nome">${item.produto}</div>
            <div class="preco-box">
                <div class="preco">R$ ${precoFormatado}</div>
                <div class="unidade">por ${item.unidade}</div>
            </div>
        `;

        container.appendChild(card);
    });

})
.catch(error => {
    container.innerHTML = "Erro ao carregar ofertas!";
    console.error("Erro:", error);
});

</script>

</body>
</html>