<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>MGA TV - 7 Itens (Box Vermelho Seguro)</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap" rel="stylesheet">
<style>
/* CSS ATUALIZADO COM BOX VERMELHO E CENTAVOS PEQUENOS */
*{box-sizing:border-box;margin:0;padding:0}
body,html{width:100%;height:100%;overflow:hidden;background-color:#000;font-family:'Roboto',Arial,sans-serif}
#ofertas-container{position:absolute;top:0;left:0;width:100%;height:100%;background:#fff;z-index:10;display:flex;flex-direction:column;transition:opacity .5s}
.logo-tv{position:absolute;top:1vh;right:2vw;height:12vh;width:auto;z-index:50;filter:drop-shadow(0 2px 5px rgba(0,0,0,.5));display:none;background:#fff;padding:5px;border-radius:10px}
header{height:14vh;background:#d32f2f;color:#fff;display:flex;align-items:center;padding:0 3vw;box-shadow:0 5px 15px rgba(0,0,0,.3)}
header h1{font-size:6vh;margin:0;flex-grow:1;text-transform:uppercase;font-weight:900;letter-spacing:2px;margin-right:15vw}
#layout-principal{display:flex;width:100%;height:86vh;padding:1.5vh 2vw;gap:2vw}
#coluna-lista{width:65%;height:100%;display:flex;flex-direction:column;gap:.8vh}

/* Lista */
.linha-produto{background:#fff9c4;flex:1;border-radius:1vh;display:flex;align-items:center;justify-content:space-between;padding:0 1vw 0 1.5vw;box-shadow:0 .2vh .4vh rgba(0,0,0,.1);border-left:1vh solid #d32f2f;overflow:hidden}
.linha-vazia{background:transparent!important;border:none!important;box-shadow:none!important;flex:1}
.nome-tabela{flex-grow:1;font-size:6.9vh;color:#333;font-weight:700;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;line-height:1.1;min-width:0}

/* Box Vermelho Fixo */
.preco-box-tabela{background-color:#d32f2f;width:16vw;height:8.5vh;flex-shrink:0;border-radius:1vh;display:flex;align-items:center;justify-content:center;padding:0 1vw;box-shadow:0 3px 6px rgba(0,0,0,.2);margin-left:1vw}
.moeda-tab{font-size:3vh;color:#ffc107;font-weight:700;margin-right:.5vw}
.valor-tab{font-size:6.5vh;font-weight:900;color:#fff;line-height:1;display:flex;align-items:baseline}
.centavos{font-size:.6em;margin-left:.1vw}
.un-tab{font-size:2vh;color:#ffc107;font-weight:600;margin-left:.5vw}

/* Destaque */
#coluna-destaque{width:33%;height:100%}
.card-destaque{width:100%;height:100%;background:#d32f2f;border-radius:20px;border:6px solid #ffc107;display:flex;flex-direction:column;overflow:hidden;position:relative;box-shadow:0 10px 20px rgba(0,0,0,.3)}
.topo-destaque{height:12%;background:#8e0000;color:#ffc107;display:flex;align-items:center;justify-content:center;font-size:3.5vh;font-weight:900;text-transform:uppercase;letter-spacing:1px}
.area-foto-destaque{height:48%;width:100%;padding:20px;display:flex;align-items:center;justify-content:center;background:radial-gradient(circle,#ffCDD2 0%,#fff 100%)}
.foto-destaque{max-width:90%;max-height:90%;object-fit:contain;filter:drop-shadow(0 10px 10px rgba(0,0,0,.3))}
.info-destaque{height:40%;background:#d32f2f;display:flex;flex-direction:column;justify-content:center;align-items:center;padding:10px;color:#fff}
.nome-destaque{font-size:4vh;font-weight:900;text-align:center;margin-bottom:10px;line-height:1.1;text-transform:uppercase;text-shadow:1px 1px 3px rgba(0,0,0,.3)}

/* Preço do Destaque */
.preco-container-destaque{display:flex;align-items:baseline;justify-content:center;line-height:1}
.rs-destaque{font-size:5vh;color:#ffc107;font-weight:700;margin-right:5px}
.valor-destaque{font-size:12vh;color:#fff;font-weight:900;letter-spacing:-2px;text-shadow:3px 3px 6px rgba(0,0,0,.4);display:flex;align-items:baseline}
.un-destaque{font-size:3vh;color:#ffc107;font-weight:700;align-self:flex-end;margin-left:5px}

/* Outros */
#video-container{position:fixed;top:0;left:0;width:100%;height:100%;background:#000;z-index:99999;display:none;align-items:center;justify-content:center}
video{width:100%;height:100%;object-fit:contain;background:#000}
#status-msg{position:fixed;top:50%;left:50%;transform:translate(-50%,-50%);background:rgba(0,0,0,.8);color:#fff;padding:20px 40px;border-radius:10px;font-size:24px;z-index:200000;text-align:center}

/* PAGINAÇÃO OCULTA */
.paginacao{display:none!important}
</style>
</head>
<body>

<div id="status-msg">Carregando Sistema...</div>
<div id="ofertas-container">
    <img id="img-logo-topo" class="logo-tv" src="">
    <header><h1>Ofertas do Dia</h1></header>
    <div id="layout-principal">
        <div id="coluna-lista"></div>
        <div id="coluna-destaque">
            <div class="card-destaque" id="painel-destaque">
                <div class="topo-destaque">Super Oferta</div>
                <div class="area-foto-destaque"><img id="img-d" src="" class="foto-destaque"></div>
                <div class="info-destaque">
                    <div id="nome-d" class="nome-destaque">...</div>
                    <div class="preco-container-destaque">
                        <span class="rs-destaque">R$</span>
                        <span id="preco-d" class="valor-destaque">...</span>
                        <span id="un-d" class="un-destaque">/un</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="paginacao" id="texto-paginacao"></div>
</div>
<div id="video-container"><video id="player" playsinline preload="auto"></video></div>


</body>
</html>