<?php
// buscador.php - VERSÃO DEEP SEARCH (Scraping)
header('Content-Type: application/json');
// Desativa exibição de erros na tela para não sujar o JSON
error_reporting(0);

// Pega o termo via GET
$termo = $_GET['termo'] ?? '';

if (!$termo) { 
    echo json_encode([]); 
    exit; 
}

// Monta a URL simulando busca avançada (PNG + Transparente)
$query = urlencode($termo . " png");
// tbs=ic:trans = Transparente
// ift:png = Tipo de arquivo PNG
$url = "https://www.google.com/search?q={$query}&tbm=isch&tbs=ic:trans,ift:png&hl=pt-BR&gl=br";

// Inicia o CURL simulando um navegador Chrome real
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
// User Agent moderno para o Google não bloquear
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
$html = curl_exec($ch);
curl_close($ch);

$imagens = [];

if ($html) {
    // CORREÇÃO: Troquei os símbolos '¥' por barras invertidas '\' reais
    // Busca URLs que terminam com .png dentro do código fonte do Google
    preg_match_all('/"(https?:\/\/[^"]+?\.png)"/', $html, $matchesJson);

    if (!empty($matchesJson[1])) {
        foreach ($matchesJson[1] as $img) {
            // Decodifica a URL (tira as barras invertidas do JSON original)
            $urlLimpa = json_decode('"' . $img . '"');
            if ($urlLimpa) {
                $imagens[] = $urlLimpa;
            }
        }
    }
}

// Filtra resultados ruins
$resultadosFinais = [];
foreach (array_unique($imagens) as $img) {
    // Ignora imagens codificadas em base64 (muito pequenas)
    if (strpos($img, 'base64') !== false) continue;
    // Ignora imagens hospedadas no próprio Google (miniaturas de baixa qualidade)
    if (strpos($img, 'gstatic.com') !== false) continue;
    // Ignora favicons
    if (strpos($img, 'favicon') !== false) continue;

    $resultadosFinais[] = $img;
    
    // Limita a 30 resultados para não pesar
    if (count($resultadosFinais) >= 30) break;
}

// Retorna o array simples: ["url1", "url2", "url3"]
echo json_encode(array_values($resultadosFinais));
?>