<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Oferta Premium MGA - 1080x1920 (Vertical Ajustado)</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    /* --- RESET --- */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100vw; 
        height: 100vh;
        overflow: hidden;
        background: #0f0f0f; 
        background: radial-gradient(circle at 50% 40%, #2a2a2a 0%, #000000 100%);
        font-family: 'Montserrat', Arial, sans-serif;
    }

    /* --- CONTAINER PRINCIPAL --- */
    #tela-unica {
        width: 100%; height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0; /* Remove padding geral para usar espaço total */
    }

    .produto-container {
        width: 100%; height: 100%;
        display: flex;
        flex-direction: column; 
        align-items: center;
        justify-content: space-between;
    }

    /* --- ÁREA DA IMAGEM (60% da altura) --- */
    .area-img-top {
        width: 100%; 
        height: 60%; /* Aumentado para dar destaque à imagem */
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 5%; /* Respiro interno */
    }
    
    .area-img-top img {
        max-width: 90%;
        max-height: 90%;
        width: auto; height: auto;
        object-fit: contain;
        filter: drop-shadow(0px 25px 40px rgba(0,0,0,0.8));
        transform: scale(1.0);
    }

    /* --- ÁREA DE INFORMAÇÕES (40% da altura) --- */
    .area-info-bottom {
        width: 100%; 
        height: 40%; 
        display: flex;
        flex-direction: column;
        justify-content: flex-start; /* Começa logo abaixo da imagem */
        align-items: center;
        text-align: center;
        padding-top: 1vh;
    }

    /* NOME DO PRODUTO */
    .nome-prod-texto {
        font-size: 8vw; /* Levemente reduzido para elegância */
        font-weight: 900; 
        color: #ffffff; 
        line-height: 1.1;
        text-transform: uppercase;
        margin-bottom: 1vh;
        padding: 0 15px;
        width: 95%; /* Garante que não encoste na borda */
        
        display: -webkit-box;
        -webkit-line-clamp: 2; /* Máximo 2 linhas para não empurrar o preço */
        -webkit-box-orient: vertical;
        overflow: hidden;
        
        text-shadow: 0px 5px 15px rgba(0,0,0,0.8);
    }

    /* CLUSTER DE PREÇO */
    .preco-container {
        display: flex;
        flex-direction: row;
        align-items: flex-start; /* Alinha tudo pelo topo */
        justify-content: center;
        width: 100%; /* Ocupa largura total */
        position: relative;
    }

    /* R$ */
    .simbolo-moeda {
        font-size: 7vw; 
        color: #ffc107; 
        font-weight: 700;
        margin-top: 3vw; 
        margin-right: 2vw;
    }

    /* VALOR NUMÉRICO */
    .valor-gigante {
        font-family: 'Anton', sans-serif;
        /* Reduzido de 45vw para 38vw para garantir que caiba com a unidade */
        font-size: 38vw; 
        color: #ffffff;
        letter-spacing: -0.02em;
        line-height: 1;
        text-shadow: 0px 10px 30px rgba(0,0,0,0.9);
        white-space: nowrap; /* Impede quebra de linha no preço */
    }

    /* UNIDADE */
    .unidade-medida {
        font-size: 6vw;
        color: #ffc107;
        font-weight: 700;
        align-self: flex-end; /* Fica na base do número */
        margin-bottom: 5vw; /* Ajuste vertical */
        margin-left: 2vw;
        white-space: nowrap;
    }

    .loading-msg {
        color: rgba(255,255,255,0.4);
        font-size: 5vw;
        margin-top: 40vh;
    }

    #status-dot { position: fixed; bottom: 10px; right: 10px; width: 15px; height: 15px; border-radius: 50%; background: red; z-index: 9999; opacity: 0.5; }
</style>
</head>
<body>

    <div id="tela-unica">
        <div id="container-produto" style="width:100%; height:100%;">
            <div class="loading-msg">Carregando ofertas...</div>
        </div>
    </div>

    <div id="status-dot"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var CATEGORIA_FILTRO = ''; 
        var TEMPO_TROCA = 8000; 
        
        var listaGlobal = [];
        var indiceGlobal = 0;
        var erroCont = 0;

        function setStatus(cor) { var dot = document.getElementById('status-dot'); if(dot) dot.style.background = cor; }

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            var url = API_URL + '?t=' + new Date().getTime();
            if (CATEGORIA_FILTRO !== '') url += '&categoria=' + encodeURIComponent(CATEGORIA_FILTRO);
            
            xhr.open("GET", url, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (Object.prototype.toString.call(dados) !== '[object Array]') dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                setStatus('lime');
                                if (indiceGlobal === 0) renderizar();
                            } else { setStatus('yellow'); }
                        } catch (e) { setStatus('orange'); }
                    } else {
                        setStatus('red'); erroCont++;
                        if(erroCont > 2 && API_URL.indexOf('https') === 0) { API_URL = API_URL.replace('https', 'http'); erroCont = 0; }
                    }
                }
            };
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('container-produto');
            if (!container) return;
            
            if (listaGlobal.length === 0) { buscarDados(); return; }

            var atual = indiceGlobal % listaGlobal.length;
            var item = listaGlobal[atual];
            
            // Tratamento de preço
            var precoShow = item.preco;
            var unidadeShow = item.unidade || 'un';

            // Tratamento de imagem
            var imgShow = 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png'; 
            if (item.imagem && item.imagem.length > 10) imgShow = item.imagem;
            
            var nomeProd = item.produto || "Oferta Especial";

            // HTML Ajustado
            var html = '';
            html += '<div class="produto-container">';
            
            // TOPO (IMAGEM - Maior área)
            html += '  <div class="area-img-top">';
            html += '    <img src="' + imgShow + '" onerror="this.src=\'https://cdn-icons-png.flaticon.com/512/3143/3143643.png\'">';
            html += '  </div>';
            
            // BASE (INFO - Texto ajustado)
            html += '  <div class="area-info-bottom">';
            html += '    <div class="nome-prod-texto">' + nomeProd + '</div>';
            
            html += '    <div class="preco-container">';
            html += '       <div class="simbolo-moeda">R$</div>';
            html += '       <div class="valor-gigante">' + precoShow + '</div>';
            html += '       <div class="unidade-medida">/' + unidadeShow + '</div>';
            html += '    </div>';
            
            html += '  </div>'; 
            html += '</div>';

            // Efeito Fade
            container.style.opacity = 0;
            setTimeout(function(){
                container.innerHTML = html;
                container.style.opacity = 1;
            }, 200);
            
            indiceGlobal++;
        }

        document.getElementById('container-produto').style.transition = "opacity 0.5s ease";

        window.onload = function() {
            buscarDados();
            setInterval(function() { if(listaGlobal.length > 0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>