<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Ofertas Premium (Com Modo Offline)</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    /* RESET */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background: #111; 
        background: radial-gradient(circle, #333 0%, #000 100%);
        font-family: 'Montserrat', Arial, sans-serif;
        overflow: hidden;
    }

    /* --- TOPO --- */
    #topo {
        position: absolute; top: 0; left: 0; width: 100%; height: 15vh;
        background-color: rgba(255,193,7, 0.1); 
        border-bottom: 0.5vh solid #ffc107;
        text-align: center;
        z-index: 100;
        box-shadow: 0 1vh 4vh rgba(0,0,0,0.8);
        display: flex; align-items: center; justify-content: center;
    }
    #topo h1 {
        font-family: 'Anton', Arial, sans-serif;
        font-size: 8vh; 
        color: #ffc107; 
        line-height: 1; 
        text-transform: uppercase; margin: 0;
        text-shadow: 0.4vh 0.4vh 1vh #000;
        letter-spacing: 0.5vw;
    }

    /* --- ÁREA DOS PRODUTOS --- */
    #lista-produtos {
        position: absolute; top: 15vh; left: 0; width: 100%; height: 85vh;
        padding: 2vh 1vw; 
        display: flex; 
        justify-content: space-between; 
    }

    /* --- CARD INDIVIDUAL --- */
    .cartao {
        width: 32.5%; height: 100%; 
        background: #222; 
        border-radius: 2vh;
        border: 0.3vh solid #444; 
        position: relative; 
        box-shadow: 0 2vh 5vh rgba(0,0,0,0.8);
        overflow: hidden; 
        display: flex; flex-direction: column;
    }

    /* FAIXA CATEGORIA */
    .faixa-cat {
        background: #ffc107; color: #000; width: 100%; text-align: center;
        padding: 0.5vh 0; font-weight: 900; font-size: 2.5vh; 
        text-transform: uppercase;
        box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.5);
        z-index: 20; flex-shrink: 0; 
    }

    /* ÁREA DA IMAGEM */
    .area-img {
        width: 100%; flex-grow: 1; 
        position: relative;
        display: flex; align-items: center; justify-content: center;
        padding: 1vh; overflow: hidden;
    }
    .area-img img {
        max-height: 100%; max-width: 95%;
        width: auto; height: auto;
        object-fit: contain; 
        filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.6));
    }

    /* NOME DO PRODUTO */
    .nome-prod-box {
        width: 100%; min-height: 15%; 
        display: flex; align-items: center; justify-content: center;
        z-index: 50; padding: 0 1vw;
        background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.8)); 
        flex-shrink: 0;
    }
    .nome-prod-texto {
        text-align: center;
        font-size: 3.5vh; 
        font-weight: 700; color: #fff; 
        text-transform: uppercase; line-height: 1.1;
        text-shadow: 0.3vh 0.3vh 0.5vh rgba(0,0,0,1);
    }

    /* ÁREA DE PREÇO */
    .area-preco {
        width: 100%; height: 30%; 
        background: linear-gradient(to bottom, #2a2a2a 0%, #1a1a1a 100%);
        border-top: 0.2vh solid #444;
        text-align: center; z-index: 20;
        display: flex; align-items: center; justify-content: center;
        flex-shrink: 0; 
    }
    
    .preco-wrapper {
        display: flex; align-items: flex-start; justify-content: center; line-height: 1;
    }

    .rs {
        font-size: 4vh; color: #ffc107; font-weight: bold;
        margin-top: 1vh; margin-right: 0.5vw;
    }
    
    .valor-grande {
        font-family: 'Anton', sans-serif;
        font-size: 14vh; color: #fff; 
        letter-spacing: -0.5vh;
    }
    
    .unidade {
        font-size: 2.5vh; color: #999; font-weight: bold;
        align-self: flex-end; margin-bottom: 2vh; margin-left: 0.5vw;
        text-transform: lowercase;
    }

    /* Debug Dot */
    #status-dot { position: fixed; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }

</style>
</head>
<body>

    <div id="topo">
        <h1 id="titulo-texto">OFERTAS ESPECIAIS</h1>
    </div>

    <div id="lista-produtos">
        <h2 style="text-align:center; color:#555; width:100%; margin-top:20vh; font-size:4vh;">Carregando...</h2>
    </div>

    <div id="status-dot" title="Verde: Online | Azul: Cache Offline | Vermelho: Erro"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var CATEGORIA_FILTRO = ''; 
        var TEMPO_TROCA = 10000;
        var ITENS_POR_PAGINA = 3; 
        
        var listaGlobal = [];
        var indiceGlobal = 0;
        var erroCont = 0;

        function setStatus(cor) { var dot = document.getElementById('status-dot'); if(dot) dot.style.background = cor; }

        // --- FUNÇÕES DE MODO OFFLINE ---
        function salvarCache(dados) {
            try {
                localStorage.setItem('mga_premium_cache', JSON.stringify(dados));
            } catch (e) { console.log("Erro ao salvar cache"); }
        }

        function carregarCache() {
            try {
                var cache = localStorage.getItem('mga_premium_cache');
                if (cache) {
                    var dados = JSON.parse(cache);
                    if (dados.length > 0) {
                        listaGlobal = dados;
                        setStatus('blue'); // Azul = Modo Offline
                        if (indiceGlobal === 0) renderizar();
                        return true;
                    }
                }
            } catch (e) { console.log("Erro ao ler cache"); }
            return false;
        }
        // -------------------------------

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            var url = API_URL + '?t=' + new Date().getTime();
            if (CATEGORIA_FILTRO !== '') url += '&categoria=' + encodeURIComponent(CATEGORIA_FILTRO);
            
            xhr.open("GET", url, true);
            xhr.timeout = 5000; // Timeout de 5 segundos

            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (Object.prototype.toString.call(dados) !== '[object Array]') dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                salvarCache(dados); // SALVA O CACHE
                                setStatus('lime'); // Verde = Online
                                erroCont = 0;
                                if (indiceGlobal === 0) renderizar();
                            } else { 
                                if(listaGlobal.length === 0) carregarCache();
                                setStatus('yellow'); 
                            }
                        } catch (e) { 
                            if(listaGlobal.length === 0) carregarCache();
                            setStatus('orange'); 
                        }
                    } else {
                        // Erro de conexão
                        console.log("Sem conexão. Tentando cache...");
                        if(listaGlobal.length === 0) {
                            if(!carregarCache()) setStatus('red'); 
                        } else {
                            setStatus('blue'); // Mantém o cache atual
                        }
                        
                        erroCont++;
                        if(erroCont > 2 && API_URL.indexOf('https') === 0) { API_URL = API_URL.replace('https', 'http'); erroCont = 0; }
                    }
                }
            };
            
            // Se demorar muito, usa o cache
            xhr.ontimeout = function () {
                if(listaGlobal.length === 0) carregarCache();
                setStatus('blue');
            };
            
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('lista-produtos');
            if (!container) return;
            container.innerHTML = ''; 

            if (listaGlobal.length === 0) { buscarDados(); return; }

            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var atual = (indiceGlobal + i) % listaGlobal.length;
                var item = listaGlobal[atual];
                
                var precoShow = item.preco;
                var imgShow = 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png';
                if (item.imagem && item.imagem.length > 10) imgShow = item.imagem;

                var tituloCat = item.categoria || 'OFERTA';
                if (CATEGORIA_FILTRO !== '') {
                    var h1 = document.getElementById('titulo-texto');
                    if(h1) h1.innerHTML = 'OFERTAS - ' + CATEGORIA_FILTRO;
                }

                var nomeProd = item.produto || "Produto";

                var html = '';
                html += '<div class="cartao">';
                html += '  <div class="faixa-cat">' + tituloCat + '</div>';
                
                html += '  <div class="area-img">';
                html += '    <img src="' + imgShow + '" onerror="this.style.display=\'none\'">';
                html += '  </div>';
                
                html += '  <div class="nome-prod-box">';
                html += '    <div class="nome-prod-texto">' + nomeProd + '</div>';
                html += '  </div>';
                
                html += '  <div class="area-preco">';
                html += '    <div class="preco-wrapper">';
                html += '      <span class="rs">R$</span>';
                html += '      <span class="valor-grande">' + precoShow + '</span>';
                html += '      <span class="unidade">/' + (item.unidade || 'un') + '</span>';
                html += '    </div>';
                html += '  </div>';
                html += '</div>';

                container.innerHTML += html;
            }
            indiceGlobal += ITENS_POR_PAGINA;
        }

        window.onload = function() {
            carregarCache(); // Tenta carregar imediatamente
            buscarDados();   // Tenta buscar atualizações
            setInterval(function() { if(listaGlobal.length > 0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>