<?php
// teste-download.php
// RODE ESTE ARQUIVO NO NAVEGADOR PARA TESTAR A GRAVAÇÃO

ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h2>🕵️ Diagnóstico de Download de Imagem</h2>";

// 1. Verifica a pasta
$pasta = "uploads/";
if (!is_dir($pasta)) {
    die("<div style='color:red'>❌ ERRO CRÍTICO: A pasta <b>'$pasta'</b> não existe. Crie ela dentro da pasta admin.</div>");
}

// 2. Verifica permissão de escrita
if (!is_writable($pasta)) {
    echo "<div style='color:red'>❌ ERRO DE PERMISSÃO: O PHP não pode escrever na pasta <b>'$pasta'</b>.</div>";
    echo "SOLUÇÃO: Use seu FTP ou cPanel e mude as permissões da pasta 'uploads' para <b>777</b>.<br><br>";
    echo "Permissão atual: " . substr(sprintf('%o', fileperms($pasta)), -4);
} else {
    echo "<div style='color:green'>✅ Permissão OK: A pasta '$pasta' aceita gravações.</div>";
}

echo "<hr>";

// 3. Tenta baixar uma imagem de teste (Logo do Google)
$urlTeste = "https://www.google.com/images/branding/googlelogo/2x/googlelogo_color_272x92dp.png";
echo "🔄 Tentando baixar imagem de teste: $urlTeste <br>";

$ch = curl_init($urlTeste);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
$dados = curl_exec($ch);
$erro = curl_error($ch);
$info = curl_getinfo($ch);
curl_close($ch);

if ($dados) {
    echo "✅ Download realizado (Tamanho: " . strlen($dados) . " bytes)<br>";
    
    // Tenta salvar
    $destino = $pasta . "teste_google.png";
    if (file_put_contents($destino, $dados)) {
        echo "<div style='color:green; font-weight:bold; font-size:1.2em'>✅ SUCESSO TOTAL!</div>";
        echo "A imagem foi salva em: <b>$destino</b><br>";
        echo "Tente acessar: <a href='$destino' target='_blank'>Clique aqui para ver a imagem</a>";
    } else {
        echo "<div style='color:red'>❌ FALHA AO SALVAR: O download funcionou, mas o comando file_put_contents falhou. Verifique espaço em disco ou permissões novamente.</div>";
    }

} else {
    echo "<div style='color:red'>❌ FALHA NO DOWNLOAD (CURL): $erro</div>";
    echo "Código HTTP: " . $info['http_code'];
}
?>