<?php
require 'lock.php';
require 'config.php';

// --- FUNÇÃO PARA CONVERTER PREÇO (1.200,50 -> 1200.50) ---
function limparDinheiro($valor) {
    $valor = preg_replace('/[^0-9,.]/', '', $valor);
    if(strpos($valor, ',') !== false) {
        $valor = str_replace('.', '', $valor); 
        $valor = str_replace(',', '.', $valor); 
    }
    return (float)$valor;
}

// --- EXPORTAR ---
if (isset($_GET['exportar'])) {
    $filename = "produtos_" . date('Y-m-d') . ".csv";
    
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=' . $filename);

    $output = fopen('php://output', 'w');
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF)); // BOM para acentos

    fputcsv($output, ['ID', 'Produto', 'Preco', 'Unidade', 'Categoria', 'Filial_ID', 'Ativo', 'Destaque', 'Imagem'], ';');

    $stmt = $pdo->prepare("SELECT id, produto, preco, unidade, categoria, filial_id, ativo, destaque, imagem FROM ofertas WHERE usuario_id = ?");
    $stmt->execute([$meu_id]);
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $row['preco'] = number_format($row['preco'], 2, ',', '');
        fputcsv($output, $row, ';');
    }
    fclose($output);
    exit;
}

// --- IMPORTAR (CORRIGIDO PARA EVITAR DUPLICIDADE) ---
if (isset($_FILES['arquivo_excel'])) {
    $file = $_FILES['arquivo_excel']['tmp_name'];
    
    if (!file_exists($file)) {
        header("Location: painel.php?msg=erro_arquivo"); exit;
    }

    $handle = fopen($file, "r");
    fgetcsv($handle, 2000, ";"); // Pula cabeçalho

    $atualizados = 0;
    $inseridos = 0;
    
    while (($data = fgetcsv($handle, 2000, ";")) !== FALSE) {
        if (count($data) < 3) continue;

        // Mapeia colunas
        $id_csv     = isset($data[0]) ? trim($data[0]) : '';
        $produto    = isset($data[1]) ? (mb_check_encoding($data[1], 'UTF-8') ? $data[1] : utf8_encode($data[1])) : '';
        $preco      = isset($data[2]) ? limparDinheiro($data[2]) : 0.00;
        $unidade    = isset($data[3]) ? trim($data[3]) : 'un';
        $categoria  = isset($data[4]) ? (mb_check_encoding($data[4], 'UTF-8') ? $data[4] : utf8_encode($data[4])) : 'Geral';
        $filial_id  = (isset($data[5]) && is_numeric($data[5])) ? $data[5] : null;
        $ativo      = isset($data[6]) ? (int)$data[6] : 1;
        $destaque   = isset($data[7]) ? (int)$data[7] : 0;
        $imagem     = isset($data[8]) ? trim($data[8]) : '';

        // --- LÓGICA ANTI-DUPLICIDADE ---
        $id_para_atualizar = null;

        // 1. Tenta achar pelo ID (Se o CSV tiver ID)
        if (!empty($id_csv) && is_numeric($id_csv)) {
            $check = $pdo->prepare("SELECT id FROM ofertas WHERE id = ? AND usuario_id = ?");
            $check->execute([$id_csv, $meu_id]);
            if ($row = $check->fetch()) {
                $id_para_atualizar = $row['id'];
            }
        }

        // 2. Se não achou pelo ID, tenta achar pelo NOME DO PRODUTO (Para evitar duplicar)
        if (!$id_para_atualizar && !empty($produto)) {
            $check = $pdo->prepare("SELECT id FROM ofertas WHERE produto = ? AND usuario_id = ?");
            $check->execute([$produto, $meu_id]);
            if ($row = $check->fetch()) {
                $id_para_atualizar = $row['id'];
            }
        }

        if ($id_para_atualizar) {
            // ATUALIZA (Update)
            $stmt = $pdo->prepare("UPDATE ofertas SET produto=?, preco=?, unidade=?, categoria=?, filial_id=?, ativo=?, destaque=?, imagem=? WHERE id=? AND usuario_id=?");
            $stmt->execute([$produto, $preco, $unidade, $categoria, $filial_id, $ativo, $destaque, $imagem, $id_para_atualizar, $meu_id]);
            $atualizados++;
        } else {
            // INSERE NOVO (Insert)
            $stmt = $pdo->prepare("INSERT INTO ofertas (produto, preco, unidade, categoria, filial_id, ativo, destaque, imagem, usuario_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$produto, $preco, $unidade, $categoria, $filial_id, $ativo, $destaque, $imagem, $meu_id]);
            $inseridos++;
        }
    }
    
    fclose($handle);
    header("Location: painel.php?msg=import_ok&novos=$inseridos&editados=$atualizados");
    exit;
}
?>