<?php
require 'config.php';

echo "<h2>Atualizando para Painel Administrativo...</h2>";

try {
    // 1. Adiciona coluna 'ativo' (Padrão 0 = Pendente de aprovação)
    $pdo->exec("ALTER TABLE usuarios ADD COLUMN ativo TINYINT DEFAULT 0");
    echo "<p>✅ Coluna 'ativo' criada.</p>";

    // 2. Adiciona coluna 'is_admin' (Padrão 0 = Usuário comum)
    $pdo->exec("ALTER TABLE usuarios ADD COLUMN is_admin TINYINT DEFAULT 0");
    echo "<p>✅ Coluna 'is_admin' criada.</p>";

    // 3. Transforma o usuário 'admin' (ou o ID 1) em SUPER ADMIN e ATIVO
    // IMPORTANTE: Se seu usuário não for 'admin', mude o nome abaixo
    $stmt = $pdo->prepare("UPDATE usuarios SET ativo = 1, is_admin = 1 WHERE usuario = 'admin' OR id = 1");
    $stmt->execute();
    
    echo "<p>✅ Usuário ID 1 ou 'admin' agora é o SUPER CHEFE.</p>";
    echo "<hr><h3>Tudo pronto! Apague este arquivo e teste o sistema.</h3>";

} catch (PDOException $e) {
    echo "<p style='color:red'>Erro (pode ser que as colunas já existam): " . $e->getMessage() . "</p>";
}
?>