<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Oferta Vertical MGA</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body, html { width: 100vw; height: 100vh; overflow: hidden; background: radial-gradient(circle at 50% 40%, #2a2a2a 0%, #000000 100%); font-family: 'Montserrat', 'Arial Black', sans-serif; }
    
    #tela-unica { width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; }
    .produto-container { width: 100%; height: 100%; display: flex; flex-direction: column; align-items: center; justify-content: space-between; transition: opacity 0.5s ease; }
    
    .area-img-top { width: 100%; height: 60%; display: flex; align-items: center; justify-content: center; padding: 5%; }
    .area-img-top img { max-width: 90%; max-height: 90%; object-fit: contain; filter: drop-shadow(0px 25px 40px rgba(0,0,0,0.8)); }

    .area-info-bottom { width: 100%; height: 40%; display: flex; flex-direction: column; justify-content: flex-start; align-items: center; text-align: center; padding-top: 1vh; }
    .nome-prod-texto { font-size: 8vw; font-weight: 900; color: #ffffff; line-height: 1.1; text-transform: uppercase; margin-bottom: 1vh; padding: 0 15px; width: 95%; text-shadow: 0px 5px 15px rgba(0,0,0,0.8); }
    
    .preco-container { display: flex; flex-direction: row; align-items: flex-start; justify-content: center; width: 100%; }
    .simbolo-moeda { font-size: 7vw; color: #ffc107; font-weight: 700; margin-top: 3vw; margin-right: 2vw; }
    .valor-gigante { font-family: 'Anton', 'Arial Black', sans-serif; font-size: 35vw; color: #ffffff; letter-spacing: -0.02em; line-height: 1; text-shadow: 0px 10px 30px rgba(0,0,0,0.9); }
    .unidade-medida { font-size: 6vw; color: #ffc107; font-weight: 700; align-self: flex-end; margin-bottom: 5vw; margin-left: 2vw; }

    #status-dot { position: fixed; bottom: 10px; right: 10px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }
</style>
</head>
<body>
    <div id="tela-unica">
        <div id="container-produto" style="width:100%; height:100%;"><h1 style="color:white;margin-top:40vh;text-align:center;">Carregando...</h1></div>
    </div>
    <div id="status-dot"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var TEMPO_TROCA = 8000; 
        var listaGlobal = [];
        var indiceGlobal = 0;

        function setStatus(cor) { document.getElementById('status-dot').style.background = cor; }

        function formatarMoeda(valor) {
            if (!valor) return "0,00";
            let v = valor.toString().replace(',', '.');
            let floatV = parseFloat(v);
            if (isNaN(floatV)) return valor; 
            return floatV.toFixed(2).replace('.', ',');
        }

        function salvarCache(dados) { try { localStorage.setItem('mga_vone_cache', JSON.stringify(dados)); } catch(e){} }
        function carregarCache() {
            try {
                var c = localStorage.getItem('mga_vone_cache');
                if(c) {
                    var d = JSON.parse(c);
                    if(d.length > 0) { listaGlobal = d; setStatus('blue'); if(indiceGlobal===0) renderizar(); return true; }
                }
            } catch(e){}
            return false;
        }

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", API_URL + '?t=' + new Date().getTime(), true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (!Array.isArray(dados)) dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                salvarCache(dados);
                                setStatus('lime');
                                if (indiceGlobal === 0) renderizar();
                            } else { if(listaGlobal.length==0) carregarCache(); }
                        } catch (e) { if(listaGlobal.length==0) carregarCache(); }
                    } else { if(listaGlobal.length==0) carregarCache(); }
                }
            };
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('container-produto');
            if (listaGlobal.length === 0) return;
            var atual = indiceGlobal % listaGlobal.length;
            var item = listaGlobal[atual];
            
            var html = `
            <div class="produto-container">
                <div class="area-img-top">
                    <img src="${(item.imagem && item.imagem.length > 5) ? item.imagem : 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png'}" onerror="this.style.opacity=0">
                </div>
                <div class="area-info-bottom">
                    <div class="nome-prod-texto">${item.produto}</div>
                    <div class="preco-container">
                       <div class="simbolo-moeda">R$</div>
                       <div class="valor-gigante">${formatarMoeda(item.preco)}</div>
                       <div class="unidade-medida">/${item.unidade || 'un'}</div>
                    </div>
                </div>
            </div>`;
            
            container.style.opacity = 0;
            setTimeout(function(){ container.innerHTML = html; container.style.opacity = 1; }, 200);
            indiceGlobal++;
        }

        window.onload = function() {
            carregarCache();
            buscarDados();
            setInterval(function(){ if(listaGlobal.length>0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>