<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Oferta Premium MGA - 1920x1080</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&family=Roboto:wght@400;700&display=swap" rel="stylesheet">
<style type="text/css">
    /* --- RESET --- */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100vw; 
        height: 100vh;
        overflow: hidden;
        background: #0f0f0f; 
        background: radial-gradient(circle at 30% 50%, #2a2a2a 0%, #000000 100%);
        /* Fonte segura para Android */
        font-family: 'Montserrat', 'Roboto', 'Arial', sans-serif;
    }

    /* --- CONTAINER PRINCIPAL --- */
    #tela-unica {
        width: 100%; height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 4vh; 
    }

    .produto-container {
        width: 100%; height: 100%;
        display: flex; 
        flex-direction: row;
        align-items: center;
        justify-content: space-between;
    }

    /* --- ESQUERDA: IMAGEM --- */
    .area-img-left {
        width: 45%; 
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }
    
    .area-img-left img {
        max-width: 100%;
        max-height: 90%;
        object-fit: contain;
        filter: drop-shadow(15px 30px 40px rgba(0,0,0,0.8));
    }

    /* --- DIREITA: INFORMAÇÕES --- */
    .area-info-right {
        width: 55%; 
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center; 
        padding-left: 4vw;
        text-align: left;
    }

    .nome-prod-texto {
        font-size: 7vh; 
        font-weight: 900; 
        color: #ffffff; 
        line-height: 1.1;
        text-transform: uppercase;
        margin-bottom: 2vh;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-shadow: 4px 4px 15px rgba(0,0,0,0.8);
    }

    .preco-container {
        display: flex;
        align-items: flex-start; 
        line-height: 1;
        margin-top: 1vh;
    }

    .simbolo-moeda {
        font-size: 6vh; 
        color: #ffc107; 
        font-weight: 700;
        margin-top: 3vh; 
        margin-right: 1vw;
    }

    .valor-gigante {
        font-family: 'Anton', 'Arial Black', sans-serif;
        font-size: 32vh; 
        color: #ffffff;
        letter-spacing: -0.05em;
        text-shadow: 8px 8px 30px rgba(0,0,0,0.9);
    }

    .unidade-medida {
        font-size: 5vh;
        color: #ffc107;
        font-weight: 700;
        align-self: flex-end; 
        margin-bottom: 5vh;
        margin-left: 1vw;
    }

    .loading-msg {
        color: rgba(255,255,255,0.4);
        font-size: 5vh;
        text-align: center;
        width: 100%;
    }

    #status-dot { position: fixed; bottom: 10px; right: 10px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; opacity: 0.8; }
</style>
</head>
<body>

    <div id="tela-unica">
        <div id="container-produto" style="width:100%; height:100%;">
            <div class="loading-msg">Carregando ofertas...</div>
        </div>
    </div>

    <div id="status-dot" title="Status Conexão"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var TEMPO_TROCA = 8000; 
        var TEMPO_ATUALIZACAO = 60000;
        
        var listaGlobal = [];
        var indiceGlobal = 0;

        function setStatus(cor) { var dot = document.getElementById('status-dot'); if(dot) dot.style.background = cor; }

        // --- FORMATAÇÃO DE PREÇO (R$ 0,00) ---
        function formatarMoeda(valor) {
            if (!valor) return "0,00";
            let v = String(valor).replace(',', '.');
            let floatV = parseFloat(v);
            if (isNaN(floatV)) return valor; 
            return floatV.toFixed(2).replace('.', ',');
        }

        // --- CACHE OFFLINE ---
        function salvarCache(dados) {
            try { localStorage.setItem('mga_one_bk_cache', JSON.stringify(dados)); } catch(e){}
        }

        function carregarCache() {
            try {
                var c = localStorage.getItem('mga_one_bk_cache');
                if(c) {
                    var d = JSON.parse(c);
                    if(d.length > 0) {
                        listaGlobal = d;
                        setStatus('blue'); // Azul = Cache
                        if(indiceGlobal === 0) renderizar();
                        return true;
                    }
                }
            } catch(e){}
            return false;
        }

        // --- BUSCA DADOS ---
        function buscarDados() {
            var xhr = new XMLHttpRequest();
            var url = API_URL + '?t=' + new Date().getTime();
            
            xhr.open("GET", url, true);
            xhr.timeout = 5000;

            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (!Array.isArray(dados)) dados = [dados];
                            
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                salvarCache(dados);
                                setStatus('lime'); // Verde = Online
                                if (indiceGlobal === 0) renderizar();
                            } else {
                                if(listaGlobal.length === 0) carregarCache();
                            }
                        } catch (e) {
                            if(listaGlobal.length === 0) carregarCache();
                        }
                    } else {
                        // Erro de rede
                        if(listaGlobal.length === 0) {
                             if(!carregarCache()) setStatus('red');
                        } else {
                             setStatus('blue'); // Mantém cache anterior
                        }
                    }
                }
            };
            xhr.send();
        }

        // --- RENDERIZAR ---
        function renderizar() {
            var container = document.getElementById('container-produto');
            if (!container) return;
            
            if (listaGlobal.length === 0) { buscarDados(); return; }

            var atual = indiceGlobal % listaGlobal.length;
            var item = listaGlobal[atual];
            
            // Tratamento de Imagem
            var imgShow = 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png'; 
            if (item.imagem && item.imagem.length > 10) imgShow = item.imagem;

            var nomeProd = item.produto || "Oferta Especial";
            var unidade = item.unidade || 'un';

            // HTML
            var html = '';
            html += '<div class="produto-container">';
            
            // Esquerda
            html += '  <div class="area-img-left">';
            html += '    <img src="' + imgShow + '" onerror="this.src=\'https://cdn-icons-png.flaticon.com/512/3143/3143643.png\'">';
            html += '  </div>';
            
            // Direita
            html += '  <div class="area-info-right">';
            html += '    <div class="nome-prod-texto">' + nomeProd + '</div>';
            
            html += '    <div class="preco-container">';
            html += '       <div class="simbolo-moeda">R$</div>';
            // Usa a função formatarMoeda aqui
            html += '       <div class="valor-gigante">' + formatarMoeda(item.preco) + '</div>';
            html += '       <div class="unidade-medida">/' + unidade + '</div>';
            html += '    </div>';
            
            html += '  </div>'; 
            html += '</div>';

            // Efeito de Fade
            container.style.opacity = 0;
            setTimeout(function(){
                container.innerHTML = html;
                container.style.opacity = 1;
            }, 200);
            
            indiceGlobal++;
        }

        // Transição CSS
        document.getElementById('container-produto').style.transition = "opacity 0.5s ease";

        window.onload = function() {
            carregarCache(); // Primeiro tenta cache
            buscarDados();   // Depois busca rede
            
            setInterval(function() { 
                if(listaGlobal.length > 0) renderizar(); 
            }, TEMPO_TROCA);
            
            setInterval(buscarDados, TEMPO_ATUALIZACAO);
        };
    </script>
</body>
</html>