<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Lista Clean + Destaque</title>
<style>
    /* RESET */
    * { box-sizing: border-box; }
    body, html { margin: 0; padding: 0; width: 100%; height: 100%; overflow: hidden; background-color: #f4f4f4; font-family: 'Roboto', 'Arial', sans-serif; }

    header { height: 13vh; background: #d32f2f; color: white; display: flex; align-items: center; padding: 0 3vw; box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.2); }
    header h1 { font-size: 6vh; margin: 0; flex-grow: 1; text-transform: uppercase; font-weight: 800; }
    
    #layout-principal { display: flex; width: 100%; height: 87vh; padding: 1.5vh 2vw; gap: 2vw; }
    
    #coluna-lista { width: 65%; height: 100%; display: flex; flex-direction: column; gap: 1.2vh; }
    
    /* GARANTE 5 ITENS */
    .linha-produto { 
        background: white; 
        flex: 1; /* Estica igual */
        max-height: calc(100% / 5 - 1vh); /* Limite altura */
        border-radius: 1.5vh; 
        display: flex; align-items: center; 
        padding: 0 1.5vw; 
        box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.05); 
        border-left: 1.5vw solid #d32f2f; 
        animation: entradaSuave 0.5s ease-out; 
    }
    
    .linha-vazia { background: transparent !important; box-shadow: none !important; border: none !important; flex: 1; }
    
    .img-tabela { height: 85%; aspect-ratio: 1/1; object-fit: contain; margin-right: 1.5vw; background: #fff; border-radius: 1vh; border: 1px solid #eee; }
    .nome-tabela { flex-grow: 1; font-size: 4vh; color: #333; font-weight: 700; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .preco-box-tabela { text-align: right; min-width: 18vw; }
    .moeda-tab { font-size: 2.5vh; color: #666; font-weight: bold; vertical-align: top; }
    .valor-tab { font-size: 6vh; font-weight: 800; color: #d32f2f; line-height: 1; }
    .un-tab { font-size: 2vh; color: #888; font-weight: 600; display: block;}

    #coluna-destaque { width: 33%; height: 100%; }
    .card-destaque { width: 100%; height: 100%; background: white; border-radius: 3vh; box-shadow: 0 2vh 5vh rgba(0,0,0,0.2); border: 0.5vh solid #d32f2f; display: flex; flex-direction: column; overflow: hidden; position: relative; }
    .topo-destaque { height: 10%; background: #d32f2f; color: #fff; display: flex; align-items: center; justify-content: center; font-size: 3vh; font-weight: 900; text-transform: uppercase; }
    .area-foto-destaque { height: 50%; width: 100%; padding: 2vh; display: flex; align-items: center; justify-content: center; background: radial-gradient(circle, #fff 0%, #eee 100%); }
    .foto-destaque { max-width: 95%; max-height: 95%; object-fit: contain; filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.3)); }
    .info-destaque { height: 40%; background: #fff; padding: 1vh; display: flex; flex-direction: column; justify-content: center; align-items: center; border-top: 1px solid #eee; }
    .nome-destaque { font-size: 4vh; color: #333; font-weight: 800; margin-bottom: 1vh; text-transform: uppercase; text-align: center; line-height: 1.1; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
    .valor-destaque { font-size: 11vh; color: #d32f2f; font-weight: 900; letter-spacing: -0.3vh; }
    .un-destaque { font-size: 2.5vh; color: #999; font-weight: bold; align-self: flex-end; margin-bottom: 1.5vh; margin-left: 0.5vw; }

    #indicador-rede { position: fixed; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }
    .paginacao { position: absolute; bottom: 1vh; left: 3vw; font-size: 2vh; color: #999; }
    @keyframes entradaSuave { from { opacity: 0; transform: translateX(-2vw); } to { opacity: 1; transform: translateX(0); } }
</style>
</head>
<body>
    <header><h1>Ofertas do Dia</h1></header>
    <div id="layout-principal">
        <div id="coluna-lista"></div>
        <div id="coluna-destaque">
            <div class="card-destaque" id="painel-destaque" style="opacity:0; transition:opacity 0.5s;">
                <div class="topo-destaque">Super Oferta</div>
                <div class="area-foto-destaque"><img id="img-d" src="" class="foto-destaque"></div>
                <div class="info-destaque">
                    <div id="nome-d" class="nome-destaque">...</div>
                    <div style="display:flex; align-items:flex-start;">
                        <span style="font-size:4vh; color:#d32f2f; font-weight:bold; margin-top:1vh; margin-right:5px;">R$</span>
                        <span id="preco-d" class="valor-destaque">...</span>
                        <span id="un-d" class="un-destaque"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="paginacao" id="texto-paginacao"></div>
    <div id="indicador-rede"></div>

    <script>
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php'; 
        var ITENS_POR_LISTA = 5;      
        var TEMPO_PAGINA = 10000;      
        var TEMPO_DESTAQUE = 5000;    
        
        var dadosGlobais = [];
        var listaDestaques = [];
        var paginaAtual = 0;
        var indiceDestaque = 0;
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';

        function setStatus(cor) { document.getElementById('indicador-rede').style.background = cor; }
        
        function formatarMoeda(valor) {
            if (!valor) return "0,00";
            let v = String(valor).replace(',', '.');
            let floatV = parseFloat(v);
            if (isNaN(floatV)) return valor; 
            return floatV.toFixed(2).replace('.', ',');
        }

        function salvarCache(dados) { try { localStorage.setItem('mga_dual_clean_fix', JSON.stringify(dados)); } catch(e){} }
        function carregarCache() {
            try {
                var c = localStorage.getItem('mga_dual_clean_fix');
                if(c) {
                    var d = JSON.parse(c);
                    if(d.length > 0) {
                        processarDados(d);
                        setStatus('blue');
                        return true;
                    }
                }
            } catch(e){}
            return false;
        }

        function baixarDados() {
            var urlParams = new URLSearchParams(window.location.search);
            var uid = urlParams.get('uid') || urlParams.get('loja') || 1;
            var xhr = new XMLHttpRequest();
            xhr.open("GET", API_URL + '?uid=' + uid + '&t=' + new Date().getTime(), true);
            xhr.timeout = 5000;
            xhr.onreadystatechange = function() {
                if(xhr.readyState == 4) {
                    if(xhr.status == 200) {
                        try {
                            var json = JSON.parse(xhr.responseText);
                            if(!Array.isArray(json)) json = [json];
                            if(json.length > 0) {
                                salvarCache(json);
                                processarDados(json);
                                setStatus('lime');
                            } else { if(dadosGlobais.length==0) carregarCache(); }
                        } catch(e) { if(dadosGlobais.length==0) carregarCache(); }
                    } else { if(dadosGlobais.length==0) carregarCache(); }
                }
            };
            xhr.onerror = function() { if(dadosGlobais.length===0) carregarCache(); };
            xhr.send();
        }

        var loopLista, loopDestaque;
        function processarDados(dados) {
            if(JSON.stringify(dados) === JSON.stringify(dadosGlobais)) return;
            dadosGlobais = dados;
            listaDestaques = dadosGlobais.filter(i => i.destaque == 1 || i.destaque == true);
            if(listaDestaques.length === 0) listaDestaques = dadosGlobais; 

            if(!loopLista) {
                atualizarLista();
                loopLista = setInterval(atualizarLista, TEMPO_PAGINA);
                atualizarDestaque();
                loopDestaque = setInterval(atualizarDestaque, TEMPO_DESTAQUE);
            }
        }

        function atualizarLista() {
            var container = document.getElementById('coluna-lista');
            if(dadosGlobais.length === 0) return;
            var totalPags = Math.ceil(dadosGlobais.length / ITENS_POR_LISTA);
            if(paginaAtual >= totalPags) paginaAtual = 0;
            var inicio = paginaAtual * ITENS_POR_LISTA;
            var fatia = dadosGlobais.slice(inicio, inicio + ITENS_POR_LISTA);

            container.innerHTML = '';
            fatia.forEach(item => {
                var img = (item.imagem && item.imagem.length > 5) ? item.imagem : placeholder;
                var html = `
                    <div class="linha-produto">
                        <img src="${img}" class="img-tabela" onerror="this.src='${placeholder}'">
                        <div class="nome-tabela">${item.produto}</div>
                        <div class="preco-box-tabela">
                            <span class="moeda-tab">R$</span>
                            <span class="valor-tab">${formatarMoeda(item.preco)}</span>
                            <span class="un-tab">/${item.unidade || 'un'}</span>
                        </div>
                    </div>`;
                container.innerHTML += html;
            });
            while(container.children.length < ITENS_POR_LISTA) container.innerHTML += '<div class="linha-vazia"></div>';
            document.getElementById('texto-paginacao').innerText = `Pág ${paginaAtual+1}/${totalPags}`;
            paginaAtual++;
        }

        function atualizarDestaque() {
            if(listaDestaques.length === 0) return;
            var painel = document.getElementById('painel-destaque');
            painel.style.opacity = 0;
            setTimeout(() => {
                var index = indiceDestaque % listaDestaques.length;
                var item = listaDestaques[index];
                document.getElementById('img-d').src = (item.imagem && item.imagem.length > 5) ? item.imagem : placeholder;
                document.getElementById('nome-d').innerText = item.produto;
                document.getElementById('preco-d').innerText = formatarMoeda(item.preco);
                document.getElementById('un-d').innerText = '/' + (item.unidade || 'un');
                painel.style.opacity = 1;
                indiceDestaque++;
            }, 500);
        }

        window.onload = function() {
            carregarCache();
            baixarDados();
            setInterval(baixarDados, 60000);
        };
    </script>
</body>
</html>