<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Ofertas MGA</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Roboto:wght@700&display=swap" rel="stylesheet">
<style type="text/css">
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background-color: #b71c1c; 
        background: radial-gradient(circle, #e53935 10%, #b71c1c 90%);
        /* Fonte fallback para Android */
        font-family: 'Roboto', 'Arial', sans-serif;
        overflow: hidden;
    }

    #topo {
        position: absolute; top: 0; left: 0; width: 100%; height: 15%;
        background-color: rgba(0,0,0,0.2);
        border-bottom: 4px solid #ffeb3b;
        text-align: center;
        z-index: 100;
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
    }
    #topo h1 {
        font-family: 'Anton', 'Arial Black', sans-serif;
        font-size: 60px; color: #ffeb3b;
        line-height: 1.4; 
        text-transform: uppercase; margin: 0;
        text-shadow: 4px 4px 0 #000;
        letter-spacing: 3px;
    }

    #lista-produtos {
        position: absolute; top: 15%; left: 0; width: 100%; height: 85%;
        padding: 30px 20px;
    }

    .cartao {
        width: 31%; height: 92%; background: white; margin: 0 1.1%; 
        float: left; border-radius: 20px; border: 5px solid white;
        position: relative; box-shadow: 0 15px 30px rgba(0,0,0,0.5); overflow: hidden; 
    }

    .faixa-cat {
        background: #0d47a1; color: white; width: 100%; text-align: center;
        padding: 6px 0; font-weight: bold; font-size: 18px; text-transform: uppercase;
        position: absolute; top: 0; left: 0; z-index: 20;
        box-shadow: 0 2px 5px rgba(0,0,0,0.3);
    }

    .area-img {
        position: relative; top: 1%; left: 0; width: auto; height: 90%; 
        text-align: center; z-index: 10; background: transparent;
        display: flex; align-items: center; justify-content: center;
    }
    .area-img img {
        max-height: 105%; max-width: auto; width: auto; height: auto;
        object-fit: contain; filter: drop-shadow(0 10px 10px rgba(0,0,0,0.15));
    }

    .nome-prod-box {
        position: absolute; top: 5%; left: 0; width: 100%; height: 18%; 
        display: table; z-index: 50; background: rgba(255,255,255,0.5); padding: 0 5px;
    }
    .nome-prod-texto {
        display: table-cell; vertical-align: middle; text-align: center;
        font-size: 5vh; font-weight: 900; color: #222; line-height: 1.1; text-transform: uppercase;
    }

    .area-preco {
        position: absolute; bottom: 0; left: 0; width: 100%; height: 34%; 
        background-color: #ffeb3b; border-radius: 0 0 15px 15px;
        text-align: center; z-index: 20;
        clip-path: polygon(0 15%, 100% 0, 100% 100%, 0% 100%);
        border-top: 5px solid #fdd835; display: table; 
    }
    
    .preco-container-center { display: table-cell; vertical-align: middle; padding-top: 20px; }

    .rs { display: inline-block; font-size: 35px; color: #b71c1c; font-weight: bold; vertical-align: top; margin-right: 5px; margin-top: 15px; }
    .valor-grande {
        display: inline-block; font-family: 'Anton', 'Arial Black', sans-serif;
        font-size: 110px; color: #d50000; line-height: 1; letter-spacing: -4px;
        text-shadow: 3px 3px 0px white;
    }
    .unidade {
        display: inline-block; font-size: 22px; color: #333; font-weight: bold;
        vertical-align: bottom; margin-left: 5px; margin-bottom: 20px; text-transform: lowercase;
    }

    #status-dot { position: fixed; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }
</style>
</head>
<body>
    <div id="topo"><h1 id="titulo-texto">SUPER OFERTAS</h1></div>
    <div id="lista-produtos"><h2 style="text-align:center; color:white; margin-top:50px;">Carregando...</h2></div>
    <div id="status-dot"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var TEMPO_TROCA = 10000;
        var ITENS_POR_PAGINA = 3;
        var listaGlobal = [];
        var indiceGlobal = 0;

        // Formatação de Moeda
        function formatarMoeda(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            return isNaN(v) ? valor : v.toFixed(2).replace('.', ',');
        }

        // Cache System
        function salvarCache(dados) { try { localStorage.setItem('mga_tv3of_cache', JSON.stringify(dados)); } catch(e){} }
        function carregarCache() {
            try {
                var c = localStorage.getItem('mga_tv3of_cache');
                if(c) {
                    var d = JSON.parse(c);
                    if(d.length > 0) { listaGlobal = d; setStatus('blue'); if(indiceGlobal===0) renderizar(); return true; }
                }
            } catch(e){}
            return false;
        }

        function setStatus(cor) { document.getElementById('status-dot').style.background = cor; }

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            var url = API_URL + '?t=' + new Date().getTime();
            xhr.open("GET", url, true);
            xhr.timeout = 5000;
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (!Array.isArray(dados)) dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                salvarCache(dados);
                                setStatus('lime');
                                if (indiceGlobal === 0) renderizar();
                            } else { if(listaGlobal.length==0) carregarCache(); }
                        } catch (e) { if(listaGlobal.length==0) carregarCache(); }
                    } else { if(listaGlobal.length==0) carregarCache(); }
                }
            };
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('lista-produtos');
            if (listaGlobal.length === 0) return;
            container.innerHTML = ''; 

            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var atual = (indiceGlobal + i) % listaGlobal.length;
                var item = listaGlobal[atual];
                
                var imgShow = (item.imagem && item.imagem.length > 10) ? item.imagem : 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
                var html = `
                <div class="cartao">
                    <div class="faixa-cat">${item.categoria || 'OFERTA'}</div>
                    <div class="area-img"><img src="${imgShow}" onerror="this.style.display='none'"></div>
                    <div class="nome-prod-box"><div class="nome-prod-texto">${item.produto}</div></div>
                    <div class="area-preco">
                        <div class="preco-container-center">
                            <span class="rs">R$</span>
                            <span class="valor-grande">${formatarMoeda(item.preco)}</span>
                            <span class="unidade">/${item.unidade || 'un'}</span>
                        </div>
                    </div>
                </div>`;
                container.innerHTML += html;
            }
            indiceGlobal += ITENS_POR_PAGINA;
        }

        window.onload = function() {
            carregarCache();
            buscarDados();
            setInterval(function() { if(listaGlobal.length > 0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>