<?php
// admin/listar-galeria.php

// 1. Evita que avisos do PHP quebrem o JSON
error_reporting(0);
ini_set('display_errors', 0);

// 2. Define que a saída é JSON
header('Content-Type: application/json; charset=utf-8');

// 3. Inclui configurações (cuidado com espaços em branco neste arquivo)
require 'config.php';

$imagens = [];

// 4. Caminho absoluto para a pasta (Mais seguro)
$diretorio = __DIR__ . '/uploads/'; 
// URL base absoluta (do config.php)
$urlBase = $baseUrlImagens;

try {
    // Verifica se a pasta existe
    if (is_dir($diretorio)) {
        $arquivos = scandir($diretorio);
        
        foreach ($arquivos as $arquivo) {
            if ($arquivo !== '.' && $arquivo !== '..') {
                $caminhoCompleto = $diretorio . $arquivo;
                
                // Verifica se é arquivo mesmo (não pasta)
                if (is_file($caminhoCompleto)) {
                    $ext = strtolower(pathinfo($arquivo, PATHINFO_EXTENSION));
                    
                    // Lista de extensões permitidas
                    if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                        $imagens[] = [
                            'url' => $urlBase . $arquivo,
                            'nome' => $arquivo,
                            'data' => filemtime($caminhoCompleto) // Data para ordenar
                        ];
                    }
                }
            }
        }
        
        // Ordena: Mais recentes primeiro
        usort($imagens, function($a, $b) {
            return $b['data'] - $a['data'];
        });
    }
} catch (Exception $e) {
    // Se der erro, retorna lista vazia para não travar o giro
    echo json_encode([]);
    exit;
}

// Retorna o JSON limpo
echo json_encode($imagens);
?>