<?php
require 'lock.php'; // Sua proteção de senha
require 'config.php';

$mensagem = "";
$tipo_alerta = "";

// PROCESSAR O UPLOAD
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['arquivo_balanca'])) {
    
    $arquivo = $_FILES['arquivo_balanca']['tmp_name'];
    $categoria_selecionada = $_POST['categoria_padrao']; // Ex: Açougue
    
    if (is_uploaded_file($arquivo)) {
        
        $linhas = file($arquivo);
        $importados = 0;
        $atualizados = 0;

        $pdo->beginTransaction();

        try {
            foreach ($linhas as $linha) {
                // IGNORA LINHAS VAZIAS
                if (trim($linha) == '') continue;

                // --- PARSER DO LAYOUT TOLEDO MGV 5/6 ---
                // Baseado no exemplo: 010000001000980000CARNE SUINA PELE...
                
                $depto  = substr($linha, 0, 2);  // 01
                $tipo   = substr($linha, 2, 1);  // 0 (0=Peso, 6=Unidade geralmente)
                $codigo = (int)substr($linha, 3, 6); // 000001 -> 1
                $precoRaw = substr($linha, 9, 6);    // 000980 -> 9.80
                $preco  = number_format((float)$precoRaw / 100, 2, ',', '.'); // Formata para 9,80
                
                // Descrição (Posição 18 em diante, pega 25 caracteres)
                // Usamos mb_convert_encoding pois arquivos de balança geralmente são ANSI/Windows-1252
                $descRaw = substr($linha, 18, 25); 
                $produto = trim(mb_convert_encoding($descRaw, 'UTF-8', 'ISO-8859-1'));

                // Define Unidade baseado no Tipo da balança
                // Geralmente: 0 = Peso (kg), 6 = Unidade (un)
                $unidade = ($tipo == '6' || $tipo == '1') ? 'un' : 'kg';

                // Verifica se já existe esse código no banco
                $stmtCheck = $pdo->prepare("SELECT id FROM ofertas WHERE codigo_balanca = ?");
                $stmtCheck->execute([$codigo]);
                $existe = $stmtCheck->fetch();

                if ($existe) {
                    // ATUALIZA PREÇO E NOME
                    $sql = "UPDATE ofertas SET produto=?, preco=?, unidade=?, categoria=?, ativo=1 WHERE codigo_balanca=?";
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute([$produto, $preco, $unidade, $categoria_selecionada, $codigo]);
                    $atualizados++;
                } else {
                    // INSERE NOVO
                    // Deixamos imagem em branco para você usar o botão "Buscar Web" depois
                    $sql = "INSERT INTO ofertas (produto, preco, unidade, categoria, codigo_balanca, destaque, imagem) VALUES (?, ?, ?, ?, ?, 0, '')";
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute([$produto, $preco, $unidade, $categoria_selecionada, $codigo]);
                    $importados++;
                }
            }
            
            $pdo->commit();
            $mensagem = "Sucesso! $importados novos itens importados e $atualizados preços atualizados.";
            $tipo_alerta = "success";

        } catch (Exception $e) {
            $pdo->rollBack();
            $mensagem = "Erro ao processar: " . $e->getMessage();
            $tipo_alerta = "danger";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Importar Balança</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-dark text-white">
                    <h4 class="mb-0">🔌 Importar Arquivo Toledo/MGV</h4>
                </div>
                <div class="card-body">
                    
                    <?php if($mensagem): ?>
                        <div class="alert alert-<?= $tipo_alerta ?>"><?= $mensagem ?></div>
                    <?php endif; ?>

                    <form method="POST" enctype="multipart/form-data">
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">1. Selecione o Arquivo (itensmgv.txt)</label>
                            <input type="file" name="arquivo_balanca" class="form-control" accept=".txt" required>
                            <div class="form-text">O arquivo gerado pelo MGV 5 ou 6.</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">2. Importar para qual Categoria?</label>
                            <select name="categoria_padrao" class="form-select">
                                <option value="Açougue">Açougue</option>
                                <option value="Padaria">Padaria</option>
                                <option value="Hortifruti">Hortifruti</option>
                                <option value="Frios">Frios e Laticínios</option>
                                <option value="Geral">Geral</option>
                            </select>
                            <div class="form-text">Todos os itens deste arquivo irão para esta categoria.</div>
                        </div>

                        <div class="alert alert-info small">
                            <i class="bi bi-info-circle"></i> 
                            O sistema usará o <strong>Código da Balança</strong> para identificar os produtos. 
                            Se o produto já existir, o preço será atualizado automaticamente.
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">🚀 Processar Importação</button>
                            <a href="painel.php" class="btn btn-secondary">Voltar ao Painel</a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>