<?php
require 'config.php'; // Sua conexão com o banco

echo "<h2>Atualizando Banco de Dados...</h2>";

try {
    // 1. Tenta criar a tabela CATEGORIAS se não existir
    $sql = "CREATE TABLE IF NOT EXISTS categorias (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nome VARCHAR(100) NOT NULL
    )";
    $pdo->exec($sql);
    echo "<p>✅ Tabela 'categorias' verificada.</p>";

    // 2. Tenta criar a tabela FILIAIS se não existir
    $sql = "CREATE TABLE IF NOT EXISTS filiais (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nome VARCHAR(100) NOT NULL
    )";
    $pdo->exec($sql);
    echo "<p>✅ Tabela 'filiais' verificada.</p>";

    // 3. Tenta adicionar a coluna 'ativo' na tabela 'ofertas'
    // Verifica se a coluna já existe antes de tentar adicionar para não dar erro
    $colunaExiste = false;
    $rs = $pdo->query("SHOW COLUMNS FROM ofertas LIKE 'ativo'");
    if ($rs->fetch()) {
        $colunaExiste = true;
        echo "<p>ℹ️ Coluna 'ativo' já existe na tabela ofertas.</p>";
    }

    if (!$colunaExiste) {
        $pdo->exec("ALTER TABLE ofertas ADD COLUMN ativo TINYINT(1) DEFAULT 1");
        echo "<p>✅ Coluna 'ativo' criada com sucesso!</p>";
    }

    // 4. Tenta adicionar a coluna 'filial_id' na tabela 'ofertas'
    $colunaFilialExiste = false;
    $rs = $pdo->query("SHOW COLUMNS FROM ofertas LIKE 'filial_id'");
    if ($rs->fetch()) {
        $colunaFilialExiste = true;
        echo "<p>ℹ️ Coluna 'filial_id' já existe na tabela ofertas.</p>";
    }

    if (!$colunaFilialExiste) {
        $pdo->exec("ALTER TABLE ofertas ADD COLUMN filial_id INT DEFAULT NULL");
        echo "<p>✅ Coluna 'filial_id' criada com sucesso!</p>";
    }

    echo "<h3>Tudo pronto! Apague este arquivo e volte para o <a href='painel.php'>Painel</a>.</h3>";

} catch (PDOException $e) {
    echo "<h3 style='color:red'>Erro ao atualizar: " . $e->getMessage() . "</h3>";
}
?>