<?php
// auth.php - Central de Segurança
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Se não estiver logado, manda pro login
if (!isset($_SESSION['usuario_id'])) {
    header("Location: login.php");
    exit;
}

// Helper para verificar se é Admin
function isAdmin() {
    return isset($_SESSION['usuario_nivel']) && $_SESSION['usuario_nivel'] === 'admin';
}

// Bloqueia acesso a páginas exclusivas de admin
function requireAdmin() {
    if (!isAdmin()) {
        die("<div class='alert alert-danger text-center mt-5'>⛔ Acesso Negado. Apenas Administradores. <a href='index.php'>Voltar</a></div>");
    }
}
?>