<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* clock-get-resource-flip.twig */
class __TwigTemplate_f3238a919ba0b177d768164f76e33cd1a831df06769fd98ebe021b8b9a00ab44 extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 1
        echo "<!doctype html>
<html lang=\"en\">
<head>
    <title>Xibo Open Source Digital Signage</title>
    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />
    <meta name=\"viewport\" content=\"width=";
        // line 6
        echo twig_escape_filter($this->env, ($context["viewPortWidth"] ?? null), "html", null, true);
        echo "\" />
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
    <!-- Copyright 2006-2014 Daniel Garner. Part of the Xibo Open Source Digital Signage Solution. Released under the AGPLv3 or later. -->
    <style type=\"text/css\">
        body {
            margin: 0;
            overflow: hidden;
            font-family: sans-serif, Arial, Verdana, \"Trebuchet MS\";
        }

        h1, h2, h3, h4, p {
            margin-top: 0;
        }
    </style>
    ";
        // line 20
        echo ($context["head"] ?? null);
        echo "
    <style type=\"text/css\">
        .flip-clock-wrapper {
            text-align: center;
            position: relative;
            margin: 0;
        }
    </style>
</head>
<!--[if lt IE 7 ]><body class=\"ie6\"><![endif]-->
<!--[if IE 7 ]><body class=\"ie7\"><![endif]-->
<!--[if IE 8 ]><body class=\"ie8\"><![endif]-->
<!--[if IE 9 ]><body class=\"ie9\"><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--><body><!--<![endif]-->
<div id=\"clock\"></div>
";
        // line 35
        echo ($context["body"] ?? null);
        echo "
</body>
";
        // line 37
        echo ($context["javaScript"] ?? null);
        echo "
<script type=\"text/javascript\">

    function getTimeRemaining(endtime) {
        // for IE and Windows player
        var endtimeFormatted = endtime.replace(/^(.*-[0-9][0-9])( )([0-9][0-9]:.*\$)/, '\$1T\$3');

        var t = Date.parse(endtimeFormatted) - Date.parse(new Date());
        var seconds = Math.floor( (t/1000) % 60 );
        var minutes = Math.floor( (t/1000/60) % 60 );
        var hours = Math.floor( (t/(1000*60*60)) % 24 );
        var days = Math.floor( t/(1000*60*60*24) );
        return {
            'total': t,
            'days': days,
            'hours': hours,
            'minutes': minutes,
            'seconds': seconds
        };
    }

    var clock;
    var offset = \"";
        // line 59
        echo twig_escape_filter($this->env, ($context["offset"] ?? null), "html", null, true);
        echo "\";

    \$(document).ready(function() {
        // Show Seconds: ";
        // line 62
        echo twig_escape_filter($this->env, ($context["showSeconds"] ?? null), "html", null, true);
        echo "
        // Offset: ";
        // line 63
        echo twig_escape_filter($this->env, ($context["offset"] ?? null), "html", null, true);
        echo "
        var options = ";
        // line 64
        echo ($context["options"] ?? null);
        echo ";
        var width = options.previewWidth;
        var height = options.previewHeight;

        if (width == 0 || height == 0) {
            width = \$(window).width();
            height = \$(window).height();
        }

        var clockFace = \"";
        // line 73
        echo twig_escape_filter($this->env, ($context["clockFace"] ?? null), "html", null, true);
        echo "\";
        var showSeconds = ";
        // line 74
        echo twig_escape_filter($this->env, ($context["showSeconds"] ?? null), "html", null, true);
        echo ";
        var clock_width = 460;

        // Flip clock is always the same size
        if (clockFace === \"DailyCounter\")
            clock_width = 620;

        // If we are a clock, then reduce the width to fit without the seconds if appropriate
        if (showSeconds === 0 && (clockFace === \"TwelveHourClock\" || clockFace === 'TwentyFourHourClock'))
            clock_width = 300;

        // Calculate the width ratio between the actual width and the clock_width
        var ratio = width / clock_width;

        // What IE are we?
        if (\$(\"body\").hasClass('ie7') || \$(\"body\").hasClass('ie8')) {
            \$(\"#clock\").css({
                \"width\": clock_width + \"px\",
                \"filter\": \"progid:DXImageTransform.Microsoft.Matrix(M11=\" + ratio + \", M12=0, M21=0, M22=\" + ratio + \", SizingMethod='auto expand'\"
            });
        }
        else {
            \$(\"#clock\").css({
                \"width\": clock_width + \"px\",
                \"transform\": \"scale(\" + ratio + \")\",
                \"transform-origin\": \"0 0\"
            });
        }

        if (clockFace === \"TwelveHourClock\" || clockFace === \"TwentyFourHourClock\") {
            clock = \$('#clock').FlipClock({
                clockFace: '";
        // line 105
        echo twig_escape_filter($this->env, ($context["clockFace"] ?? null), "html", null, true);
        echo "',
                showSeconds: (showSeconds === 1)
            });

            var date = new Date(clock.getTime().time);

            clock.setTime(new Date(date.valueOf() + (offset * 60 * 1000)));
        } else {
            var duration;
            if (isNaN(offset)) {
                duration = getTimeRemaining(offset).total / 1000;
            } else {
                duration = ";
        // line 117
        echo twig_escape_filter($this->env, ($context["duration"] ?? null), "html", null, true);
        echo ";
            }

            clock = \$('#clock').FlipClock(duration, {
                clockFace: '";
        // line 121
        echo twig_escape_filter($this->env, ($context["clockFace"] ?? null), "html", null, true);
        echo "',
                showSeconds: (showSeconds === 1),
                countdown: true
            });
        }
    });
</script>
</html>
";
        // line 129
        echo ($context["controlMeta"] ?? null);
        echo "
";
    }

    public function getTemplateName()
    {
        return "clock-get-resource-flip.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  199 => 129,  188 => 121,  181 => 117,  166 => 105,  132 => 74,  128 => 73,  116 => 64,  112 => 63,  108 => 62,  102 => 59,  77 => 37,  72 => 35,  54 => 20,  37 => 6,  30 => 1,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("", "clock-get-resource-flip.twig", "/home/mgacom/public_html/serraazul/modules/clock-get-resource-flip.twig");
    }
}
