<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* clock-get-resource-analog.twig */
class __TwigTemplate_3f3d00af8066d588aaf6c81d4f72ed30de79f4e6233377edde5366a97417fd7b extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 1
        echo "<!doctype html>
<html lang=\"en\">
<head>
    <title>Xibo Open Source Digital Signage</title>
    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />
    <meta name=\"viewport\" content=\"width=";
        // line 6
        echo twig_escape_filter($this->env, ($context["viewPortWidth"] ?? null), "html", null, true);
        echo "\" />
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
    <!-- Copyright 2006-2014 Daniel Garner. Part of the Xibo Open Source Digital Signage Solution. Released under the AGPLv3 or later. -->
    <style type=\"text/css\">
        body {
            margin: 0;
            overflow: hidden;
            font-family: sans-serif, Arial, Verdana, \"Trebuchet MS\";
        }

        h1, h2, h3, h4, p {
            margin-top: 0;
        }

        .hero-circle {
            margin: 0 auto;
            position: relative;
            background-image: url(data:image/png;base64,";
        // line 23
        echo ($context["clockFace"] ?? null);
        echo ");
        }

        .hero-circle-bg-image {
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .hero-face {
            width: 100%;
            height: 100%;
        }

        .hero-face:after {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 12px;
            height: 12px;
            margin: -6px 0 0 -6px;
            border-radius: 6px;
            content: \"\";
            display: block;
        }

        .light .hero-face:after {
            background: #fff;
        }

        .dark .hero-face:after {
            background: #000;
        }

        .hero-hour {
            width: 0;
            height: 0;
            position: absolute;
            top: 50%;
            left: 50%;
            margin: -4px 0 -4px -25%;
            padding: 4px 0 4px 25%;
            -webkit-transform-origin: 100% 50%;
            -ms-transform-origin: 100% 50%;
            transform-origin: 100% 50%;
            border-radius: 4px 0 0 4px;
        }

        .dark .hero-hour, .dark .hero-minute, .dark .hero-second {
            background: #000;
        }

        .light .hero-hour, .light .hero-minute, .light .hero-second {
            background: #FFF;
        }

        .hero-minute{width:0;height:0;position:absolute;top:50%;left:50%;margin:-40% -3px 0;padding:40% 3px 0;-webkit-transform-origin:50% 100%;-ms-transform-origin:50% 100%;transform-origin:50% 100%;border-radius:3px 3px 0 0;}

        .hero-second{width:0;height:0;position:absolute;top:50%;left:50%;margin:-40% -1px 0 0;padding:40% 1px 0;-webkit-transform-origin:50% 100%;-ms-transform-origin:50% 100%;transform-origin:50% 100%;}
    </style>
    ";
        // line 83
        echo ($context["head"] ?? null);
        echo "
</head>
<body class=\"";
        // line 85
        echo twig_escape_filter($this->env, ($context["clockTheme"] ?? null), "html", null, true);
        echo "\">
<div id=\"clock\" class=\"hero-circle hero-circle-transparent hero-circle-bg-image\">
    <div class=\"hero-face\">
        <div id=\"hour\" class=\"hero-hour\"></div>
        <div id=\"minute\" class=\"hero-minute\"></div>
        <div id=\"second\" class=\"hero-second\"></div>
    </div>
</div>
";
        // line 93
        echo ($context["body"] ?? null);
        echo "
</body>
";
        // line 95
        echo ($context["javaScript"] ?? null);
        echo "
<script type=\"text/javascript\">
    function updateClock(){
        var now = moment().add(";
        // line 98
        echo twig_escape_filter($this->env, ($context["offset"] ?? null), "html", null, true);
        echo ", \"m\"),
                second = now.seconds() * 6,
                minute = now.minutes() * 6 + second / 60,
                hour = ((now.hours() % 12) / 12) * 360 + 90 + minute / 12;

        \$('#hour').css(\"transform\", \"rotate(\" + hour + \"deg)\");
        \$('#minute').css(\"transform\", \"rotate(\" + minute + \"deg)\");
        \$('#second').css(\"transform\", \"rotate(\" + second + \"deg)\");
    }

    \$(document).ready(function() {

        var options = ";
        // line 110
        echo ($context["options"] ?? null);
        echo ";
        var previewWidth = options.previewWidth;
        var previewHeight = options.previewHeight;

        if (previewWidth == 0 || previewHeight == 0)
            var size = Math.min(\$(window).width(), \$(window).height());
        else
            var size = Math.min(previewWidth, previewHeight);

        // Shrink by 2px to get a bit of space to the side.
        size -= 2;

        \$(\".hero-circle\").css({
            width: size + \"px\",
            height: size + \"px\"
        });

        updateClock();
        setInterval(updateClock, 1000);
    });
</script>
</html>
";
        // line 132
        echo ($context["controlMeta"] ?? null);
        echo "
";
    }

    public function getTemplateName()
    {
        return "clock-get-resource-analog.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  187 => 132,  162 => 110,  147 => 98,  141 => 95,  136 => 93,  125 => 85,  120 => 83,  57 => 23,  37 => 6,  30 => 1,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("", "clock-get-resource-analog.twig", "/home/mgatv524/public_html/serraazul/modules/clock-get-resource-analog.twig");
    }
}
