<?php
// api_produtos.php
require 'conexao.php';
header('Content-Type: application/json');

$termo = $_GET['termo'] ?? '';

if (strlen($termo) < 2) {
    echo json_encode([]);
    exit;
}

try {
    // Busca nomes distintos na tabela de ofertas para não repetir
    $sql = "SELECT DISTINCT produto FROM ofertas WHERE produto LIKE ? ORDER BY produto ASC LIMIT 10";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(["%$termo%"]);
    
    // Retorna apenas a coluna 'produto' como um array simples
    echo json_encode($stmt->fetchAll(PDO::FETCH_COLUMN));
} catch (PDOException $e) {
    echo json_encode([]);
}
?>