<?php
require 'conexao.php';
header('Content-Type: application/json');

// Aumenta tempo de execução para downloads lentos
ini_set('max_execution_time', 300); 

$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

// --- 1. LISTAR IMAGENS ---
if ($acao == 'listar') {
    $busca = $_GET['busca'] ?? '';
    $sql = "SELECT * FROM banco_imagens WHERE nome_arquivo LIKE ? ORDER BY id DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(["%$busca%"]);
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
    exit;
}

// --- 2. UPLOAD DE ARQUIVO LOCAL ---
if ($acao == 'upload') {
    if (isset($_FILES['arquivo'])) {
        $ext = strtolower(pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION));
        $permitidos = ['jpg', 'jpeg', 'png', 'webp'];

        if (in_array($ext, $permitidos)) {
            $novoNome = uniqid() . "." . $ext;
            if (!is_dir('uploads')) mkdir('uploads', 0777, true);
            $destino = 'uploads/' . $novoNome;

            if (move_uploaded_file($_FILES['arquivo']['tmp_name'], $destino)) {
                $nomeOriginal = pathinfo($_FILES['arquivo']['name'], PATHINFO_FILENAME);
                $stmt = $pdo->prepare("INSERT INTO banco_imagens (nome_arquivo, caminho) VALUES (?, ?)");
                $stmt->execute([$nomeOriginal, $destino]);
                echo json_encode(['sucesso' => true, 'msg' => 'Imagem salva no banco!']);
            } else {
                echo json_encode(['sucesso' => false, 'msg' => 'Erro ao salvar arquivo.']);
            }
        } else {
            echo json_encode(['sucesso' => false, 'msg' => 'Formato inválido.']);
        }
    }
    exit;
}

// --- 3. EXCLUIR IMAGEM ---
if ($acao == 'excluir') {
    $id = $_POST['id'] ?? '';
    if($id) {
        $stmt = $pdo->prepare("SELECT caminho FROM banco_imagens WHERE id = ?");
        $stmt->execute([$id]);
        $imagem = $stmt->fetch(PDO::FETCH_ASSOC);

        if($imagem) {
            if(file_exists($imagem['caminho'])) unlink($imagem['caminho']);
            $del = $pdo->prepare("DELETE FROM banco_imagens WHERE id = ?");
            $del->execute([$id]);
            echo json_encode(['sucesso' => true, 'msg' => 'Excluído com sucesso.']);
        } else {
            echo json_encode(['sucesso' => false, 'msg' => 'Imagem não encontrada.']);
        }
    }
    exit;
}

// --- 4. SALVAR URL DA WEB (NOVO) ---
if ($acao == 'salvar_url') {
    $url = $_POST['url'] ?? '';
    
    if (filter_var($url, FILTER_VALIDATE_URL)) {
        // Tenta pegar o conteúdo da imagem
        $conteudo = @file_get_contents($url);
        
        if ($conteudo) {
            if (!is_dir('uploads')) mkdir('uploads', 0777, true);
            
            // Gera nome único
            $nomeArquivo = 'bg_web_' . uniqid() . '.jpg';
            $destino = 'uploads/' . $nomeArquivo;
            
            // Salva no disco
            if (file_put_contents($destino, $conteudo)) {
                // Salva no banco
                $stmt = $pdo->prepare("INSERT INTO banco_imagens (nome_arquivo, caminho) VALUES (?, ?)");
                $stmt->execute(['Background Web', $destino]);
                
                echo json_encode(['sucesso' => true, 'msg' => 'Background salvo no seu Banco!', 'caminho' => $destino]);
            } else {
                echo json_encode(['sucesso' => false, 'msg' => 'Erro ao salvar arquivo no disco.']);
            }
        } else {
            echo json_encode(['sucesso' => false, 'msg' => 'Não foi possível baixar a imagem. A URL pode estar protegida.']);
        }
    } else {
        echo json_encode(['sucesso' => false, 'msg' => 'URL inválida.']);
    }
    exit;
}
?>