<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>TV Digital Pro</title>
    <meta http-equiv="refresh" content="1800">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;900&family=Oswald:wght@700&family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
    <style>
        body { margin: 0; overflow: hidden; background: #111; cursor: none; font-family: 'Montserrat', sans-serif; }
        
        #app { width: 100vw; height: 100vh; display: flex; opacity: 0; transition: opacity 0.8s ease; background-size: cover; background-position: center; position: relative; }
        
        /* Layouts */
        .layout-landscape { flex-direction: row; }
        .layout-landscape .sidebar { width: 40%; height: 100%; }
        .layout-landscape .visual { width: 60%; height: 100%; }
        
        .layout-portrait { flex-direction: column-reverse; }
        .layout-portrait .sidebar { width: 100%; height: 40%; text-align: center; }
        .layout-portrait .visual { width: 100%; height: 60%; }

        /* Sidebar e Visual */
        .sidebar { z-index: 2; display: flex; flex-direction: column; justify-content: center; padding: 4vw; box-sizing: border-box; transition: 0.3s; }
        .visual { position: relative; overflow: hidden; width: 100%; height: 100%; }

        /* Elementos Base */
        .prod-title { line-height: 1; margin: 0 0 20px 0; text-shadow: 2px 2px 4px rgba(0,0,0,0.2); }
        .prod-price { display: inline-block; }
        .tag-oferta { display: inline-block; padding: 10px 30px; border-radius: 5px; font-weight: bold; margin-bottom: 20px; text-transform: uppercase; font-size: 1.5rem; }
        
        /* IMAGEM COM POSIÇÃO ABSOLUTA */
        .img-produto { 
            position: absolute; 
            max-width: 85%; max-height: 85%; 
            filter: drop-shadow(0 20px 40px rgba(0,0,0,0.4)); 
            transition: 0.5s; /* Suaviza a troca de posição */
        }
        
        .logo-area { position: absolute; display: flex; align-items: center; justify-content: center; z-index: 10; }
        .extra-text { position: absolute; font-weight: bold; white-space: nowrap; z-index: 5; text-shadow: 2px 2px 4px rgba(0,0,0,0.5); }
        .modo-multiply { mix-blend-mode: multiply; filter: contrast(1.1); }

        /* === TEMPLATES === */
        
        /* CLÁSSICO */
        .tpl-classico .sidebar { background: linear-gradient(135deg, #d32f2f 0%, #b71c1c 100%); color: white; clip-path: polygon(0 0, 100% 0, 90% 100%, 0% 100%); }
        .layout-portrait.tpl-classico .sidebar { clip-path: polygon(0 15%, 100% 0, 100% 100%, 0% 100%); }
        .tpl-classico .tag-oferta { background: #ffeb3b; color: #d32f2f; }
        .tpl-classico .prod-title { font-weight: 900; font-size: 5rem; text-transform: uppercase; }
        .tpl-classico .prod-price { font-weight: 900; font-size: 9rem; background: rgba(0,0,0,0.2); padding: 10px 40px; border-radius: 20px; }

        /* PREMIUM */
        .tpl-premium { font-family: 'Playfair Display', serif; }
        .tpl-premium .sidebar { background: #111; color: #d4af37; border-right: 5px solid #d4af37; }
        .layout-portrait.tpl-premium .sidebar { border-right: none; border-top: 5px solid #d4af37; }
        .tpl-premium .tag-oferta { background: #d4af37; color: #000; letter-spacing: 5px; }
        .tpl-premium .prod-title { font-size: 6rem; font-style: italic; }
        .tpl-premium .prod-price { font-size: 10rem; color: #fff; text-shadow: 0 0 20px #d4af37; }

        /* FRESH */
        .tpl-fresh { font-family: 'Montserrat', sans-serif; }
        .tpl-fresh .sidebar { background: linear-gradient(to bottom, #4caf50, #2e7d32); color: white; border-radius: 0 100px 100px 0; margin-right: -50px; }
        .layout-portrait.tpl-fresh .sidebar { border-radius: 100px 100px 0 0; margin-right: 0; margin-top: -50px; }
        .tpl-fresh .tag-oferta { background: white; color: #2e7d32; border-radius: 50px; }
        .tpl-fresh .prod-title { font-weight: 700; font-size: 5rem; }
        .tpl-fresh .prod-price { font-weight: 800; font-size: 9rem; color: #a5d6a7; }

        /* IMPACTO */
        .tpl-impacto { font-family: 'Oswald', sans-serif; }
        .tpl-impacto .sidebar { background: #ffeb3b; color: #d32f2f; }
        .tpl-impacto .tag-oferta { background: #d32f2f; color: #fff; transform: skew(-10deg); }
        .tpl-impacto .prod-title { font-size: 7rem; line-height: 0.9; text-transform: uppercase; transform: skew(-5deg); }
        .tpl-impacto .prod-price { font-size: 12rem; color: #000; font-weight: 900; letter-spacing: -5px; }
        /* Botão de Renomear (Lápis) - Fica ao lado da Lupa */
.btn-edit-img {
    position: absolute;
    top: 5px;
    left: 35px; /* Ao lado da lupa */
    background: #ffc107; /* Amarelo */
    color: #333;
    border: none;
    border-radius: 4px;
    width: 25px;
    height: 25px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    z-index: 10;
    opacity: 0.8;
    transition: 0.2s;
}
.btn-edit-img:hover { opacity: 1; transform: scale(1.1); }

    </style>
</head>
<body>
<div id="loading" style="color:white; font-size:2em; display:flex; justify-content:center; align-items:center; height:100vh;">Carregando...</div>

<div id="app" style="display:none">
    <div id="sidebar" class="sidebar">
        <div class="tag-oferta">OFERTA ESPECIAL</div>
        <h1 class="prod-title" id="elProduto">Produto</h1>
        <div class="prod-price" id="elPreco">0,00</div>
        <div id="elValidade" style="font-size:1.5rem; margin-top:20px; opacity:0.8"></div>
    </div>
    <div class="visual">
        <div id="elLogo" class="logo-area" style="display:none"><img style="width:100%; height:100%; object-fit:contain"></div>
        <img id="elImg" class="img-produto">
        <div id="elExtra" class="extra-text" style="display:none"></div>
    </div>
</div>

<script>
    const CONFIG = { 
        tempoSlide: 10000, 
        modo: "<?php echo $_GET['modo'] ?? 'landscape'; ?>" 
    };
    const app = document.getElementById('app'); 
    let playlist = []; let index = 0;

    async function carregar() {
        try {
            // Cache Buster para garantir atualização
            const r = await fetch(`api.php?modo=${CONFIG.modo}&t=${Date.now()}`);
            const d = await r.json();
            
            if(d.length > 0) { 
                playlist = d; 
                document.getElementById('loading').style.display = 'none'; 
                app.style.display = 'flex'; 
                
                // Se rodou primeira vez, inicia
                if(!window.rodando) { window.rodando=true; rodar(); }
            } else {
                setTimeout(carregar, 10000); // Tenta de novo se vazio
            }
        } catch(e) { console.error(e); setTimeout(carregar, 5000); }
    }

    function rodar() {
        app.style.opacity = 0; // Fade Out

        setTimeout(() => {
            // Reseta índice se acabou a playlist
            if(index >= playlist.length) index = 0;
            
            const item = playlist[index];
            
            // 1. TEMPLATE
            const tpl = item.template_style || 'classico';
            app.className = `layout-${CONFIG.modo} tpl-${tpl}`;

            // 2. TEXTOS
            document.getElementById('elProduto').innerText = item.produto;
            document.getElementById('elPreco').innerText = "R$ " + parseFloat(item.preco).toFixed(2).replace('.',',');
            
            // 3. IMAGEM (CORREÇÃO DE CENTRALIZAÇÃO AQUI)
            const img = document.getElementById('elImg');
            img.src = item.imagem_url;
            
            if(item.efeito_visual === 'multiply') img.classList.add('modo-multiply'); 
            else img.classList.remove('modo-multiply');
            
            // LÓGICA DE POSIÇÃO
            if(item.img_pos_x && item.img_pos_x !== 'center') { 
                // Posição Manual (Pixels)
                img.style.left = item.img_pos_x; 
                img.style.top = item.img_pos_y; 
                img.style.transform = 'none'; 
            } else { 
                // Posição Automática (Centro)
                img.style.left = '50%'; 
                img.style.top = '50%'; 
                img.style.transform = 'translate(-50%, -50%)'; 
            }

            // 4. LOGO
            const logoDiv = document.getElementById('elLogo');
            if(item.logo_url) {
                logoDiv.querySelector('img').src = item.logo_url;
                logoDiv.style.display = 'flex';
                const size = (item.logo_tamanho || 100) * 1.5;
                logoDiv.style.width = size+'px'; logoDiv.style.height = size+'px';
                
                if(item.logo_pos_x && item.logo_pos_x !== 'default') {
                    logoDiv.style.left=item.logo_pos_x; logoDiv.style.top=item.logo_pos_y; logoDiv.style.right='auto';
                } else {
                    logoDiv.style.top='40px'; logoDiv.style.right='40px'; logoDiv.style.left='';
                }
            } else { logoDiv.style.display='none'; }

            // 5. TEXTO EXTRA
            const extDiv = document.getElementById('elExtra');
            if(item.extra_texto) {
                extDiv.innerText = item.extra_texto;
                extDiv.style.color = item.extra_cor;
                extDiv.style.fontSize = (item.extra_tamanho * 1.5) + 'px';
                extDiv.style.display = 'block';
                if(item.extra_pos_x && item.extra_pos_x !== 'center') {
                    extDiv.style.left=item.extra_pos_x; extDiv.style.top=item.extra_pos_y;
                } else {
                    extDiv.style.left='50%'; extDiv.style.top='80%';
                }
            } else { extDiv.style.display='none'; }

            // 6. FUNDO
            app.style.background = ''; // Reseta
            if(item.bg_tipo === 'cor') { app.style.background = item.bg_valor; }
            else if(item.bg_tipo === 'imagem') { app.style.background = `url('${item.bg_valor}') center/cover`; }

            // 7. VALIDADE
            const valDiv = document.getElementById('elValidade');
            if(item.data_validade && item.data_validade !== '0000-00-00') { 
                const d = item.data_validade.split('-'); 
                valDiv.innerText=`Válido até ${d[2]}/${d[1]}`; 
            } else { valDiv.innerText=""; }

            // Fade In
            app.style.opacity = 1;

            // Próximo
            index++;
            
            // Se chegou ao fim, recarrega dados do servidor antes de reiniciar
            if(index >= playlist.length) {
                setTimeout(() => { carregar(); }, CONFIG.tempoSlide);
            } else {
                setTimeout(rodar, CONFIG.tempoSlide);
            }

        }, 800);
    }

    carregar();
</script>
</body>
</html>