<?php
// buscador.php - VERS01O POTENTE (cURL)
header('Content-Type: application/json');
// Ignora erros de aviso para n00o sujar o JSON
error_reporting(0);

$termo = $_GET['termo'] ?? '';

if (!$termo) {
    echo json_encode([]);
    exit;
}

// Monta a URL de busca (Adiciona "png transparente" para melhorar resultados)
$query = urlencode($termo . " png fundo transparente");
$url = "https://www.google.com/search?q={$query}&tbm=isch&tbs=ic:trans"; // tbs=ic:trans for04a transparncia

// --- IN01CIO DO cURL (Simula um navegador real) ---
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
// Desabilita verifica0400o SSL (ajuda em servidores locais/XAMPP)
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
// User Agent de um Chrome atualizado (Fundamental para n00o ser bloqueado)
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
// Headers adicionais para parecer humano
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
    'Accept-Language: pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7',
]);

$html = curl_exec($ch);
curl_close($ch);
// --- FIM DO cURL ---

$imagens = [];

if ($html) {
    // PADR01O 1: Busca links diretos de imagens (http...png)
    // O Google mistura os links no meio de um JSON gigante no HTML
    preg_match_all('/"(https?:\/\/[^"]+?\.png)"/i', $html, $matchesPng);
    
    if (!empty($matchesPng[1])) {
        $imagens = $matchesPng[1];
    } 
    
    // PADR01O 2: Se achou poucos PNGs, pega JPGs tambm (fallback)
    if (count($imagens) < 5) {
        preg_match_all('/"(https?:\/\/[^"]+?\.jpg)"/i', $html, $matchesJpg);
        if (!empty($matchesJpg[1])) {
            $imagens = array_merge($imagens, $matchesJpg[1]);
        }
    }
}

// Remove duplicatas e pega os primeiros 20 resultados
$resultadoFinal = array_slice(array_unique($imagens), 0, 20);

// Se n00o achou nada, retorna array vazio
echo json_encode(array_values($resultadoFinal));
?>